/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.inventory;

import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.FileSuffixFilter;
import ivorius.reccomplex.files.RCFileHelper;
import ivorius.reccomplex.worldgen.inventory.GenericItemCollection;
import ivorius.reccomplex.worldgen.inventory.GenericItemCollectionRegistry;
import ivorius.reccomplex.worldgen.inventory.InventoryLoadException;
import ivorius.reccomplex.worldgen.inventory.WeightedItemCollectionRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ItemCollectionSaveHandler {
    public static final String FILE_SUFFIX = "rcig";
    private static List<String> importedCustomGenerators = new ArrayList<String>();

    public static void reloadAllCustomInventoryGenerators() {
        for (String generator : importedCustomGenerators) {
            WeightedItemCollectionRegistry.unregister(generator);
        }
        importedCustomGenerators.clear();
        File structuresFile = IvFileHelper.getValidatedFolder((File)RecurrentComplex.proxy.getBaseFolderFile("structures"));
        if (structuresFile != null) {
            ItemCollectionSaveHandler.tryAddAllItemCollectionsInDirectory(RCFileHelper.getValidatedFolder(structuresFile, "active", true), "", true, true);
            ItemCollectionSaveHandler.tryAddAllItemCollectionsInDirectory(RCFileHelper.getValidatedFolder(structuresFile, "inactive", true), "", false, true);
            ItemCollectionSaveHandler.tryAddAllItemCollectionsInDirectory(RCFileHelper.getValidatedFolder(structuresFile, "inventoryGenerators", false), "", true, true);
        }
    }

    public static void loadInventoryGeneratorsFromMod(String modid) {
        modid = modid.toLowerCase();
        ItemCollectionSaveHandler.tryAddAllItemCollectionsInResourceLocation(new ResourceLocation(modid, "structures/active"), true, false);
        ItemCollectionSaveHandler.tryAddAllItemCollectionsInResourceLocation(new ResourceLocation(modid, "structures/inactive"), false, false);
        ItemCollectionSaveHandler.tryAddAllItemCollectionsInResourceLocation(new ResourceLocation(modid, "structures/inventoryGenerators"), true, false);
    }

    protected static void tryAddAllItemCollectionsInResourceLocation(ResourceLocation resourceLocation, boolean generating, boolean imported) {
        try {
            Path path = RCFileHelper.pathFromResourceLocation(resourceLocation);
            if (path != null) {
                ItemCollectionSaveHandler.loadAllInventoryGeneratorsInDirectory(path, resourceLocation.func_110624_b(), generating, imported);
            }
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error reading from resource location '" + resourceLocation + "'", e);
        }
    }

    protected static void tryAddAllItemCollectionsInDirectory(File file, String domain, boolean generating, boolean imported) {
        if (file != null) {
            try {
                ItemCollectionSaveHandler.loadAllInventoryGeneratorsInDirectory(file.toPath(), domain, generating, imported);
            }
            catch (Throwable e) {
                RecurrentComplex.logger.error("Error reading from directory '" + file + "'", e);
            }
        }
    }

    public static void loadAllInventoryGeneratorsInDirectory(Path directory, String domain, boolean generating, boolean imported) throws IOException {
        List<Path> paths = RCFileHelper.listFilesRecursively(directory, new FileSuffixFilter(FILE_SUFFIX, "json"), true);
        for (Path file : paths) {
            try {
                GenericItemCollection.Component component = ItemCollectionSaveHandler.readInventoryGenerator(file);
                String name = FilenameUtils.getBaseName((String)file.getFileName().toString());
                if (component.inventoryGeneratorID == null || component.inventoryGeneratorID.length() == 0) {
                    component.inventoryGeneratorID = name;
                }
                GenericItemCollectionRegistry.register(component, name, domain, generating);
                if (!imported) continue;
                importedCustomGenerators.add(name);
            }
            catch (InventoryLoadException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean saveInventoryGenerator(GenericItemCollection.Component info, String name) {
        File inventoryGeneratorsFile;
        File structuresFile = IvFileHelper.getValidatedFolder((File)RecurrentComplex.proxy.getBaseFolderFile("structures"));
        if (structuresFile != null && (inventoryGeneratorsFile = IvFileHelper.getValidatedFolder((File)structuresFile, (String)"active")) != null) {
            File newFile = new File(inventoryGeneratorsFile, String.format("%s.%s", name, FILE_SUFFIX));
            String json = GenericItemCollectionRegistry.createJSONFromComponent(info);
            try {
                FileUtils.writeStringToFile((File)newFile, (String)json);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return newFile.exists();
        }
        return false;
    }

    public static GenericItemCollection.Component readInventoryGenerator(ResourceLocation resourceLocation) {
        try {
            String json = IOUtils.toString((InputStream)IvFileHelper.inputStreamFromResourceLocation((ResourceLocation)resourceLocation), (String)"UTF-8");
            return GenericItemCollectionRegistry.createComponentFromJSON(json);
        }
        catch (Exception ex) {
            RecurrentComplex.logger.error("Could not read inventory generator " + resourceLocation.toString(), (Throwable)ex);
            return null;
        }
    }

    public static GenericItemCollection.Component readInventoryGenerator(Path file) throws IOException, InventoryLoadException {
        return GenericItemCollectionRegistry.createComponentFromJSON(new String(Files.readAllBytes(file)));
    }
}

