/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class ChestBuilder {
    public static final String DUNGEON = "dungeonChest";
    public static final String TOWER = "DeadlyWorld.towerChest";
    public static final String SILVER_NEST = "DeadlyWorld.silverfishNestChest";
    public static final String SPAWNER = "DeadlyWorld.spawnerChest";
    public static final String SPAWNER_ARMORED = "DeadlyWorld.spawnerChestArmored";
    public static final String SPAWNER_BRUTAL = "DeadlyWorld.spawnerChestBrutal";
    public static final String SPAWNER_SWARM = "DeadlyWorld.spawnerChestSwarm";
    public static final String SPAWNER_TRAP = "DeadlyWorld.spawnerTrap";
    public static final String CHEST_VALUABLE = "DeadlyWorld.chestRogueValuable";
    public static final String[] CHEST_ROGUE = new String[5];
    public Random random;
    public TileEntityChest chest;
    public boolean isValid;

    public static WeightedRandomChestContent loot(Item item, int damage, int min, int max, int weight) {
        return new WeightedRandomChestContent(item, damage, min, max, weight);
    }

    public static WeightedRandomChestContent loot(Block block, int damage, int min, int max, int weight) {
        return ChestBuilder.loot(new ItemStack(block, 1, damage), min, max, weight);
    }

    public static WeightedRandomChestContent loot(ItemStack item, int min, int max, int weight) {
        return new WeightedRandomChestContent(item, min, max, weight);
    }

    public static void setCategoryStats(ChestGenHooks category, int min, int max, WeightedRandomChestContent[] contents) {
        category.setMin(min);
        category.setMax(max);
        for (WeightedRandomChestContent item : contents) {
            category.addItem(item);
        }
    }

    public static String getRogueChestByHeight(int y) {
        if (y < 20) {
            return CHEST_ROGUE[4];
        }
        if (y < 28) {
            return CHEST_ROGUE[3];
        }
        if (y < 38) {
            return CHEST_ROGUE[2];
        }
        if (y < 48) {
            return CHEST_ROGUE[1];
        }
        return CHEST_ROGUE[0];
    }

    public static void place(World world, Random random, int x, int y, int z, String loot) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 2);
        ChestBuilder chest = new ChestBuilder(world, random, x, y, z);
        if (chest.isValid) {
            chest.fill(loot);
        }
        world.func_147471_g(x, y, z);
    }

    public static void placeTrapped(World world, Random random, int x, int y, int z, String loot) {
        world.func_147465_d(x, y, z, Blocks.field_150447_bR, 0, 2);
        ChestBuilder chest = new ChestBuilder(world, random, x, y, z);
        if (chest.isValid) {
            chest.fill(loot);
        }
        world.func_147471_g(x, y, z);
    }

    public static void init() {
    }

    public ChestBuilder(World world, Random rand, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityChest) {
            this.random = rand;
            this.chest = (TileEntityChest)tileEntity;
            this.isValid = true;
        }
    }

    public ChestBuilder(TileEntityChest tileEntity, Random rand) {
        this.chest = tileEntity;
        if (this.chest != null) {
            this.random = rand;
            this.isValid = true;
        }
    }

    public void fill(String loot) {
        ChestGenHooks info = ChestGenHooks.getInfo((String)loot);
        WeightedRandomChestContent.func_76293_a((Random)this.random, (WeightedRandomChestContent[])info.getItems(this.random), (IInventory)this.chest, (int)info.getCount(this.random));
    }

    static {
        int i = CHEST_ROGUE.length;
        while (i-- > 0) {
            ChestBuilder.CHEST_ROGUE[i] = "DeadlyWorld.chestRogueTier" + Integer.toString(i);
        }
        ArrayList<WeightedRandomChestContent> list = new ArrayList<WeightedRandomChestContent>();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 3, 5));
        list.add(ChestBuilder.loot(Items.field_151074_bl, 0, 4, 9, 5));
        list.add(ChestBuilder.loot(Items.field_151145_ak, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151008_G, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151025_P, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151032_g, 0, 4, 12, 20));
        list.add(ChestBuilder.loot((Item)Items.field_151031_f, 0, 1, 1, 2));
        list.add(ChestBuilder.loot(Items.field_151059_bz, 0, 1, 5, 5));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 1, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)TOWER), 2, 5, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151014_N, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151080_bb, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151081_bc, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151100_aR, 3, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151074_bl, 0, 4, 9, 5));
        list.add(ChestBuilder.loot(Items.field_151103_aS, 0, 4, 6, 15));
        list.add(ChestBuilder.loot(Items.field_151100_aR, 15, 8, 14, 20));
        list.add(ChestBuilder.loot(Items.field_151078_bh, 0, 3, 7, 20));
        list.add(ChestBuilder.loot(Items.field_151007_F, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151016_H, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 1, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)SILVER_NEST), 1, 6, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151045_i, 0, 1, 2, 3));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151137_ax, 0, 4, 9, 5));
        list.add(ChestBuilder.loot(Items.field_151103_aS, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151032_g, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151078_bh, 0, 3, 7, 10));
        list.add(ChestBuilder.loot(Items.field_151007_F, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151016_H, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151079_bi, 0, 1, 1, 10));
        list.add(ChestBuilder.loot(Items.field_151025_P, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151153_ao, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151105_aU, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151057_cb, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151138_bX, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151035_b, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151040_l, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151030_Z, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151028_Y, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151165_aa, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151167_ab, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 1, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)SPAWNER), 4, 4, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151062_by, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151045_i, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151166_bC, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151137_ax, 0, 4, 9, 5));
        list.add(ChestBuilder.loot(Items.field_151100_aR, 4, 4, 9, 5));
        list.add(ChestBuilder.loot(Items.field_151044_h, 0, 3, 8, 10));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151153_ao, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151057_cb, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 3));
        list.add(ChestBuilder.loot(Items.field_151138_bX, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151136_bY, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151125_bZ, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151046_w, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151048_u, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151163_ad, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151161_ac, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151173_ae, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151175_af, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 3));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 3, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)SPAWNER_ARMORED), 6, 6, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151062_by, 0, 2, 4, 10));
        list.add(ChestBuilder.loot(Items.field_151144_bL, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151144_bL, 1, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151144_bL, 2, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151144_bL, 3, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151144_bL, 4, 1, 1, 1));
        list.add(ChestBuilder.loot(Blocks.field_150335_W, 0, 1, 1, 2));
        list.add(ChestBuilder.loot(Items.field_151045_i, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151166_bC, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151153_ao, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151057_cb, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 3));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151138_bX, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151136_bY, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151125_bZ, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 3));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 3, 3));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)SPAWNER_BRUTAL), 5, 5, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151062_by, 0, 2, 4, 10));
        list.add(ChestBuilder.loot(Items.field_151063_bx, 50, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151063_bx, 51, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151063_bx, 52, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151063_bx, 54, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151063_bx, 55, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151063_bx, 58, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151063_bx, 59, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151063_bx, 60, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151045_i, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151166_bC, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151153_ao, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151057_cb, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 3));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151138_bX, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151136_bY, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151125_bZ, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 3));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 3, 3));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)SPAWNER_SWARM), 5, 5, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot((Block)Blocks.field_150479_bC, 0, 2, 2, 2));
        list.add(ChestBuilder.loot((Block)Blocks.field_150453_bW, 0, 1, 1, 2));
        list.add(ChestBuilder.loot(Blocks.field_150429_aA, 0, 3, 7, 5));
        list.add(ChestBuilder.loot(Items.field_151107_aW, 0, 1, 5, 3));
        list.add(ChestBuilder.loot(Items.field_151132_bS, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Blocks.field_150335_W, 0, 1, 1, 2));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 5));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 3, 5));
        list.add(ChestBuilder.loot(Items.field_151137_ax, 0, 4, 9, 10));
        list.add(ChestBuilder.loot(Items.field_151103_aS, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151032_g, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151078_bh, 0, 3, 7, 10));
        list.add(ChestBuilder.loot(Items.field_151007_F, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151016_H, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151079_bi, 0, 1, 1, 10));
        list.add(ChestBuilder.loot(Items.field_151025_P, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151153_ao, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151105_aU, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151057_cb, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151138_bX, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151035_b, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151040_l, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151030_Z, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151028_Y, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151165_aa, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151167_ab, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 1, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)SPAWNER_TRAP), 4, 4, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151062_by, 0, 1, 3, 10));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8225, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8226, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8259, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8229, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8262, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8265, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8270, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8269, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151045_i, 0, 1, 3, 5));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151044_h, 0, 3, 8, 10));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151153_ao, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151057_cb, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 3));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151138_bX, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151136_bY, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151125_bZ, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151035_b, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151040_l, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151030_Z, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151028_Y, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151165_aa, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151167_ab, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 3));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 3, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)CHEST_VALUABLE), 10, 10, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Blocks.field_150347_e, 0, 8, 24, 5));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151074_bl, 0, 4, 9, 3));
        list.add(ChestBuilder.loot(Items.field_151044_h, 0, 3, 8, 5));
        list.add(ChestBuilder.loot(Items.field_151103_aS, 0, 4, 6, 15));
        list.add(ChestBuilder.loot(Items.field_151078_bh, 0, 3, 7, 15));
        list.add(ChestBuilder.loot(Items.field_151032_g, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151025_P, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151039_o, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151041_m, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151027_R, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151024_Q, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151026_S, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151021_T, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 1, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)CHEST_ROGUE[0]), 2, 4, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8193, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8194, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8195, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8197, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8198, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8201, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8206, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8237, 1, 1, 1));
        list.add(ChestBuilder.loot(Blocks.field_150347_e, 0, 8, 24, 3));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 5));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 3, 5));
        list.add(ChestBuilder.loot(Items.field_151074_bl, 0, 4, 9, 5));
        list.add(ChestBuilder.loot(Items.field_151137_ax, 0, 4, 9, 5));
        list.add(ChestBuilder.loot(Items.field_151044_h, 0, 3, 8, 10));
        list.add(ChestBuilder.loot(Items.field_151103_aS, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151078_bh, 0, 3, 7, 10));
        list.add(ChestBuilder.loot(Items.field_151032_g, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151025_P, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151138_bX, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151005_D, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151010_B, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151171_ah, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151169_ag, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151149_ai, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151151_aj, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151159_an, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 1));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 1, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)CHEST_ROGUE[1]), 2, 4, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot(Blocks.field_150478_aa, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Blocks.field_150347_e, 0, 8, 24, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8193, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8194, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8195, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8197, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8198, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8201, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8206, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8237, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 3, 5));
        list.add(ChestBuilder.loot(Items.field_151137_ax, 0, 4, 9, 5));
        list.add(ChestBuilder.loot(Items.field_151044_h, 0, 3, 8, 10));
        list.add(ChestBuilder.loot(Items.field_151032_g, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151025_P, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151153_ao, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151057_cb, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 3));
        list.add(ChestBuilder.loot(Items.field_151138_bX, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151136_bY, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151050_s, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151052_q, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151023_V, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151020_U, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151022_W, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151029_X, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151159_an, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 3));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 1, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)CHEST_ROGUE[2]), 3, 5, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8193, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8194, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8195, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8197, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8198, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8201, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8206, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8237, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151045_i, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 3, 10));
        list.add(ChestBuilder.loot(Items.field_151137_ax, 0, 4, 9, 5));
        list.add(ChestBuilder.loot(Items.field_151044_h, 0, 3, 8, 10));
        list.add(ChestBuilder.loot(Items.field_151032_g, 0, 4, 12, 10));
        list.add(ChestBuilder.loot(Items.field_151172_bF, 0, 1, 3, 5));
        list.add(ChestBuilder.loot(Items.field_151174_bG, 0, 1, 3, 5));
        list.add(ChestBuilder.loot(Items.field_151025_P, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151153_ao, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151057_cb, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151138_bX, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151136_bY, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151125_bZ, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151035_b, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151040_l, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151030_Z, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151028_Y, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151165_aa, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151167_ab, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151159_an, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 1, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)CHEST_ROGUE[3]), 4, 6, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8193, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8194, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8195, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8197, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8198, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8201, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8206, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151068_bn, 8237, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151042_j, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151043_k, 0, 1, 5, 10));
        list.add(ChestBuilder.loot(Items.field_151103_aS, 0, 4, 6, 10));
        list.add(ChestBuilder.loot(Items.field_151078_bh, 0, 3, 7, 10));
        list.add(ChestBuilder.loot(Items.field_151079_bi, 0, 1, 1, 10));
        list.add(ChestBuilder.loot(Items.field_151025_P, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151034_e, 0, 1, 3, 15));
        list.add(ChestBuilder.loot(Items.field_151153_ao, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151105_aU, 0, 1, 1, 3));
        list.add(ChestBuilder.loot(Items.field_151057_cb, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151058_ca, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151141_av, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151033_d, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151005_D, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151010_B, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151171_ah, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151169_ag, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151149_ai, 0, 1, 1, 5));
        list.add(ChestBuilder.loot((Item)Items.field_151151_aj, 0, 1, 1, 5));
        list.add(ChestBuilder.loot(Items.field_151159_an, 0, 1, 1, 1));
        list.add(ChestBuilder.loot(Items.field_151123_aH, 0, 1, 3, 3));
        list.add(ChestBuilder.loot(Items.field_151133_ar, 0, 1, 1, 1));
        list.add(ChestBuilder.loot((Item)Items.field_151134_bR, 0, 1, 1, 1));
        ChestBuilder.setCategoryStats(ChestGenHooks.getInfo((String)CHEST_ROGUE[4]), 2, 4, list.toArray(new WeightedRandomChestContent[0]));
        list.clear();
    }
}

