/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.SpawnerItemCreeper;
import toast.deadlyWorld.feature.SpawnerItemRandom;

public class TagBuilder {
    public static final int MAX_DELAY = 800;
    public static final int MIN_DELAY = 200;
    public static final int MAX_NEARBY = 6;
    public static final int PLAYER_RANGE = 16;
    public static final int SPAWN_COUNT = 4;
    public static final int SPAWN_RANGE = 4;
    public NBTTagCompound spawnerTag;

    public TagBuilder(NBTTagCompound tag) {
        this.spawnerTag = tag;
    }

    public void setType(String type) {
        this.spawnerTag.func_74778_a("EntityId", type);
    }

    public void setDelay(int delay) {
        if (delay == 20) {
            this.spawnerTag.func_82580_o("Delay");
        } else {
            this.spawnerTag.func_74777_a("Delay", (short)delay);
        }
    }

    public void setMinDelay(int min) {
        if (min == 200) {
            this.spawnerTag.func_82580_o("MinSpawnDelay");
        } else {
            this.spawnerTag.func_74777_a("MinSpawnDelay", (short)min);
        }
    }

    public void setMaxDelay(int max) {
        if (max == 800) {
            this.spawnerTag.func_82580_o("MaxSpawnDelay");
        } else {
            this.spawnerTag.func_74777_a("MaxSpawnDelay", (short)max);
        }
    }

    public void setMinAndMaxDelay(int min, int max) {
        this.setMinDelay(min);
        this.setMaxDelay(max);
    }

    public void setSpawnCount(int count) {
        if (count == 4) {
            this.spawnerTag.func_82580_o("SpawnCount");
        } else {
            this.spawnerTag.func_74777_a("SpawnCount", (short)count);
        }
    }

    public void setMaxNearbyEntities(int max) {
        if (max == 6) {
            this.spawnerTag.func_82580_o("MaxNearbyEntities");
        } else {
            this.spawnerTag.func_74777_a("MaxNearbyEntities", (short)max);
        }
    }

    public void setPlayerRange(int range) {
        if (range == 16) {
            this.spawnerTag.func_82580_o("RequiredPlayerRange");
        } else {
            this.spawnerTag.func_74777_a("RequiredPlayerRange", (short)range);
        }
    }

    public void setSpawnRange(int range) {
        if (range == 4) {
            this.spawnerTag.func_82580_o("SpawnRange");
        } else {
            this.spawnerTag.func_74777_a("SpawnRange", (short)range);
        }
    }

    public void setSpawnData(NBTTagCompound data) {
        if (data == null) {
            this.spawnerTag.func_82580_o("SpawnData");
        } else {
            this.spawnerTag.func_74782_a("SpawnData", data.func_74737_b());
        }
    }

    public void setPotentials(String[] types, int[] weights, NBTTagCompound[] properties) {
        if (types == null) {
            this.spawnerTag.func_82580_o("SpawnPotentials");
            return;
        }
        int length = types.length;
        if (length == 0 || length != weights.length || length != properties.length) {
            this.spawnerTag.func_82580_o("SpawnPotentials");
            return;
        }
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < length; ++i) {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74778_a("Type", types[i]);
            entry.func_74768_a("Weight", weights[i]);
            entry.func_74782_a("Properties", properties[i].func_74737_b());
            tagList.func_74742_a((NBTBase)entry);
        }
        this.spawnerTag.func_74782_a("SpawnPotentials", (NBTBase)tagList);
    }

    public static NBTTagList adjustPotentials(NBTTagList potentials, double x, double y, double z) {
        int length;
        int i = length = potentials.func_74745_c();
        while (i-- > 0) {
            NBTTagCompound tag = potentials.func_150305_b(i);
            if (!tag.func_74764_b("Properties")) continue;
            TagBuilder.adjustSpawnData(tag.func_74775_l("Properties"), x, y, z);
        }
        return potentials;
    }

    public static NBTTagCompound adjustSpawnData(NBTTagCompound spawnData, double x, double y, double z) {
        if (spawnData.func_74764_b("Pos")) {
            NBTTagList pos = spawnData.func_150295_c("Pos", (int)new NBTTagDouble(0.0).func_74732_a());
            spawnData.func_74782_a("Pos", (NBTBase)TagBuilder.doubleNBTTagList(pos.func_150309_d(0) + x, pos.func_150309_d(1) + y, pos.func_150309_d(2) + z));
        }
        return spawnData;
    }

    public static void setHealth(NBTTagCompound tag, float health) {
        tag.func_74776_a("HealF", health);
    }

    public static void setDespawning(NBTTagCompound tag, boolean despawn) {
        tag.func_74757_a("PersistenceRequired", !despawn);
    }

    public static void setEquipment(NBTTagCompound tag, ItemStack ... equipment) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < 5; ++i) {
            NBTTagCompound data = new NBTTagCompound();
            if (equipment[i] != null) {
                equipment[i].func_77955_b(data);
            }
            tagList.func_74742_a((NBTBase)data);
        }
        tag.func_74782_a("Equipment", (NBTBase)tagList);
    }

    public static void setDropChances(NBTTagCompound tag, float ... chances) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < 5; ++i) {
            tagList.func_74742_a((NBTBase)new NBTTagFloat(chances[i]));
        }
        tag.func_74782_a("DropChances", (NBTBase)tagList);
    }

    public static void setPosition(NBTTagCompound tag, double x, double y, double z) {
        tag.func_74782_a("Pos", (NBTBase)TagBuilder.doubleNBTTagList(x, y, z));
    }

    public static void setMotion(NBTTagCompound tag, double x, double y, double z) {
        tag.func_74782_a("Motion", (NBTBase)TagBuilder.doubleNBTTagList(x, y, z));
    }

    public static void setFireballHeading(NBTTagCompound tag, double x, double y, double z) {
        tag.func_74782_a("direction", (NBTBase)TagBuilder.doubleNBTTagList(x, y, z));
    }

    public static NBTTagList doubleNBTTagList(double ... data) {
        NBTTagList tagList = new NBTTagList();
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            tagList.func_74742_a((NBTBase)new NBTTagDouble(data[i]));
        }
        return tagList;
    }

    public static NBTTagCompound potion(int damage) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Potion", (NBTBase)new ItemStack((Item)Items.field_151068_bn, 1, damage).func_77955_b(new NBTTagCompound()));
        return tag;
    }

    public static NBTTagCompound potion(ItemStack potion) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Potion", (NBTBase)potion.func_77955_b(new NBTTagCompound()));
        return tag;
    }

    public static ItemStack addPotionEffect(ItemStack itemStack, Potion potion, int duration, int amplifier) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        if (!itemStack.field_77990_d.func_74764_b("CustomPotionEffects")) {
            itemStack.field_77990_d.func_74782_a("CustomPotionEffects", (NBTBase)new NBTTagList());
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (potion.field_76415_H != 0) {
            tag.func_74774_a("Id", (byte)potion.field_76415_H);
        }
        if (duration != 0) {
            tag.func_74768_a("Duration", duration);
        }
        if (amplifier != 0) {
            tag.func_74774_a("Amplifier", (byte)amplifier);
        }
        itemStack.field_77990_d.func_150295_c("CustomPotionEffects", (int)tag.func_74732_a()).func_74742_a((NBTBase)tag);
        return itemStack;
    }

    public static void addPotionEffect(NBTTagCompound tag, Potion potion, int amplifier) {
        TagBuilder.addPotionEffect(tag, potion, Integer.MAX_VALUE, amplifier, false);
    }

    public static void addPotionEffect(NBTTagCompound tag, Potion potion, int amplifier, boolean ambient) {
        TagBuilder.addPotionEffect(tag, potion, Integer.MAX_VALUE, amplifier, ambient);
    }

    public static void addPotionEffect(NBTTagCompound tag, Potion potion, int duration, int amplifier) {
        TagBuilder.addPotionEffect(tag, potion, duration, amplifier, false);
    }

    public static void addPotionEffect(NBTTagCompound tag, Potion potion, int duration, int amplifier, boolean ambient) {
        if (!tag.func_74764_b("ActiveEffects")) {
            tag.func_74782_a("ActiveEffects", (NBTBase)new NBTTagList());
        }
        NBTTagCompound potionTag = new NBTTagCompound();
        if (potion.field_76415_H != 0) {
            potionTag.func_74774_a("Id", (byte)potion.field_76415_H);
        }
        if (duration != 0) {
            potionTag.func_74768_a("Duration", duration);
        }
        if (amplifier != 0) {
            potionTag.func_74774_a("Amplifier", (byte)amplifier);
        }
        if (ambient) {
            potionTag.func_74757_a("Ambient", ambient);
        }
        tag.func_150295_c("ActiveEffects", (int)potionTag.func_74732_a()).func_74742_a((NBTBase)potionTag);
    }

    public static NBTTagCompound fuse(int fuse) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("Fuse", (byte)fuse);
        return tag;
    }

    public static NBTTagCompound fallingBlock(Block block, int damage, int time) {
        return TagBuilder.fallingBlock(block, damage, time, false, 2.0f, 40, false, null);
    }

    public static NBTTagCompound fallingBlock(Block block, int damage, int time, float fallDamage) {
        return TagBuilder.fallingBlock(block, damage, time, true, fallDamage, 40, false, null);
    }

    public static NBTTagCompound fallingBlock(Block block, int damage, int time, boolean hurtEntities, float fallDamage, int maxFallDamage, boolean dropItem, NBTTagCompound tileData) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("Tile", (byte)Block.func_149682_b((Block)block));
        tag.func_74768_a("TileID", Block.func_149682_b((Block)block));
        tag.func_74774_a("Data", (byte)damage);
        tag.func_74774_a("Time", (byte)time);
        tag.func_74757_a("DropItem", dropItem);
        tag.func_74757_a("HurtEntities", hurtEntities);
        tag.func_74776_a("FallHurtAmount", fallDamage);
        tag.func_74768_a("FallHurtMax", maxFallDamage);
        if (tileData != null) {
            tag.func_74782_a("TileEntityData", (NBTBase)tileData);
        }
        return tag;
    }

    public static NBTTagCompound createMobSpawner(String type) {
        return TagBuilder.createMobSpawner("", type);
    }

    public static NBTTagCompound createMobSpawner(String name, String type) {
        TagBuilder tag = new TagBuilder(new NBTTagCompound());
        tag.setType(type);
        return tag.spawnerTag;
    }

    public static NBTTagCompound createMobSpawnerCreeper(String name) {
        TagBuilder tag = new TagBuilder(new NBTTagCompound());
        tag.setType("Creeper");
        if (SpawnerItemCreeper.CHARGED_CHANCE > 0 && SpawnerItemCreeper.CHARGED_CHANCE < 100) {
            String[] types = new String[]{"Creeper", "Creeper"};
            int[] weights = new int[]{100 - SpawnerItemCreeper.CHARGED_CHANCE, SpawnerItemCreeper.CHARGED_CHANCE};
            NBTTagCompound[] properties = new NBTTagCompound[]{new NBTTagCompound(), (NBTTagCompound)SpawnerItemCreeper.CHARGED_TAG.func_74737_b()};
            tag.setPotentials(types, weights, properties);
        }
        return tag.spawnerTag;
    }

    public static NBTTagCompound createMobSpawnerRandom(String name) {
        TagBuilder tag = new TagBuilder(new NBTTagCompound());
        boolean weightCheck = false;
        int length = SpawnerItemRandom.weights.length;
        NBTTagCompound[] properties = new NBTTagCompound[length];
        int i = length;
        while (i-- > 0) {
            properties[i] = new NBTTagCompound();
            if (_DeadlyWorld.MOBS[i] == "Skeleton") {
                TagBuilder.setEquipment(properties[i], new ItemStack((Item)Items.field_151031_f), null, null, null, null);
            }
            if (weightCheck || SpawnerItemRandom.weights[i] <= 0) continue;
            weightCheck = true;
        }
        if (weightCheck) {
            tag.setPotentials(_DeadlyWorld.MOBS, SpawnerItemRandom.weights, properties);
        } else {
            tag.setType("Zombie");
        }
        return tag.spawnerTag;
    }

    public static NBTTagCompound createMobSpawnerTrap(String type) {
        TagBuilder tag = new TagBuilder(new NBTTagCompound());
        tag.spawnerTag = type.equalsIgnoreCase("RANDOM") ? TagBuilder.createMobSpawnerRandom("spawner_trap") : (type.equalsIgnoreCase("CREEPER") ? TagBuilder.createMobSpawnerCreeper("spawner_trap") : TagBuilder.createMobSpawner("spawner_trap", type));
        NBTTagCompound data = tag.spawnerTag.func_74775_l("SpawnData");
        if (!tag.spawnerTag.func_74764_b("SpawnData")) {
            tag.spawnerTag.func_74782_a("SpawnData", (NBTBase)data);
            if (tag.spawnerTag.func_74779_i("EntityId") == "Skeleton") {
                TagBuilder.setEquipment(data, new ItemStack((Item)Items.field_151031_f), null, null, null, null);
            }
        }
        data = TagBuilder.applyTNTHat(tag.spawnerTag.func_74779_i("EntityId"), data);
        if (tag.spawnerTag.func_74764_b("SpawnPotentials")) {
            int length;
            NBTTagList potentials = tag.spawnerTag.func_150295_c("SpawnPotentials", (int)new NBTTagCompound().func_74732_a());
            int i = length = potentials.func_74745_c();
            while (i-- > 0) {
                NBTTagCompound tagEntry = potentials.func_150305_b(i);
                if (tagEntry.func_74764_b("Properties")) {
                    NBTTagCompound potentialData = tagEntry.func_74775_l("Properties");
                    potentialData = TagBuilder.applyTNTHat(tagEntry.func_74779_i("Type"), potentialData);
                    TagBuilder.setPosition(potentialData, 0.5, 1.0, 0.5);
                    tagEntry.func_74782_a("Properties", (NBTBase)potentialData);
                }
                tagEntry.func_74778_a("Type", "PrimedTnt");
            }
        }
        TagBuilder.setPosition(data, 0.5, 1.0, 0.5);
        tag.setType("PrimedTnt");
        tag.setDelay(0);
        tag.setSpawnRange(0);
        tag.setPlayerRange(4);
        tag.setSpawnCount(1);
        tag.setSpawnData(data);
        return tag.spawnerTag;
    }

    private static NBTTagCompound applyTNTHat(String id, NBTTagCompound tag) {
        NBTTagCompound tntTag = TagBuilder.fuse(80);
        tag.func_74778_a("id", id);
        TagBuilder.setMotion(tag, 0.0, 0.3, 0.0);
        TagBuilder.addPotionEffect(tag, Potion.field_76424_c, 1);
        TagBuilder.addPotionEffect(tag, Potion.field_76429_m, -6);
        tntTag.func_74782_a("Riding", (NBTBase)tag);
        return tntTag;
    }

    public static NBTTagCompound createArrowSpawner(boolean onFire) {
        TagBuilder tag = new TagBuilder(new NBTTagCompound());
        String[] types = new String[48];
        int[] weights = new int[48];
        NBTTagCompound[] properties = new NBTTagCompound[48];
        NBTTagCompound baseTag = new NBTTagCompound();
        baseTag.func_74774_a("pickup", (byte)2);
        baseTag.func_74780_a("damage", Math.max(2.0, Properties.getDouble("towers", "_arrow_damage")));
        if (onFire) {
            baseTag.func_74777_a("Fire", (short)2000);
        }
        double step = 0.39269908169872414;
        double rotation = step / 2.0;
        double elevation = -0.15;
        int i = 48;
        while (i-- > 0) {
            double zOffset;
            double xOffset;
            types[i] = "Arrow";
            weights[i] = 1;
            properties[i] = (NBTTagCompound)baseTag.func_74737_b();
            double xMotion = MathHelper.func_76126_a((float)((float)(rotation += step)));
            double zMotion = MathHelper.func_76134_b((float)((float)rotation));
            if (Math.abs(xMotion) < Math.abs(zMotion)) {
                xOffset = xMotion * 0.6 + 0.5;
                zOffset = zMotion < 0.0 ? -0.1 : 1.1;
            } else if (Math.abs(xMotion) > Math.abs(zMotion)) {
                xOffset = xMotion < 0.0 ? -0.1 : 1.1;
                zOffset = zMotion * 0.6 + 0.5;
            } else {
                xOffset = xMotion < 0.0 ? -0.1 : 1.1;
                zOffset = zMotion < 0.0 ? -0.1 : 1.1;
            }
            TagBuilder.setPosition(properties[i], xOffset, elevation + 0.35, zOffset);
            TagBuilder.setMotion(properties[i], xMotion, elevation, zMotion);
            if (i % 16 != 0) continue;
            rotation += step / 2.0;
            elevation += 0.15;
        }
        tag.setType("Arrow");
        tag.setDelay(-1);
        tag.setMinAndMaxDelay(4, 8);
        tag.setSpawnCount(1);
        tag.setSpawnRange(-1);
        tag.setPlayerRange(8);
        tag.setSpawnData(baseTag);
        tag.setPotentials(types, weights, properties);
        return tag.spawnerTag;
    }

    public static NBTTagCompound createFireSpawner() {
        TagBuilder tag = new TagBuilder(new NBTTagCompound());
        String[] types = new String[48];
        int[] weights = new int[48];
        NBTTagCompound[] properties = new NBTTagCompound[48];
        NBTTagCompound baseTag = TagBuilder.fallingBlock((Block)Blocks.field_150480_ab, 0, 1, 1.0f);
        baseTag.func_74777_a("Fire", (short)2000);
        double step = 0.39269908169872414;
        double rotation = step / 2.0;
        double elevation = 0.1;
        int i = 48;
        while (i-- > 0) {
            types[i] = "FallingSand";
            weights[i] = 1;
            properties[i] = (NBTTagCompound)baseTag.func_74737_b();
            double xMotion = (double)MathHelper.func_76126_a((float)((float)(rotation += step))) * 0.2;
            double zMotion = (double)MathHelper.func_76134_b((float)((float)rotation)) * 0.2;
            TagBuilder.setPosition(properties[i], 0.5, 1.5, 0.5);
            TagBuilder.setMotion(properties[i], xMotion, elevation, zMotion);
            if (i % 16 != 0) continue;
            rotation += step / 2.0;
            elevation += 0.25;
        }
        tag.setType("FallingSand");
        tag.setMinAndMaxDelay(2, 4);
        tag.setSpawnCount(1);
        tag.setSpawnRange(-1);
        tag.setPlayerRange(5);
        tag.setSpawnData(baseTag);
        tag.setPotentials(types, weights, properties);
        return tag.spawnerTag;
    }

    public static NBTTagCompound createPotionSpawner(String type) {
        NBTTagCompound data;
        TagBuilder tag = new TagBuilder(new NBTTagCompound());
        if (type == "harm") {
            int potency = Math.max(0, Properties.getInt("potion_traps", "_harm_potency"));
            ItemStack itemStack = new ItemStack((Item)Items.field_151068_bn, 1, 16396);
            TagBuilder.addPotionEffect(itemStack, Potion.field_76433_i, 0, potency);
            data = TagBuilder.potion(itemStack);
        } else if (type == "poison") {
            int duration = Math.max(1, Properties.getInt("potion_traps", "_poison_duration"));
            int potency = Math.max(0, Properties.getInt("potion_traps", "_poison_potency"));
            ItemStack itemStack = new ItemStack((Item)Items.field_151068_bn, 1, 16388);
            TagBuilder.addPotionEffect(itemStack, Potion.field_76436_u, duration, potency);
            data = TagBuilder.potion(itemStack);
        } else if (type == "daze") {
            int duration = Math.max(1, Properties.getInt("potion_traps", "_daze_duration"));
            int potency = Math.max(0, Properties.getInt("potion_traps", "_daze_potency"));
            ItemStack itemStack = new ItemStack((Item)Items.field_151068_bn, 1, 16394);
            TagBuilder.addPotionEffect(TagBuilder.addPotionEffect(TagBuilder.addPotionEffect(TagBuilder.addPotionEffect(TagBuilder.addPotionEffect(itemStack, Potion.field_76437_t, duration, potency), Potion.field_76419_f, duration, potency), Potion.field_76421_d, duration >> 1, potency), Potion.field_76440_q, duration >> 2, 0), Potion.field_76439_r, duration >> 4, 0);
            data = TagBuilder.potion(itemStack);
        } else {
            return null;
        }
        TagBuilder.setPosition(data, 0.5, 1.1, 0.5);
        TagBuilder.setMotion(data, 0.0, 0.35, 0.0);
        tag.setType("ThrownPotion");
        tag.setMinAndMaxDelay(30, 50);
        tag.setSpawnRange(-1);
        tag.setPlayerRange(3);
        tag.setSpawnCount(1);
        tag.setSpawnData(data);
        return tag.spawnerTag;
    }

    public static NBTTagCompound createTNTSpawner() {
        TagBuilder tag = new TagBuilder(new NBTTagCompound());
        String[] types = new String[]{"PrimedTnt"};
        int[] weights = new int[]{1};
        NBTTagCompound[] properties = new NBTTagCompound[]{TagBuilder.fuse(50)};
        TagBuilder.setMotion(properties[0], 0.0, 0.4, 0.0);
        NBTTagCompound data = TagBuilder.fuse(50);
        TagBuilder.setPosition(data, 0.5, 0.5, 0.5);
        tag.setType("PrimedTnt");
        tag.setDelay(0);
        tag.setMinAndMaxDelay(5, 10);
        tag.setSpawnRange(2);
        tag.setPlayerRange(4);
        tag.setSpawnCount(1);
        tag.setMaxNearbyEntities(3);
        tag.setSpawnData(data);
        tag.setPotentials(types, weights, properties);
        return tag.spawnerTag;
    }

    public static NBTTagCompound createCaveInSpawner(String type) {
        TagBuilder tag = new TagBuilder(new NBTTagCompound());
        String[] types = new String[]{"FallingSand", "Fireball"};
        int[] weights = new int[]{24, 1};
        NBTTagCompound[] properties = new NBTTagCompound[2];
        if (type == "normal") {
            properties[0] = TagBuilder.fallingBlock(Blocks.field_150347_e, 0, 1, 1.5f);
        } else if (type == "silverfish") {
            properties[0] = TagBuilder.fallingBlock(Blocks.field_150418_aU, 1, 1, 1.5f);
        } else if (type == "gravel") {
            properties[0] = TagBuilder.fallingBlock(Blocks.field_150351_n, 0, 1, 1.0f);
        } else {
            return null;
        }
        properties[1] = new NBTTagCompound();
        properties[1].func_74768_a("ExplosionPower", 2);
        properties[1].func_74782_a("direction", (NBTBase)TagBuilder.doubleNBTTagList(0.0, -1.0, 0.0));
        TagBuilder.setPosition(properties[1], 0.5, 0.5, 0.5);
        tag.setType("FallingSand");
        tag.setDelay(50);
        tag.setMinAndMaxDelay(3, 6);
        tag.setSpawnRange(9);
        tag.setPlayerRange(7);
        tag.setSpawnCount(16);
        tag.setMaxNearbyEntities(Short.MAX_VALUE);
        tag.setSpawnData(properties[0]);
        tag.setPotentials(types, weights, properties);
        return tag.spawnerTag;
    }
}

