/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.BrutalSpawner;
import toast.deadlyWorld.feature.DeadlyWorldDungeon;
import toast.deadlyWorld.feature.FireTrap;
import toast.deadlyWorld.feature.Mine;
import toast.deadlyWorld.feature.PotionTrap;
import toast.deadlyWorld.feature.RogueBoss;
import toast.deadlyWorld.feature.RogueChest;
import toast.deadlyWorld.feature.RogueSpawner;
import toast.deadlyWorld.feature.SilverNest;
import toast.deadlyWorld.feature.SpawnerTrap;
import toast.deadlyWorld.feature.SwarmSpawner;
import toast.deadlyWorld.feature.Tower;
import toast.deadlyWorld.feature.VeinFeature;
import toast.deadlyWorld.feature.VeinLiquid;
import toast.deadlyWorld.feature.VeinSpawner;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;

public class WorldGenerator
implements IWorldGenerator {
    public static final WorldFeature[] features = WorldGenerator.buildFeaturesArray();

    public WorldGenerator() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)255);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!_DeadlyWorld.generation || world.field_72995_K) {
            return;
        }
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                WorldGenerator.run(world, random, chunkX << 4, chunkZ << 4);
                break;
            }
            case -1: {
                break;
            }
        }
    }

    public static void run(World world, Random random, int x, int z) {
        for (WorldFeature feature : features) {
            feature.generate(world, random, x, z);
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        int y = 63;
        while (!world.func_147437_c(x, y, z)) {
            ++y;
        }
    }

    public static void mark(World world, int x, int y, int z) {
        _DeadlyWorld.console("Marking! " + x + "," + z);
        while (y < 127) {
            world.func_147465_d(x, ++y, z, Blocks.field_150359_w, 0, 2);
        }
    }

    public static int getTotalWeight(WorldFeatureItem ... items) {
        int totalWeight = 0;
        for (WorldFeatureItem item : items) {
            totalWeight += item.getWeight();
        }
        return totalWeight;
    }

    public static int[] getWeights(String category, String ... properties) {
        int length = properties.length;
        int[] weights = new int[length];
        int i = length;
        while (i-- > 0) {
            weights[i] = Properties.getInt(category, properties[i].toLowerCase());
        }
        return weights;
    }

    public static int getTotalWeight(int ... weights) {
        int weight = 0;
        for (int i : weights) {
            weight += i;
        }
        return weight;
    }

    public static WorldFeatureItem choose(Random random, int totalWeight, WorldFeatureItem ... items) {
        if (totalWeight > 0) {
            totalWeight = random.nextInt(totalWeight);
            for (WorldFeatureItem item : items) {
                if ((totalWeight -= item.getWeight()) >= 0) continue;
                return item;
            }
        }
        return items[0];
    }

    public static String choose(Random random, int totalWeight, String[] items, int[] weights) {
        if (totalWeight > 0) {
            int length;
            totalWeight = random.nextInt(totalWeight);
            int i = length = items.length;
            while (i-- > 0) {
                if ((totalWeight -= weights[i]) >= 0) continue;
                return items[i];
            }
        }
        return items[0];
    }

    private static WorldFeature[] buildFeaturesArray() {
        ArrayList<WorldFeature> featuresList = new ArrayList<WorldFeature>();
        double property = Properties.getDouble("dungeons", "_place_attempts");
        if (property > 0.0) {
            featuresList.add(new DeadlyWorldDungeon(property));
        }
        if ((property = Properties.getDouble("_frequencies", "silverfish_nest")) > 0.0) {
            featuresList.add(new SilverNest(property));
        }
        if ((property = Properties.getDouble("_frequencies", "brutal_spawner")) > 0.0) {
            featuresList.add(new BrutalSpawner(property));
        }
        if ((property = Properties.getDouble("_frequencies", "swarm_spawner")) > 0.0) {
            featuresList.add(new SwarmSpawner(property));
        }
        if ((property = Properties.getDouble("_frequencies", "spawner")) > 0.0) {
            featuresList.add(new RogueSpawner(property));
        }
        if ((property = Properties.getDouble("_frequencies", "fire_trap")) > 0.0) {
            featuresList.add(new FireTrap(property));
        }
        if ((property = Properties.getDouble("_frequencies", "mine")) > 0.0) {
            featuresList.add(new Mine(property));
        }
        if ((property = Properties.getDouble("_frequencies", "potion_trap")) > 0.0) {
            featuresList.add(new PotionTrap(property));
        }
        if ((property = Properties.getDouble("_frequencies", "spawner_trap")) > 0.0) {
            featuresList.add(new SpawnerTrap(property));
        }
        if ((property = Properties.getDouble("_frequencies", "tower")) > 0.0) {
            featuresList.add(new Tower(property));
        }
        if ((property = Properties.getDouble("_frequencies", "chest")) > 0.0) {
            featuresList.add(new RogueChest(property));
        }
        if ((property = Properties.getDouble("_veins", "sand_count")) > 0.0) {
            featuresList.add(new VeinFeature(property, (Block)Blocks.field_150354_m, Properties.getInt("_veins", "sand_size"), Properties.getInt("_veins", "sand_min_height"), Properties.getInt("_veins", "sand_max_height")));
        }
        if ((property = Properties.getDouble("_veins", "lava_count")) > 0.0) {
            featuresList.add(new VeinLiquid(property, Blocks.field_150353_l, Properties.getInt("_veins", "lava_size"), Properties.getInt("_veins", "lava_min_height"), Properties.getInt("_veins", "lava_max_height")));
        }
        if ((property = Properties.getDouble("_veins", "water_count")) > 0.0) {
            featuresList.add(new VeinLiquid(property, Blocks.field_150355_j, Properties.getInt("_veins", "water_size"), Properties.getInt("_veins", "water_min_height"), Properties.getInt("_veins", "water_max_height")));
        }
        if ((property = Properties.getDouble("_veins", "spawner_count")) > 0.0) {
            featuresList.add(new VeinSpawner(property));
        }
        if ((property = Properties.getDouble("_veins", "silverfish_count")) > 0.0) {
            featuresList.add(new VeinFeature(property, Blocks.field_150418_aU, Properties.getInt("_veins", "silverfish_size"), Properties.getInt("_veins", "silverfish_min_height"), Properties.getInt("_veins", "silverfish_max_height")));
        }
        if ((property = Properties.getDouble("_frequencies", "boss")) > 0.0) {
            featuresList.add(new RogueBoss(property));
        }
        featuresList.trimToSize();
        _DeadlyWorld.console("Loaded " + featuresList.size() + " features!");
        return featuresList.toArray(new WorldFeature[0]);
    }
}

