/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityTarget;
import openmods.block.BlockRotationMode;
import openmods.block.OpenBlock;

public class BlockTarget
extends OpenBlock {
    private int lastEntityHit = 0;

    public BlockTarget() {
        super(Material.field_151576_e);
        this.func_149715_a(0.3f);
        this.setRotationMode(BlockRotationMode.FOUR_DIRECTIONS);
        this.setRenderMode(OpenBlock.RenderMode.TESR_ONLY);
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && entity != null && entity instanceof EntityArrow) {
            if (this.lastEntityHit != entity.func_145782_y()) {
                this.lastEntityHit = entity.func_145782_y();
                return;
            }
            this.lastEntityHit = entity.func_145782_y();
            this.onTargetHit(world, x, y, z, Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v));
        }
    }

    public void onTargetHit(World world, int x, int y, int z, Vec3 entityPosition) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityTarget target = (TileEntityTarget)((Object)BlockTarget.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityTarget.class));
        if (target == null) {
            return;
        }
        if (!target.isEnabled()) {
            return;
        }
        ForgeDirection rotation = target.getRotation();
        ForgeDirection opposite = rotation.getOpposite();
        double centerX = (double)x + 0.5 + (double)opposite.offsetX * 0.5;
        double centerY = (double)y + 0.55 + (double)opposite.offsetY * 0.45;
        double centerZ = (double)z + 0.5 + (double)opposite.offsetZ * 0.5;
        switch (opposite) {
            case NORTH: 
            case SOUTH: {
                entityPosition.field_72449_c = centerZ;
                break;
            }
            case EAST: 
            case WEST: {
                entityPosition.field_72450_a = centerX;
                break;
            }
        }
        Vec3 bullseye = Vec3.func_72443_a((double)centerX, (double)centerY, (double)centerZ);
        double distance = entityPosition.func_72438_d(bullseye);
        target.setStrength(15 - Math.min(15, Math.max(0, (int)(distance * 32.0))));
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int m) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityTarget) {
            return ((TileEntityTarget)tile).getStrength();
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int m) {
        return this.func_149709_b(world, x, y, z, m);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof TileEntityTarget)) {
            return;
        }
        TileEntityTarget target = (TileEntityTarget)tile;
        if (!target.isEnabled()) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 1.0f);
            return;
        }
        ForgeDirection direction = target.getRotation();
        switch (direction) {
            case EAST: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.1f, 1.0f, 1.0f);
                break;
            }
            case WEST: {
                this.func_149676_a(0.9f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case NORTH: {
                this.func_149676_a(0.0f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return this.isOnTopOfSolidBlock(world, x, y, z, side);
    }
}

