/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.handler;

import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.achievements.Achievements;
import com.brandon3055.draconicevolution.common.entity.EntityCustomDragon;
import com.brandon3055.draconicevolution.common.entity.EntityDragonHeart;
import com.brandon3055.draconicevolution.common.entity.ExtendedPlayer;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.items.armor.ArmorEffectHandler;
import com.brandon3055.draconicevolution.common.network.MountUpdatePacket;
import com.brandon3055.draconicevolution.common.network.SpeedRequestPacket;
import com.brandon3055.draconicevolution.common.tileentities.TileGrinder;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.WorldEvent;

public class MinecraftForgeEventHandler {
    Random random = new Random();
    private static Method becomeAngryAt;
    public static double maxSpeed;
    public static int ticksSinceRequest;
    public static boolean speedNeedsUpdating;
    private Field persistenceRequired = null;

    public MinecraftForgeEventHandler() {
        try {
            this.persistenceRequired = ReflectionHelper.findField(EntityLiving.class, (String[])new String[]{"field_82179_bU", "persistenceRequired"});
        }
        catch (Exception e) {
            LogHelper.error("Unable to find field \"persistenceRequired\"");
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.getEntityData().func_74764_b("SpawnedByDESpawner")) {
            long spawnTime = entity.getEntityData().func_74763_f("SpawnedByDESpawner");
            long livedFor = entity.field_70170_p.func_82737_E() - spawnTime;
            if (livedFor > 600L && this.persistenceRequired != null) {
                try {
                    this.persistenceRequired.setBoolean(entity, false);
                    entity.getEntityData().func_82580_o("SpawnedByDESpawner");
                    LogHelper.info("Tag Removed From " + entity);
                }
                catch (Exception e) {
                    LogHelper.warn("Error occured while resetting entity persistence: " + e);
                    entity.getEntityData().func_82580_o("SpawnedByDESpawner");
                }
            }
        }
        if (!event.entityLiving.field_70170_p.field_72995_K || !(event.entityLiving instanceof EntityPlayerSP)) {
            return;
        }
        EntityPlayerSP player = (EntityPlayerSP)entity;
        double motionX = player.field_70159_w;
        double motionZ = player.field_70179_y;
        double motion = Math.sqrt(motionX * motionX + motionZ * motionZ);
        double reduction = motion - maxSpeed;
        if (motion > maxSpeed && (player.field_70122_E || player.field_71075_bZ.field_75100_b)) {
            player.field_70159_w -= motionX * reduction;
            player.field_70179_y -= motionZ * reduction;
        }
        if (speedNeedsUpdating) {
            if (ticksSinceRequest == 0) {
                DraconicEvolution.network.sendToServer((IMessage)new SpeedRequestPacket());
                LogHelper.info("Requesting speed packet from server");
            }
            if (++ticksSinceRequest > 500) {
                ticksSinceRequest = 0;
            }
        }
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        if (ArmorEffectHandler.getHasJumpBoost(player)) {
            int i = ArmorEffectHandler.getJumpLevel(player);
            event.entityLiving.field_70181_x += (double)(ArmorEffectHandler.getJumpMultiplier(player) * (0.1f * (float)(2 + i)));
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingAttackEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        if (event.source.func_76347_k() && ArmorEffectHandler.getFireImunity(player)) {
            event.setCanceled(true);
            event.entityLiving.func_70066_B();
        }
        if (event.source.field_76373_n.equals("fall") && ArmorEffectHandler.getHasJumpBoost(player) && event.ammount < (float)((ArmorEffectHandler.getJumpLevel(player) + 1) * 2)) {
            event.setCanceled(true);
        }
        if ((event.source.field_76373_n.equals("inWall") || event.source.field_76373_n.equals("drown")) && (ArmorEffectHandler.isWyvernArmor(player, 4) || ArmorEffectHandler.isDraconicArmor(player, 4)) && event.ammount <= 2.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDropEvent(LivingDropsEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && (event.entity instanceof EntityDragon || EntityList.func_75621_b((Entity)event.entity) != null && !EntityList.func_75621_b((Entity)event.entity).isEmpty() && EntityList.func_75621_b((Entity)event.entity).equals("HardcoreEnderExpansion.Dragon"))) {
            EntityItem item = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, new ItemStack((Item)ModItems.dragonHeart));
            event.entity.field_70170_p.func_72838_d((Entity)new EntityDragonHeart(event.entity.field_70170_p, (double)((int)event.entity.field_70165_t) + 0.5, event.entity.field_70163_u, (double)((int)event.entity.field_70161_v) + 0.5));
            if (event.entity instanceof EntityCustomDragon && ((EntityCustomDragon)event.entity).getIsUber()) {
                event.entity.field_70170_p.func_72838_d((Entity)new EntityDragonHeart(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u + 2.0, event.entity.field_70161_v));
            }
            for (Object o : event.entity.field_70170_p.field_73010_i) {
                LogHelper.info(o);
                if (!(o instanceof EntityPlayer)) continue;
                ((EntityPlayer)o).func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"msg.de.dragonDeath.txt")));
            }
            int count = 30 + event.entity.field_70170_p.field_73012_v.nextInt(30);
            for (int i = 0; i < count; ++i) {
                float mm = 0.3f;
                EntityItem item2 = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t - 2.0 + (double)event.entity.field_70170_p.field_73012_v.nextInt(4), event.entity.field_70163_u - 2.0 + (double)event.entity.field_70170_p.field_73012_v.nextInt(4), event.entity.field_70161_v - 2.0 + (double)event.entity.field_70170_p.field_73012_v.nextInt(4), new ItemStack((Item)ModItems.draconiumDust));
                item.field_70159_w = mm * ((float)event.entity.field_70170_p.field_73012_v.nextInt(100) / 100.0f - 0.5f);
                item.field_70181_x = mm * ((float)event.entity.field_70170_p.field_73012_v.nextInt(100) / 100.0f - 0.5f);
                item.field_70179_y = mm * ((float)event.entity.field_70170_p.field_73012_v.nextInt(100) / 100.0f - 0.5f);
                event.entity.field_70170_p.func_72838_d((Entity)item2);
            }
        }
        if (event.entity.field_70170_p.field_72995_K || !event.source.field_76373_n.equals("player") && !event.source.field_76373_n.equals("arrow") || !this.isValidEntity(event.entityLiving)) {
            return;
        }
        EntityLivingBase entity = event.entityLiving;
        Entity attacker = event.source.func_76346_g();
        if (attacker == null || !(attacker instanceof EntityPlayer)) {
            return;
        }
        int dropChanceModifier = this.getDropChanceFromItem(((EntityPlayer)attacker).func_70694_bm());
        if (dropChanceModifier == 0) {
            return;
        }
        World world = entity.field_70170_p;
        int rand = this.random.nextInt(Math.max(ConfigHandler.soulDropChance / dropChanceModifier, 1));
        int rand2 = this.random.nextInt(Math.max(ConfigHandler.passiveSoulDropChance / dropChanceModifier, 1));
        boolean isAnimal = entity instanceof EntityAnimal;
        if (rand == 0 && !isAnimal || rand2 == 0 && isAnimal) {
            ItemStack soul = new ItemStack((Item)ModItems.mobSoul);
            String name = EntityList.func_75621_b((Entity)entity);
            ItemNBTHelper.setString((ItemStack)soul, (String)"Name", (String)name);
            if (entity instanceof EntitySkeleton) {
                ItemNBTHelper.setInteger((ItemStack)soul, (String)"SkeletonType", (int)((EntitySkeleton)entity).func_82202_m());
            }
            world.func_72838_d((Entity)new EntityItem(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, soul));
            Achievements.triggerAchievement((EntityPlayer)attacker, "draconicevolution.soul");
        }
    }

    private int getDropChanceFromItem(ItemStack stack) {
        int chance = 0;
        if (stack == null) {
            return 0;
        }
        if (stack.func_77973_b().equals(ModItems.wyvernBow) || stack.func_77973_b().equals(ModItems.wyvernSword)) {
            ++chance;
        }
        if (stack.func_77973_b().equals(ModItems.draconicSword) || stack.func_77973_b().equals(ModItems.draconicBow)) {
            chance += 2;
        }
        if (stack.func_77973_b().equals(ModItems.draconicDestructionStaff)) {
            chance += 3;
        }
        return chance += EnchantmentHelper.func_77506_a((int)ConfigHandler.reaperEnchantID, (ItemStack)stack);
    }

    private boolean isValidEntity(EntityLivingBase entity) {
        if (entity instanceof IBossDisplayData) {
            return false;
        }
        for (int i = 0; i < ConfigHandler.spawnerList.length; ++i) {
            if (ConfigHandler.spawnerList[i].equals(entity.func_70005_c_()) && ConfigHandler.spawnerListType) {
                return true;
            }
            if (!ConfigHandler.spawnerList[i].equals(entity.func_70005_c_()) || ConfigHandler.spawnerListType) continue;
            return false;
        }
        return !ConfigHandler.spawnerListType;
    }

    private boolean changeBlock(ExtendedBlockStorage storage, int x, int y, int z) {
        if (storage.func_150819_a(x, y, z).func_149739_a().equals("tile.tile.particleGenerator")) {
            return this.makeChange(storage, x, y, z, ModBlocks.particleGenerator);
        }
        if (storage.func_150819_a(x, y, z).func_149739_a().equals("tile.tile.customSpawner")) {
            return this.makeChange(storage, x, y, z, ModBlocks.customSpawner);
        }
        if (storage.func_150819_a(x, y, z).func_149739_a().equals("tile.tile.generator")) {
            return this.makeChange(storage, x, y, z, ModBlocks.generator);
        }
        if (storage.func_150819_a(x, y, z).func_149739_a().equals("tile.tile.playerDetectorAdvanced")) {
            return this.makeChange(storage, x, y, z, ModBlocks.playerDetectorAdvanced);
        }
        if (storage.func_150819_a(x, y, z).func_149739_a().equals("tile.tile.energyInfuser")) {
            return this.makeChange(storage, x, y, z, ModBlocks.energyInfuser);
        }
        if (storage.func_150819_a(x, y, z).func_149739_a().equals("tile.tile.draconiumOre")) {
            return this.makeChange(storage, x, y, z, ModBlocks.draconiumOre);
        }
        if (storage.func_150819_a(x, y, z).func_149739_a().equals("tile.tile.weatherController")) {
            return this.makeChange(storage, x, y, z, ModBlocks.weatherController);
        }
        if (storage.func_150819_a(x, y, z).func_149739_a().equals("tile.tile.longRangeDislocator")) {
            return this.makeChange(storage, x, y, z, ModBlocks.longRangeDislocator);
        }
        if (storage.func_150819_a(x, y, z).func_149739_a().equals("tile.tile.grinder")) {
            return this.makeChange(storage, x, y, z, ModBlocks.grinder);
        }
        return false;
    }

    private boolean makeChange(ExtendedBlockStorage storage, int x, int y, int z, Block block) {
        if (block == null) {
            return false;
        }
        LogHelper.info("Changing block at [X:" + x + " Y:" + y + " Z:" + z + "] from " + storage.func_150819_a(x, y, z).func_149739_a() + " to " + block.func_149739_a());
        storage.func_150818_a(x, y, z, block);
        return true;
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && ExtendedPlayer.get((EntityPlayer)event.entity) == null) {
            ExtendedPlayer.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void itemTooltipEvent(ItemTooltipEvent event) {
        if (ConfigHandler.showUnlocalizedNames) {
            event.toolTip.add(event.itemStack.func_77977_a());
        }
        if (DraconicEvolution.debug && event.itemStack.func_77942_o()) {
            String s = event.itemStack.func_77978_p().toString();
            int escape = 0;
            while (s.contains(",")) {
                event.toolTip.add(s.substring(0, s.indexOf(",") + 1));
                s = s.substring(s.indexOf(",") + 1, s.length());
                if (escape++ < 100) continue;
            }
            event.toolTip.add(s);
        }
    }

    @SubscribeEvent
    public void stopUsingEvent(PlayerUseItemEvent.Start event) {
        if (!ConfigHandler.pigmenBloodRage || event.item == null || event.item.func_77973_b() == null) {
            return;
        }
        if (event.item.func_77973_b() == Items.field_151147_al || event.item.func_77973_b() == Items.field_151157_am) {
            World world = event.entityPlayer.field_70170_p;
            if (world.field_72995_K) {
                return;
            }
            EntityPlayer player = event.entityPlayer;
            List list = world.func_72872_a(EntityPigZombie.class, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - 32.0), (double)(player.field_70163_u - 32.0), (double)(player.field_70161_v - 32.0), (double)(player.field_70165_t + 32.0), (double)(player.field_70163_u + 32.0), (double)(player.field_70161_v + 32.0)));
            EntityPigZombie entityAtPlayer = new EntityPigZombie(world);
            entityAtPlayer.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            boolean flag = false;
            for (Object o : list) {
                if (!(o instanceof EntityPigZombie)) continue;
                EntityPigZombie zombie = (EntityPigZombie)o;
                if (becomeAngryAt == null) {
                    becomeAngryAt = ReflectionHelper.findMethod(EntityPigZombie.class, (Object)zombie, (String[])new String[]{"becomeAngryAt", "func_70835_c"}, (Class[])new Class[]{Entity.class});
                    becomeAngryAt.setAccessible(true);
                }
                try {
                    becomeAngryAt.invoke((Object)zombie, player);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (Math.abs(zombie.field_70165_t - player.field_70165_t) < 14.0 && Math.abs(zombie.field_70163_u - player.field_70163_u) < 14.0 && Math.abs(zombie.field_70161_v - player.field_70161_v) < 14.0) {
                    flag = true;
                }
                zombie.func_70690_d(new PotionEffect(5, 10000, 3));
                zombie.func_70690_d(new PotionEffect(11, 10000, 2));
            }
            if (flag) {
                player.func_70690_d(new PotionEffect(2, 500, 3));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayerSP) {
            speedNeedsUpdating = true;
            DraconicEvolution.network.sendToServer((IMessage)new MountUpdatePacket(0));
        }
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.entityPlayer != null) {
            float newDigSpeed = event.originalSpeed;
            if (event.entityPlayer.func_70055_a(Material.field_151586_h) && ArmorEffectHandler.isDraconicArmor(event.entityPlayer, 4)) {
                newDigSpeed *= 5.0f;
            }
            if (!event.entityPlayer.field_70122_E && ArmorEffectHandler.isDraconicArmor(event.entityPlayer, 3)) {
                newDigSpeed *= 5.0f;
            }
            event.newSpeed = newDigSpeed;
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload e) {
        TileGrinder.fakePlayer = null;
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            ForgeDirection face = ForgeDirection.getOrientation((int)event.face);
            int x = event.x + face.offsetX;
            int y = event.y + face.offsetY;
            int z = event.z + face.offsetZ;
            if (event.world.func_147439_a(x, y, z) == ModBlocks.safetyFlame) {
                event.world.func_147468_f(x, y, z);
                event.world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 1.0f, event.world.field_73012_v.nextFloat() * 0.1f + 2.0f);
                event.setCanceled(true);
            }
        }
    }

    static {
        maxSpeed = 10.0;
        ticksSinceRequest = 0;
        speedNeedsUpdating = true;
    }
}

