/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.energynet;

import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyField;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import com.brandon3055.draconicevolution.common.tileentities.energynet.LinkedReceiver;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileRemoteEnergyBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileWirelessEnergyTransceiver
extends TileRemoteEnergyBase {
    private ParticleEnergyField ring;
    public List<LinkedReceiver> receiverList = new ArrayList<LinkedReceiver>();

    public TileWirelessEnergyTransceiver() {
    }

    public TileWirelessEnergyTransceiver(int powerTier) {
        this.powerTier = powerTier;
        this.updateStorage();
    }

    @Override
    public int getCap() {
        return 50000 + this.powerTier * 4500000;
    }

    @Override
    public int getRec() {
        return 50000 + this.powerTier * 4500000;
    }

    @Override
    public int getExt() {
        return 50000 + this.powerTier * 4500000;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.ring = DraconicEvolution.proxy.energyField(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 2, this.powerTier == 1, this.ring, this.inView > 0);
            for (LinkedReceiver receiver : this.receiverList) {
                int particleValue = 200;
                if (receiver.particleEnergyCounter <= particleValue) continue;
                receiver.particleEnergyCounter -= particleValue;
                DraconicEvolution.proxy.spawnParticle((Object)new Particles.TransceiverParticle(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, (double)this.field_145849_e + 0.5, (double)receiver.xCoord + this.field_145850_b.field_73012_v.nextDouble(), (double)receiver.yCoord + this.field_145850_b.field_73012_v.nextDouble(), (double)receiver.zCoord + this.field_145850_b.field_73012_v.nextDouble()), 64);
            }
        } else {
            for (LinkedReceiver receiver : this.receiverList) {
                if (!receiver.isStillValid(this.field_145850_b) && this.field_145850_b.func_72938_d((int)receiver.xCoord, (int)receiver.zCoord).field_76636_d) {
                    this.receiverList.remove(receiver);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    break;
                }
                int sent = receiver.receiveEnergy(this.field_145850_b, this.storage.extractEnergy(receiver.receiveEnergy(this.field_145850_b, this.powerTier == 0 ? 5000 : 50000, true), false), false);
                if ((sent /= 20) > Short.MAX_VALUE) {
                    sent = Short.MAX_VALUE;
                }
                if (sent <= 0) continue;
                this.sendObjectToClient((byte)1, 10 + this.receiverList.indexOf(receiver), (short)sent);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveObjectFromServer(int index, Object object) {
        super.receiveObjectFromServer(index, object);
        if (index >= 10 && this.receiverList.size() > index - 10 && this.receiverList.get((int)(index - 10)).particleEnergyCounter < 10000) {
            this.receiverList.get((int)(index - 10)).particleEnergyCounter += ((Short)object).shortValue();
        }
    }

    public void linkDevice(int x, int y, int z, int side, EntityPlayer player, String mode) {
        TileEntity target = this.field_145850_b.func_147438_o(x, y, z);
        if (!(target instanceof IEnergyReceiver)) {
            player.func_146105_b((IChatComponent)new ChatComponentText("Unknown Error occurred [Invalid Tile]"));
            return;
        }
        IEnergyReceiver receiver = (IEnergyReceiver)target;
        if (!receiver.canConnectEnergy(ForgeDirection.getOrientation((int)side))) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.wrongSide.txt", new Object[0]));
            return;
        }
        if (this.receiverList.size() >= this.getmaxWirelessConnections()) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.maxConnections.txt", new Object[0]));
            return;
        }
        double d = Utills.getDistanceAtoB((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)x, (double)y, (double)z);
        int n = this.powerTier == 0 ? 15 : 30;
        if (d > (double)n) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.outOfRange.txt", new Object[0]));
            return;
        }
        if (mode.equals("bind")) {
            LinkedReceiver r = new LinkedReceiver(x, y, z, side);
            for (LinkedReceiver r2 : this.receiverList) {
                if (r.xCoord != r2.xCoord || r.yCoord != r2.yCoord || r.zCoord != r2.zCoord || r.connectionSide != r2.connectionSide) continue;
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.linked.txt", new Object[0]));
                return;
            }
            this.receiverList.add(r);
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.linked.txt", new Object[0]));
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (mode.equals("unBind")) {
            for (LinkedReceiver r2 : this.receiverList) {
                if (x != r2.xCoord || y != r2.yCoord || z != r2.zCoord || side != r2.connectionSide) continue;
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.unLinked.txt", new Object[0]));
                this.receiverList.remove(r2);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("Receiver_Count", this.receiverList.size());
        for (int i = 0; i < this.receiverList.size(); ++i) {
            this.receiverList.get(i).writeToNBT(compound, String.valueOf(i));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        int count = compound.func_74762_e("Receiver_Count");
        this.receiverList.clear();
        for (int i = 0; i < count; ++i) {
            LinkedReceiver r = new LinkedReceiver();
            r.readFromNBT(compound, String.valueOf(i));
            this.receiverList.add(r);
        }
    }

    @Override
    public double getFlow(double localCap, double remoteCap) {
        return Math.max(0.0, Math.min(100.0, (localCap - remoteCap) * 100.0));
    }

    @Override
    public double getBeamX() {
        return (double)this.field_145851_c + 0.5;
    }

    @Override
    public double getBeamY() {
        return (double)this.field_145848_d + 0.5;
    }

    @Override
    public double getBeamZ() {
        return (double)this.field_145849_e + 0.5;
    }

    @Override
    public int getMaxConnections() {
        return this.powerTier == 0 ? 3 : 6;
    }

    public int getmaxWirelessConnections() {
        return this.powerTier == 0 ? 8 : 16;
    }
}

