/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.gates;

import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.common.tileentities.gates.TileGate;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFluidGate
extends TileGate
implements IFluidHandler {
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        IFluidHandler target = this.getOutputTarget();
        if (target == null) {
            return 0;
        }
        int transfer = Math.min(this.getActualFlow(), target.fill(from, resource, false));
        if (transfer < resource.amount) {
            FluidStack newStack = resource.copy();
            newStack.amount = transfer;
            resource.amount -= transfer;
            return target.fill(from, newStack, doFill);
        }
        return target.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        IFluidHandler target = this.getOutputTarget();
        LogHelper.info(target != null && target.canFill(from, fluid));
        return target != null && target.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    private IFluidHandler getOutputTarget() {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + this.output.offsetX, this.field_145848_d + this.output.offsetY, this.field_145849_e + this.output.offsetZ);
        return tile instanceof IFluidHandler ? (IFluidHandler)tile : null;
    }

    @Override
    public String getFlowSetting(int selector) {
        return selector == 0 ? Utills.addCommas((int)this.flowRSLow) + " MB/t" : Utills.addCommas((int)this.flowRSHigh) + " MB/t";
    }

    @Override
    public void incrementFlow(int selector, boolean ctrl, boolean shift, boolean add, int button) {
        int amount;
        int n = button == 0 ? (shift ? (ctrl ? 1000 : 100) : (ctrl ? 50 : 5)) : (shift ? (ctrl ? 100 : 50) : (amount = ctrl ? 10 : 1));
        if (selector == 0) {
            this.flowRSLow += add ? amount : -amount;
            if (this.flowRSLow < 0) {
                this.flowRSLow = 0;
            }
            if (this.field_145850_b.field_72995_K) {
                this.sendObjectToServer((byte)2, 0, this.flowRSLow);
            }
        } else {
            this.flowRSHigh += add ? amount : -amount;
            if (this.flowRSHigh < 0) {
                this.flowRSHigh = 0;
            }
            if (this.field_145850_b.field_72995_K) {
                this.sendObjectToServer((byte)2, 1, this.flowRSHigh);
            }
        }
    }

    @Override
    public String getToolTip(int selector, boolean shift, boolean ctrl) {
        int b1;
        int n = shift ? (ctrl ? 1000 : 100) : (b1 = ctrl ? 50 : 5);
        int b2 = shift ? (ctrl ? 100 : 50) : (ctrl ? 10 : 1);
        return b1 + "/" + b2 + " MB/t";
    }
}

