/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.render.particle.ParticleReactorBeam;
import com.brandon3055.draconicevolution.common.blocks.multiblock.IIsSlave;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileReactorStabilizer
extends TileEntity
implements IIsSlave,
IEnergyProvider {
    public float coreRotation = 0.0f;
    public float ringRotation = 0.0f;
    public float coreSpeed = 1.0f;
    public float ringSpeed = 1.0f;
    public float modelIllumination = 0.0f;
    public int facingDirection = ForgeDirection.UP.ordinal();
    public MultiblockHelper.TileLocation masterLocation = new MultiblockHelper.TileLocation();
    public boolean isValid = false;
    public int tick = 0;
    private ParticleReactorBeam beam = null;

    public void func_145845_h() {
        ++this.tick;
        if (this.field_145850_b.field_72995_K) {
            if (!(this.masterLocation.getTileEntity(this.field_145850_b) instanceof TileReactorCore)) {
                this.coreSpeed = 0.0f;
                this.ringSpeed = 0.0f;
                this.modelIllumination = 0.0f;
                return;
            }
            TileReactorCore core = (TileReactorCore)this.masterLocation.getTileEntity(this.field_145850_b);
            this.coreRotation += this.coreSpeed;
            this.ringRotation += this.ringSpeed;
            this.coreSpeed = 30.0f * core.renderSpeed;
            this.ringSpeed = 5.0f * core.renderSpeed;
            this.modelIllumination = core.renderSpeed;
            if (this.isValid) {
                this.beam = DraconicEvolution.proxy.reactorBeam(this, this.beam, true);
            }
            return;
        }
        TileEntity master = this.masterLocation.getTileEntity(this.field_145850_b);
        if (master instanceof TileReactorCore && ((TileReactorCore)master).reactorState == 2) {
            ForgeDirection back = ForgeDirection.getOrientation((int)this.facingDirection).getOpposite();
            TileEntity output = this.field_145850_b.func_147438_o(this.field_145851_c + back.offsetX, this.field_145848_d + back.offsetY, this.field_145849_e + back.offsetZ);
            if (output instanceof IEnergyReceiver) {
                int sent = ((IEnergyReceiver)output).receiveEnergy(back.getOpposite(), Math.min(((TileReactorCore)master).energySaturation, ((TileReactorCore)master).maxEnergySaturation / 100), false);
                ((TileReactorCore)master).energySaturation -= sent;
            }
        }
    }

    public void onPlaced() {
        this.checkForMaster();
    }

    public void onBroken() {
    }

    @Override
    public boolean checkForMaster() {
        for (int i = 1; i < 10; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.facingDirection);
            int x = this.field_145851_c + dir.offsetX * i;
            int y = this.field_145848_d + dir.offsetY * i;
            int z = this.field_145849_e + dir.offsetZ * i;
            if (this.field_145850_b.func_147437_c(x, y, z)) continue;
            TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
            if (tile instanceof TileReactorCore && ((TileReactorCore)tile).stabilizerLocations.size() < 4) {
                ((TileReactorCore)tile).stabilizerLocations.add(new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.masterLocation.func_71571_b(x, y, z);
                this.isValid = true;
                ((TileReactorCore)tile).validateStructure();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
            this.isValid = false;
            return false;
        }
        this.isValid = false;
        return false;
    }

    @Override
    public boolean isActive() {
        return this.isValid;
    }

    @Override
    public void shutDown() {
        this.isValid = false;
        this.masterLocation = new MultiblockHelper.TileLocation();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.masterLocation.writeToNBT(compound, "Master");
        compound.func_74768_a("Facing", this.facingDirection);
        compound.func_74757_a("IsValid", this.isValid);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound compound = pkt.func_148857_g();
        this.masterLocation.readFromNBT(compound, "Master");
        this.facingDirection = compound.func_74762_e("Facing");
        this.isValid = compound.func_74767_n("IsValid");
        super.onDataPacket(net, pkt);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.masterLocation.writeToNBT(compound, "Master");
        compound.func_74768_a("Facing", this.facingDirection);
        compound.func_74757_a("IsValid", this.isValid);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.masterLocation.readFromNBT(compound, "Master");
        this.facingDirection = compound.func_74762_e("Facing");
        this.isValid = compound.func_74767_n("IsValid");
    }

    @Override
    public MultiblockHelper.TileLocation getMaster() {
        return this.masterLocation;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.getOrientation((int)this.facingDirection).getOpposite();
    }

    public double func_145833_n() {
        return 40960.0;
    }
}

