/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseRecipeHandler
extends TemplateRecipeHandler
implements IGuiWrapper {
    public Set<GuiElement> guiElements = new HashSet<GuiElement>();

    public BaseRecipeHandler() {
        this.addGuiElements();
    }

    public abstract void addGuiElements();

    public void displayGauge(int length, int xPos, int yPos, int overlayX, int overlayY, int scale, FluidStack fluid, GasStack gas) {
        int renderRemaining;
        if (fluid == null && gas == null) {
            return;
        }
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            GuiDraw.changeTexture((ResourceLocation)MekanismRenderer.getBlocksTexture());
            if (fluid != null) {
                GuiDraw.gui.func_94065_a(xPos, yPos + length - renderRemaining - start, fluid.getFluid().getIcon(), 16, 16 - (16 - renderRemaining));
            } else if (gas != null) {
                GuiDraw.gui.func_94065_a(xPos, yPos + length - renderRemaining - start, gas.getGas().getIcon(), 16, 16 - (16 - renderRemaining));
            }
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)xPos, (int)yPos, (int)overlayX, (int)overlayY, (int)16, (int)(length + 1));
    }

    public boolean doGasLookup(GasStack stack, boolean type) {
        if (stack != null && stack.amount > 0) {
            return !(type ? !GuiUsageRecipe.openRecipeGui((String)"gas", (Object[])new Object[]{stack}) : !GuiCraftingRecipe.openRecipeGui((String)"gas", (Object[])new Object[]{stack}));
        }
        return false;
    }

    public void displayGauge(int xPos, int yPos, int sizeX, int sizeY, GasStack gas) {
        if (gas == null) {
            return;
        }
        GuiDraw.changeTexture((ResourceLocation)MekanismRenderer.getBlocksTexture());
        GuiDraw.gui.func_94065_a(xPos, yPos, gas.getGas().getIcon(), sizeX, sizeY);
    }

    public String stripTexture() {
        return this.getGuiTexture().replace("mekanism:gui/", "");
    }

    public boolean doFluidLookup(FluidStack stack, boolean type) {
        if (stack != null && stack.amount > 0) {
            return !(type ? !GuiUsageRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{stack}) : !GuiCraftingRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{stack}));
        }
        return false;
    }

    @Override
    public void drawTexturedRect(int x, int y, int u, int v, int w, int h) {
        GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)u, (int)v, (int)w, (int)h);
    }

    @Override
    public void drawTexturedRectFromIcon(int x, int y, IIcon icon, int w, int h) {
        GuiDraw.gui.func_94065_a(x, y, icon, w, h);
    }

    @Override
    public void displayTooltip(String s, int xAxis, int yAxis) {
    }

    @Override
    public void displayTooltips(List<String> list, int xAxis, int yAxis) {
    }

    @Override
    public FontRenderer getFont() {
        return null;
    }
}

