/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiChemicalDissolutionChamber;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ChemicalDissolutionChamberRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public static int xOffset = 5;
    public static int yOffset = 3;

    public String getRecipeName() {
        return LangUtils.localize("gui.chemicalDissolutionChamber.short");
    }

    public String getOverlayIdentifier() {
        return "chemicaldissolutionchamber";
    }

    public String getGuiTexture() {
        return "mekanism:gui/nei/GuiChemicalDissolutionChamber.png";
    }

    public Class getGuiClass() {
        return GuiChemicalDissolutionChamber.class;
    }

    public String getRecipeId() {
        return "mekanism.chemicaldissolutionchamber";
    }

    public Collection<DissolutionRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get().values();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)yOffset, (int)170, (int)79);
    }

    public void drawExtras(int i) {
        GasStack gas = ((CachedIORecipe)((Object)this.arecipes.get((int)i))).outputStack;
        float f = (float)(this.ticksPassed % 20) / 20.0f;
        this.drawProgressBar(64 - xOffset, 40 - yOffset, 176, 63, 48, 8, f, 0);
        this.displayGauge(58, 6 - xOffset, 5 - yOffset, 176, 4, 58, null, new GasStack(GasRegistry.getGas("sulfuricAcid"), 1));
        if (gas != null) {
            this.displayGauge(58, 134 - xOffset, 14 - yOffset, 176, 4, 58, null, gas);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(64 - xOffset, 40 - yOffset, 48, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (DissolutionRecipe irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (outputId.equals("gas") && results.length == 1 && results[0] instanceof GasStack) {
            for (DissolutionRecipe irecipe : this.getRecipes()) {
                if (!((GasStack)results[0]).isGasEqual(((GasOutput)irecipe.getOutput()).output)) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(GasRegistry.getGas("sulfuricAcid").getLocalizedName());
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(LangUtils.localizeGasStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack));
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack stack = null;
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            stack = new GasStack(GasRegistry.getGas("sulfuricAcid"), 1);
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
        }
        if (stack != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(stack, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(stack, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack stack = null;
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            stack = new GasStack(GasRegistry.getGas("sulfuricAcid"), 1);
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
        }
        if (stack != null && (button == 0 ? this.doGasLookup(stack, false) : button == 1 && this.doGasLookup(stack, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (DissolutionRecipe irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStackInput)irecipe.getInput()).ingredient, (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe));
        }
    }

    @Override
    public void addGuiElements() {
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack inputStack;
        public GasStack outputStack;

        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        public PositionedStack getResult() {
            return null;
        }

        public CachedIORecipe(ItemStack input, GasStack output) {
            super((TemplateRecipeHandler)ChemicalDissolutionChamberRecipeHandler.this);
            this.inputStack = new PositionedStack((Object)input, 26 - xOffset, 36 - yOffset);
            this.outputStack = output;
        }

        public CachedIORecipe(DissolutionRecipe recipe) {
            this(((ItemStackInput)recipe.getInput()).ingredient, ((GasOutput)recipe.getOutput()).output);
        }
    }
}

