/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import mekanism.client.gui.GuiSolarEvaporationController;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.machines.SolarEvaporationRecipe;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class SolarEvaporationRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public static int xOffset = 5;
    public static int yOffset = 12;

    public String getRecipeName() {
        return LangUtils.localize("gui.solarEvaporationController.short");
    }

    public String getOverlayIdentifier() {
        return "solarevaporation";
    }

    public String getGuiTexture() {
        return "mekanism:gui/nei/GuiSolarEvaporationController.png";
    }

    public Class getGuiClass() {
        return GuiSolarEvaporationController.class;
    }

    public String getRecipeId() {
        return "mekanism.solarevaporation";
    }

    public Collection<SolarEvaporationRecipe> getRecipes() {
        return RecipeHandler.Recipe.SOLAR_EVAPORATION_PLANT.get().values();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(49 - xOffset, 20 - yOffset, 78, 38), this.getRecipeId(), new Object[0]));
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)yOffset, (int)170, (int)62);
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        this.drawProgressBar(49 - xOffset, 64 - yOffset, 176, 59, 78, 8, this.ticksPassed < 20 ? (float)(this.ticksPassed % 20) / 20.0f : 1.0f, 0);
        if (recipe.fluidInput != null) {
            this.displayGauge(58, 7 - xOffset, 14 - yOffset, 176, 0, 58, recipe.fluidInput, null);
        }
        if (recipe.fluidOutput != null) {
            this.displayGauge(58, 153 - xOffset, 14 - yOffset, 176, 0, 58, recipe.fluidOutput, null);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (SolarEvaporationRecipe irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (outputId.equals("fluid") && results.length == 1 && results[0] instanceof FluidStack) {
            for (SolarEvaporationRecipe irecipe : this.getRecipes()) {
                if (!((FluidStack)results[0]).isFluidEqual(((FluidOutput)irecipe.recipeOutput).output)) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fluid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
            for (SolarEvaporationRecipe irecipe : this.getRecipes()) {
                if (!((FluidInput)irecipe.recipeInput).ingredient.isFluidEqual((FluidStack)ingredients[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(LangUtils.localizeFluidStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidInput));
        } else if (xAxis >= 153 && xAxis <= 169 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(LangUtils.localizeFluidStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidOutput));
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        FluidStack stack = null;
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidInput;
        } else if (xAxis >= 153 && xAxis <= 169 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidOutput;
        }
        if (stack != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doFluidLookup(stack, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doFluidLookup(stack, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        FluidStack stack = null;
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidInput;
        } else if (xAxis >= 153 && xAxis <= 169 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidOutput;
        }
        if (stack != null && (button == 0 ? this.doFluidLookup(stack, false) : button == 1 && this.doFluidLookup(stack, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    @Override
    public void addGuiElements() {
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public FluidStack fluidInput;
        public FluidStack fluidOutput;

        public PositionedStack getResult() {
            return null;
        }

        public CachedIORecipe(FluidStack input, FluidStack output) {
            super((TemplateRecipeHandler)SolarEvaporationRecipeHandler.this);
            this.fluidInput = input;
            this.fluidOutput = output;
        }

        public CachedIORecipe(SolarEvaporationRecipe recipe) {
            this(((FluidInput)recipe.recipeInput).ingredient, ((FluidOutput)recipe.recipeOutput).output);
        }
    }
}

