/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.teleportation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.common.content.teleportation.SharedInventory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SharedInventoryManager {
    public static HashMap<String, SharedInventory> inventories = new HashMap();

    public static SharedInventory getInventory(String frequency) {
        if (frequency.length() <= 0) {
            return null;
        }
        SharedInventory inv = inventories.get(frequency);
        if (inv == null) {
            inv = new SharedInventory(frequency);
            inventories.put(frequency, inv);
        }
        if (frequency.startsWith("creative.")) {
            Iterator<String> creativeFreqs = Arrays.asList(frequency.substring(9).split("\\.")).iterator();
            while (creativeFreqs.hasNext()) {
                String gasType;
                String type = creativeFreqs.next();
                if (type.equals("energy")) {
                    inv.MAX_ENERGY = 2.147483647E9;
                    inv.setEnergy(2.147483647E9);
                    continue;
                }
                if (type.equals("fluid") && creativeFreqs.hasNext()) {
                    String fluidType = creativeFreqs.next();
                    if (!FluidRegistry.isFluidRegistered((String)fluidType)) continue;
                    inv.storedFluid.setCapacity(Integer.MAX_VALUE);
                    inv.storedFluid.setFluid(new FluidStack(FluidRegistry.getFluid((String)fluidType), Integer.MAX_VALUE));
                    continue;
                }
                if (!type.equals("gas") || !creativeFreqs.hasNext() || !GasRegistry.containsGas(gasType = creativeFreqs.next())) continue;
                inv.storedGas.setMaxGas(Integer.MAX_VALUE);
                inv.storedGas.setGas(new GasStack(GasRegistry.getGas(gasType), Integer.MAX_VALUE));
            }
        }
        return inv;
    }
}

