/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.SideData;
import mekanism.common.base.ITileComponent;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileComponentConfig
implements ITileComponent {
    public TileEntityContainerBlock tileEntity;
    public Map<Integer, byte[]> sideConfigs = new HashMap<Integer, byte[]>();
    public Map<Integer, ArrayList<SideData>> sideOutputs = new HashMap<Integer, ArrayList<SideData>>();
    public Map<Integer, Boolean> ejecting = new HashMap<Integer, Boolean>();
    public Map<Integer, Boolean> canEject = new HashMap<Integer, Boolean>();
    public List<TransmissionType> transmissions = new ArrayList<TransmissionType>();

    public TileComponentConfig(TileEntityContainerBlock tile, TransmissionType ... types) {
        this.tileEntity = tile;
        for (TransmissionType type : types) {
            this.addSupported(type);
        }
        tile.components.add(this);
    }

    public void readFrom(TileComponentConfig config) {
        this.sideConfigs = config.sideConfigs;
        this.ejecting = config.ejecting;
        this.canEject = config.canEject;
        this.transmissions = config.transmissions;
    }

    public void addSupported(TransmissionType type) {
        if (!this.transmissions.contains((Object)type)) {
            this.transmissions.add(type);
        }
        this.sideOutputs.put(type.ordinal(), new ArrayList());
        this.ejecting.put(type.ordinal(), false);
        this.canEject.put(type.ordinal(), true);
    }

    public EnumSet<ForgeDirection> getSidesForData(TransmissionType type, int facing, int dataIndex) {
        EnumSet<ForgeDirection> ret = EnumSet.noneOf(ForgeDirection.class);
        for (int b = 0; b < 6; b = (int)((byte)(b + 1))) {
            if (this.getConfig(type)[b] != dataIndex) continue;
            ret.add(ForgeDirection.getOrientation((int)MekanismUtils.getBaseOrientation(b, facing)));
        }
        return ret;
    }

    public void setCanEject(TransmissionType type, boolean eject) {
        this.canEject.put(type.ordinal(), eject);
    }

    public boolean canEject(TransmissionType type) {
        return this.canEject.get(type.ordinal());
    }

    public void fillConfig(TransmissionType type, int data) {
        byte sideData = (byte)data;
        this.setConfig(type, new byte[]{sideData, sideData, sideData, sideData, sideData, sideData});
    }

    public void setIOEnergyConfig() {
        this.addOutput(TransmissionType.ENERGY, new SideData("None", EnumColor.GREY, SideData.EnergyState.OFF));
        this.addOutput(TransmissionType.ENERGY, new SideData("Input", EnumColor.DARK_GREEN, SideData.EnergyState.INPUT));
        this.addOutput(TransmissionType.ENERGY, new SideData("Output", EnumColor.DARK_RED, SideData.EnergyState.OUTPUT));
        this.setConfig(TransmissionType.ENERGY, new byte[]{1, 1, 2, 1, 1, 1});
    }

    public void setInputEnergyConfig() {
        this.addOutput(TransmissionType.ENERGY, new SideData("None", EnumColor.GREY, SideData.EnergyState.OFF));
        this.addOutput(TransmissionType.ENERGY, new SideData("Input", EnumColor.DARK_GREEN, SideData.EnergyState.INPUT));
        this.setConfig(TransmissionType.ENERGY, new byte[]{1, 1, 1, 1, 1, 1});
        this.setCanEject(TransmissionType.ENERGY, false);
    }

    public void setConfig(TransmissionType type, byte[] config) {
        this.sideConfigs.put(type.ordinal(), config);
    }

    public void addOutput(TransmissionType type, SideData data) {
        this.sideOutputs.get(type.ordinal()).add(data);
    }

    public ArrayList<SideData> getOutputs(TransmissionType type) {
        return this.sideOutputs.get(type.ordinal());
    }

    public byte[] getConfig(TransmissionType type) {
        return this.sideConfigs.get(type.ordinal());
    }

    public SideData getOutput(TransmissionType type, int side, int facing) {
        return this.getOutputs(type).get(this.getConfig(type)[MekanismUtils.getBaseOrientation(side, facing)]);
    }

    public SideData getOutput(TransmissionType type, int side) {
        return this.getOutputs(type).get(this.getConfig(type)[side]);
    }

    public boolean supports(TransmissionType type) {
        return this.transmissions.contains((Object)type);
    }

    @Override
    public void tick() {
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        if (nbtTags.func_74767_n("sideDataStored")) {
            for (TransmissionType type : this.transmissions) {
                try {
                    if (nbtTags.func_74770_j("config" + type.ordinal()).length <= 0) continue;
                    this.sideConfigs.put(type.ordinal(), nbtTags.func_74770_j("config" + type.ordinal()));
                    this.ejecting.put(type.ordinal(), nbtTags.func_74767_n("ejecting" + type.ordinal()));
                }
                catch (Exception e) {
                    try {
                        byte[] bytes = new byte[6];
                        for (int i = 0; i < 6; ++i) {
                            bytes[i] = nbtTags.func_74771_c("config" + i);
                            if (bytes[i] <= 0) continue;
                            int n = i;
                            bytes[n] = (byte)(bytes[n] - 1);
                        }
                        this.sideConfigs.put(TransmissionType.ITEM.ordinal(), bytes);
                        this.ejecting.put(TransmissionType.ITEM.ordinal(), nbtTags.func_74767_n("ejecting"));
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.transmissions.clear();
        int amount = dataStream.readInt();
        for (int i = 0; i < amount; ++i) {
            this.transmissions.add(TransmissionType.values()[dataStream.readInt()]);
        }
        for (TransmissionType type : this.transmissions) {
            byte[] array = new byte[6];
            dataStream.readBytes(array);
            this.sideConfigs.put(type.ordinal(), array);
            this.ejecting.put(type.ordinal(), dataStream.readBoolean());
        }
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        for (TransmissionType type : this.transmissions) {
            nbtTags.func_74773_a("config" + type.ordinal(), this.sideConfigs.get(type.ordinal()));
            nbtTags.func_74757_a("ejecting" + type.ordinal(), this.ejecting.get(type.ordinal()).booleanValue());
        }
        nbtTags.func_74757_a("sideDataStored", true);
    }

    @Override
    public void write(ArrayList data) {
        data.add(this.transmissions.size());
        for (TransmissionType type : this.transmissions) {
            data.add(type.ordinal());
        }
        for (TransmissionType type : this.transmissions) {
            data.add(this.sideConfigs.get(type.ordinal()));
            data.add(this.ejecting.get(type.ordinal()));
        }
    }

    public boolean isEjecting(TransmissionType type) {
        return this.ejecting.get(type.ordinal());
    }

    public void setEjecting(TransmissionType type, boolean eject) {
        this.ejecting.put(type.ordinal(), eject);
        MekanismUtils.saveChunk(this.tileEntity);
    }
}

