/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases.common.gastype;

import glenn.gases.Gases;
import glenn.gasesframework.api.Combustibility;
import glenn.gasesframework.api.ExtendedGasEffectsBase;
import glenn.gasesframework.api.gastype.GasType;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class GasTypeLightSensitive
extends GasType {
    public GasTypeLightSensitive(boolean isIndustrial, int gasIndex, String name, int color, int opacity, int density, Combustibility combustibility) {
        super(isIndustrial, gasIndex, name, color, opacity, density, combustibility);
    }

    private void warmSurroundingStone(World world, int x, int y, int z, Random random, float brightness) {
        if (brightness >= 0.0f) {
            brightness *= random.nextFloat() * 2.0f;
            float chance = random.nextFloat();
            int radius = 2;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        int otherMetadata;
                        int z1;
                        int y1;
                        int x1;
                        Block otherBlock;
                        int r2 = i * i + j * j + k * k;
                        if (r2 > radius * radius + 2 || (otherBlock = world.func_147439_a(x1 = x + i, y1 = y + j, z1 = z + k)) != Blocks.field_150348_b && otherBlock != Gases.warmStone) continue;
                        float r = MathHelper.func_76129_c((float)r2);
                        int n = otherMetadata = otherBlock == Blocks.field_150348_b ? -1 : world.func_72805_g(x1, y1, z1);
                        if (!(chance < brightness * (1.0f + (float)radius - r) / (2.0f + (float)radius))) continue;
                        if (otherMetadata >= 15) {
                            world.func_147449_b(x1, y1, z1, Blocks.field_150353_l);
                            continue;
                        }
                        if (otherMetadata == -1) {
                            world.func_147449_b(x1, y1, z1, Gases.warmStone);
                            continue;
                        }
                        world.func_72921_c(x1, y1, z1, otherMetadata + 1, 3);
                    }
                }
            }
        }
    }

    private void slowSurroundingEntities(World world, int x, int y, int z, Random random, float r) {
        List nearbyEntities = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((float)x - r), (double)((float)y - r), (double)((float)z - r), (double)((double)x + 1.0 + (double)r), (double)((double)y + 1.0 + (double)r), (double)((double)z + 1.0 + (double)r)));
        for (EntityLivingBase entity : nearbyEntities) {
            ExtendedGasEffectsBase.get(entity).increment(ExtendedGasEffectsBase.EffectType.SLOWNESS, 150);
        }
    }

    @Override
    public void preTick(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K) {
            float brightness = world.func_72801_o(x, y, z) - 0.2f;
            this.warmSurroundingStone(world, x, y, z, random, brightness);
            if (brightness > 0.0f) {
                this.slowSurroundingEntities(world, x, y, z, random, brightness * 10.0f);
            }
        }
    }

    @Override
    public boolean requiresNewTick(World world, int x, int y, int z, Random random) {
        return true;
    }
}

