/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.api.gasworldgentype;

import glenn.gasesframework.api.gastype.GasType;
import java.util.HashMap;
import net.minecraft.world.World;

public abstract class GasWorldGenType {
    private static HashMap<String, GasWorldGenType> gasWorldGenTypesByName = new HashMap();
    public final String name;
    public final GasType gasType;
    public final float generationFrequency;
    public final float averageVolume;
    public final float evenness;
    public final int minY;
    public final int maxY;

    public static GasWorldGenType getGasWorldGenTypeByName(String name) {
        return gasWorldGenTypesByName.get(name);
    }

    private void map() {
        GasWorldGenType prev = GasWorldGenType.getGasWorldGenTypeByName(this.name);
        if (prev != null) {
            throw new RuntimeException("A gas world gen type named " + this.name + " attempted to override a gas world gen type with the same name");
        }
        gasWorldGenTypesByName.put(this.name, this);
    }

    public GasWorldGenType(String name, GasType gasType, float generationFrequency, float averageVolume, float evenness, int minY, int maxY) {
        this.name = name;
        this.gasType = gasType;
        this.generationFrequency = generationFrequency;
        this.averageVolume = averageVolume;
        this.evenness = evenness < 0.0f ? 0.0f : (evenness > 1.0f ? 1.0f : evenness);
        this.minY = minY;
        this.maxY = maxY;
        this.map();
    }

    public abstract int getPlacementVolume(World var1, int var2, int var3, int var4, float var5);
}

