/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.FMLLog;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.moddingutils.Configurations;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;

public class ConfigGasFurnaceRecipes {
    public static void load(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
                PrintWriter writer = new PrintWriter(file);
                writer.print(String.format("[%n\t%n]", new Object[0]));
                writer.close();
            }
            Gson gson = new Gson();
            ArrayList recipes = (ArrayList)gson.fromJson((Reader)new FileReader(file), new TypeToken<ArrayList<CustomGasFurnaceRecipe>>(){}.getType());
            for (CustomGasFurnaceRecipe recipe : recipes) {
                GasesFrameworkAPI.addSpecialFurnaceRecipe(recipe.input.getItemStack(), recipe.output.getItemStack(), recipe.time <= 0 ? 200 : recipe.time, recipe.exp);
            }
        }
        catch (IOException e) {
            FMLLog.warning((String)"Could not read custom gas furnace recipe configuration file (%s)", (Object[])new Object[]{e.toString()});
        }
    }

    private class CustomGasFurnaceRecipe {
        public Configurations.ItemRepresentation input;
        public Configurations.ItemRepresentation output;
        public int time = 200;
        public int exp = 200;

        private CustomGasFurnaceRecipe() {
        }
    }
}

