/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.block.IGasInterface;
import glenn.gasesframework.api.block.IGasReceptor;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.client.render.RenderBlockGasPipe;
import glenn.gasesframework.common.block.BlockGas;
import glenn.gasesframework.util.PipeBranchIterator;
import glenn.gasesframework.util.PipeSearch;
import glenn.moddingutils.IVec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGasPipe
extends Block
implements IGasReceptor {
    public final SubType[] subTypes = new SubType[16];
    public GasType type;

    public BlockGasPipe(GasType type) {
        super(Material.field_151575_d);
        this.type = type;
        this.func_149711_c(0.25f);
        this.func_149658_d("gasesframework:pipe");
        this.func_149672_a(Block.field_149769_e);
        this.subTypes[0] = new SubType(0, "iron", true);
        this.subTypes[1] = new SubType(1, "glass", false);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < this.subTypes.length; ++i) {
            SubType subType = this.subTypes[i];
            if (subType == null) continue;
            subType.registerIcons(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.subTypes[metadata].solidIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item blockItem, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < 16; ++i) {
            if (this.subTypes[i] == null) continue;
            list.add(new ItemStack(blockItem, 1, i));
        }
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public boolean[] getRenderConnectionArray(IBlockAccess blockAccess, int x, int y, int z) {
        boolean[] sidePipe = new boolean[6];
        boolean[] renderConnections = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[i];
            int x1 = x + side.offsetX;
            int y1 = y + side.offsetY;
            int z1 = z + side.offsetZ;
            Block directionBlock = blockAccess.func_147439_a(x1, y1, z1);
            sidePipe[i] = directionBlock instanceof IGasInterface ? ((IGasInterface)directionBlock).connectToPipe(blockAccess, x1, y1, z1, side.getOpposite()) : false;
        }
        boolean collectionAll = sidePipe[0] || sidePipe[1] || sidePipe[2] || sidePipe[3] || sidePipe[4] || sidePipe[5];
        boolean collectionY = sidePipe[2] || sidePipe[3] || sidePipe[4] || sidePipe[5];
        boolean collectionX = sidePipe[0] || sidePipe[1] || sidePipe[2] || sidePipe[3];
        boolean collectionZ = sidePipe[0] || sidePipe[1] || sidePipe[4] || sidePipe[5];
        renderConnections[0] = (sidePipe[0] | !collectionY) & collectionAll;
        renderConnections[1] = (sidePipe[1] | !collectionY) & collectionAll;
        renderConnections[2] = (sidePipe[2] | !collectionZ) & collectionAll;
        renderConnections[3] = (sidePipe[3] | !collectionZ) & collectionAll;
        renderConnections[4] = (sidePipe[4] | !collectionX) & collectionAll;
        renderConnections[5] = (sidePipe[5] | !collectionX) & collectionAll;
        return renderConnections;
    }

    public float[] getBounds(IBlockAccess blockAccess, int x, int y, int z) {
        boolean[] renderConnections = this.getRenderConnectionArray(blockAccess, x, y, z);
        float f1 = 0.375f;
        float f2 = 0.625f;
        return new float[]{renderConnections[0] ? 0.0f : f1, renderConnections[1] ? 1.0f : f2, renderConnections[2] ? 0.0f : f1, renderConnections[3] ? 1.0f : f2, renderConnections[4] ? 0.0f : f1, renderConnections[5] ? 1.0f : f2};
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        float[] bounds = this.getBounds((IBlockAccess)world, x, y, z);
        float f1 = 0.375f;
        float f2 = 0.625f;
        this.func_149676_a(f1, f1, bounds[2], f2, f2, bounds[3]);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
        this.func_149676_a(f1, bounds[0], f1, f2, bounds[1], f2);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
        this.func_149676_a(bounds[4], f1, f1, bounds[5], f2, f2);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
        this.func_149719_a((IBlockAccess)world, x, y, z);
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        float[] bounds = this.getBounds(blockAccess, x, y, z);
        this.func_149676_a(bounds[4], bounds[0], bounds[2], bounds[5], bounds[1], bounds[3]);
    }

    @Override
    public boolean receiveGas(World world, int x, int y, int z, ForgeDirection side, GasType gasType) {
        PipeSearch.ReceptorSearch search = new PipeSearch.ReceptorSearch(world, x, y, z, 15);
        boolean isSearchingLooseEnds = !search.looseEnds.isEmpty();
        ArrayList listToSearch = (ArrayList)(isSearchingLooseEnds ? search.looseEnds : search.ends).clone();
        Collections.shuffle(listToSearch, world.field_73012_v);
        for (PipeSearch.PipeEnd end : listToSearch) {
            PipeBranchIterator.Iteration iteration;
            IVec branchPos = end.branch.getPosition();
            BlockGasPipe pipeSourceBlock = (BlockGasPipe)world.func_147439_a(branchPos.x, branchPos.y, branchPos.z);
            boolean hasPushed = false;
            if (isSearchingLooseEnds) {
                hasPushed = GasesFrameworkAPI.fillWithGas(world, world.field_73012_v, end.endPosition.x, end.endPosition.y, end.endPosition.z, pipeSourceBlock.type);
            } else {
                IGasReceptor receptor = (IGasReceptor)world.func_147439_a(end.endPosition.x, end.endPosition.y, end.endPosition.z);
                hasPushed = receptor.receiveGas(world, end.endPosition.x, end.endPosition.y, end.endPosition.z, end.endDirection.getOpposite(), pipeSourceBlock.type);
            }
            if (!hasPushed) continue;
            PipeBranchIterator.DescendingPipeBranchIterator iterator = new PipeBranchIterator.DescendingPipeBranchIterator(end.branch);
            while ((iteration = iterator.narrowNext(world.field_73012_v)) != null) {
                Block receptorBlock = world.func_147439_a(iteration.previousPosition.x, iteration.previousPosition.y, iteration.previousPosition.z);
                int receptorMetadata = world.func_72805_g(iteration.previousPosition.x, iteration.previousPosition.y, iteration.previousPosition.z);
                Block giverBlock = world.func_147439_a(iteration.currentPosition.x, iteration.currentPosition.y, iteration.currentPosition.z);
                if (receptorBlock == giverBlock) continue;
                world.func_147465_d(iteration.previousPosition.x, iteration.previousPosition.y, iteration.previousPosition.z, giverBlock, receptorMetadata, 3);
            }
            int thisMetadata = world.func_72805_g(x, y, z);
            world.func_147465_d(x, y, z, gasType.pipeBlock, thisMetadata, 3);
            return true;
        }
        return false;
    }

    @Override
    public boolean canReceiveGas(World world, int x, int y, int z, ForgeDirection side, GasType gasType) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderBlockGasPipe.RENDER_ID;
    }

    public Item func_149694_d(World par1World, int par2, int par3, int par4) {
        return Item.func_150898_a((Block)GasesFrameworkAPI.gasTypeAir.pipeBlock);
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)GasesFrameworkAPI.gasTypeAir.pipeBlock);
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldBlockMetadata) {
        if (this.type.block != null && world.func_147437_c(x, y, z)) {
            world.func_147449_b(x, y, z, this.type.block);
        }
    }

    @Override
    public boolean connectToPipe(IBlockAccess blockaccess, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (this.type.block != null) {
            ((BlockGas)this.type.block).onFire(world, x, y, z, world.field_73012_v, 0);
        }
    }

    public byte[] getPossiblePropellingDirections(World world, int x, int y, int z) {
        byte[] res = new byte[6];
        IVec pipePosition = new IVec(x, y, z);
        PipeSearch.PropellorSearch pumpSearch = new PipeSearch.PropellorSearch(world, x, y, z, 15);
        for (PipeSearch.PipeEnd propellor : pumpSearch.propellors) {
            IVec pipePos = propellor.branch.getPosition();
            PipeSearch.ReceptorSearch search = new PipeSearch.ReceptorSearch(world, pipePos.x, pipePos.y, pipePos.z, 15);
            ArrayList<PipeSearch.PipeEnd> listToSearch = search.looseEnds.isEmpty() ? search.ends : search.looseEnds;
            if (listToSearch.size() <= 0) continue;
            if (pipePos.x == x && pipePos.y == y && pipePos.z == z) {
                int n = propellor.endDirection.getOpposite().ordinal();
                res[n] = (byte)(res[n] | 2);
            }
            for (PipeSearch.PipeEnd end : listToSearch) {
                PipeBranchIterator.Iteration iteration;
                PipeBranchIterator.DescendingPipeBranchIterator iterator = new PipeBranchIterator.DescendingPipeBranchIterator(end.branch);
                while ((iteration = iterator.next()) != null) {
                    if (iteration.currentPosition.equals(pipePosition)) {
                        int n = ForgeDirection.VALID_DIRECTIONS[iteration.direction].getOpposite().ordinal();
                        res[n] = (byte)(res[n] | 1);
                        continue;
                    }
                    if (!iteration.previousPosition.equals(pipePosition)) continue;
                    int n = iteration.direction;
                    res[n] = (byte)(res[n] | 2);
                }
                if (!end.branch.getPosition().equals(pipePosition)) continue;
                int n = end.endDirection.ordinal();
                res[n] = (byte)(res[n] | 1);
            }
        }
        return res;
    }

    public static class SubType {
        public final int metadata;
        public final String name;
        public final boolean isSolid;
        public IIcon solidIcon;
        public IIcon gasContentIcon;
        public IIcon connectorsIcon;
        public IIcon endIcon;

        public SubType(int metadata, String name, boolean isSolid) {
            this.metadata = metadata;
            this.name = name;
            this.isSolid = isSolid;
        }

        public String baseTexture() {
            return "gasesframework:pipe_" + this.name;
        }

        public void registerIcons(IIconRegister iconRegister) {
            this.solidIcon = iconRegister.func_94245_a(this.baseTexture() + "_solid");
            if (!this.isSolid) {
                this.gasContentIcon = iconRegister.func_94245_a(this.baseTexture() + "_gas_content");
            }
            this.connectorsIcon = iconRegister.func_94245_a(this.baseTexture() + "_connectors");
            this.endIcon = iconRegister.func_94245_a(this.baseTexture() + "_end");
        }
    }
}

