/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.block.IGasReceptor;
import glenn.gasesframework.api.block.IGasSource;
import glenn.gasesframework.api.block.ISample;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.client.render.RenderBlockGasTank;
import glenn.gasesframework.common.tileentity.TileEntityGasTank;
import glenn.moddingutils.IVec;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGasTank
extends Block
implements IGasSource,
IGasReceptor,
ITileEntityProvider,
ISample {
    public IIcon side;
    public IIcon top;
    public IIcon inside;

    public BlockGasTank() {
        super(Material.field_151573_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.side = par1IconRegister.func_94245_a(this.func_149641_N() + "_side");
        this.top = par1IconRegister.func_94245_a(this.func_149641_N() + "_top");
        this.inside = par1IconRegister.func_94245_a(this.func_149641_N() + "_inside");
    }

    public IIcon func_149691_a(int par1, int par2) {
        return par1 < 2 ? this.top : this.side;
    }

    @Override
    public GasType getGasTypeFromSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_147438_o(x, y, z);
        return tileEntity.containedType != null ? tileEntity.containedType : GasesFrameworkAPI.gasTypeAir;
    }

    @Override
    public GasType takeGasTypeFromSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_147438_o(x, y, z);
        GasType gasType = tileEntity.containedType;
        tileEntity.decrement();
        return gasType != null ? gasType : GasesFrameworkAPI.gasTypeAir;
    }

    @Override
    public boolean canReceiveGas(World world, int x, int y, int z, ForgeDirection side, GasType gasType) {
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_147438_o(x, y, z);
        return tileEntity.canIncrement(gasType);
    }

    @Override
    public boolean receiveGas(World world, int x, int y, int z, ForgeDirection side, GasType gasType) {
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_147438_o(x, y, z);
        return tileEntity.increment(gasType);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityGasTank();
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderBlockGasTank.RENDER_ID;
    }

    @Override
    public GasType sampleInteraction(World world, int x, int y, int z, GasType in, boolean excludes, ForgeDirection side) {
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_147438_o(x, y, z);
        return tileEntity.containedType;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventID, int eventParam) {
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return false;
        }
        return tileEntity.blockEvent(eventID, eventParam);
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldBlockMetadata) {
        TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_147438_o(x, y, z);
        super.func_149749_a(world, x, y, z, oldBlock, oldBlockMetadata);
        if (tileEntity.containedType != null) {
            ArrayList<IVec> stack = new ArrayList<IVec>();
            stack.add(new IVec(x, y, z));
            int pos = 0;
            while (pos < stack.size() && tileEntity.amount-- > 0) {
                IVec current = (IVec)stack.get(pos++);
                world.func_147449_b(current.x, current.y, current.z, tileEntity.containedType.block);
                for (int side = 0; side < 6; ++side) {
                    int zDirection;
                    int yDirection;
                    int xDirection = current.x + (side == 4 ? 1 : (side == 5 ? -1 : 0));
                    if (!world.func_147437_c(xDirection, yDirection = current.y + (side == 0 ? 1 : (side == 1 ? -1 : 0)), zDirection = current.z + (side == 2 ? 1 : (side == 3 ? -1 : 0)))) continue;
                    stack.add(new IVec(xDirection, yDirection, zDirection));
                }
            }
        }
    }

    @Override
    public boolean connectToPipe(IBlockAccess blockaccess, int x, int y, int z, ForgeDirection side) {
        return true;
    }
}

