/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.tileentity;

import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.common.block.BlockGas;
import glenn.gasesframework.common.tileentity.TileEntityGasPump;
import glenn.moddingutils.IVec;
import glenn.moddingutils.KeyPair;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGasCollector
extends TileEntityGasPump {
    private GasType pendingGasType = null;
    private int pendingGasAmount = 0;

    private void getBranching(KeyPair<Integer, IVec> pos, Queue<KeyPair<Integer, IVec>> queue, HashSet<IVec> checked) {
        for (int side = 0; side < 6; ++side) {
            int xDirection = ((IVec)pos.second).x + (side == 4 ? 1 : (side == 5 ? -1 : 0));
            int yDirection = ((IVec)pos.second).y + (side == 0 ? 1 : (side == 1 ? -1 : 0));
            int zDirection = ((IVec)pos.second).z + (side == 2 ? 1 : (side == 3 ? -1 : 0));
            KeyPair<Integer, IVec> branchPos = new KeyPair<Integer, IVec>((Integer)pos.first + 1, new IVec(xDirection, yDirection, zDirection));
            Block posBlock = this.field_145850_b.func_147439_a(xDirection, yDirection, zDirection);
            if (!posBlock.func_149662_c() && !checked.contains(branchPos)) {
                queue.add(branchPos);
            }
            checked.add((IVec)branchPos.second);
        }
    }

    @Override
    protected GasType extract() {
        if (this.pendingGasAmount < 16) {
            LinkedList<KeyPair<Integer, IVec>> queue = new LinkedList<KeyPair<Integer, IVec>>();
            HashSet<IVec> checked = new HashSet<IVec>();
            KeyPair<Integer, IVec> center = new KeyPair<Integer, IVec>(0, new IVec(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            checked.add((IVec)center.second);
            this.getBranching(center, queue, checked);
            while (!queue.isEmpty() && this.pendingGasAmount < 16) {
                KeyPair pos = (KeyPair)queue.remove();
                Block posBlock = this.field_145850_b.func_147439_a(((IVec)pos.second).x, ((IVec)pos.second).y, ((IVec)pos.second).z);
                if (posBlock instanceof BlockGas) {
                    BlockGas gasBlock = (BlockGas)posBlock;
                    if (gasBlock.type.isIndustrial && this.acceptsType(gasBlock.type)) {
                        if (gasBlock.type != this.pendingGasType) {
                            this.pendingGasAmount = 0;
                        }
                        this.pendingGasAmount += 16 - this.field_145850_b.func_72805_g(((IVec)pos.second).x, ((IVec)pos.second).y, ((IVec)pos.second).z);
                        this.pendingGasType = gasBlock.type;
                        this.field_145850_b.func_147468_f(((IVec)pos.second).x, ((IVec)pos.second).y, ((IVec)pos.second).z);
                    }
                }
                if ((Integer)pos.first > 4) continue;
                this.getBranching(pos, queue, checked);
            }
        }
        if (this.pendingGasAmount >= 16) {
            GasType temp = this.pendingGasType;
            if ((this.pendingGasAmount -= 16) == 0) {
                this.pendingGasType = null;
            }
            return temp;
        }
        return super.extract();
    }

    @Override
    protected boolean pumpToBlock(int x, int y, int z, ForgeDirection direction) {
        TileEntityGasCollector tileEntity;
        Block block;
        boolean result = super.pumpToBlock(x, y, z, direction);
        if (this.pendingGasType != null && (block = this.field_145850_b.func_147439_a(x, y, z)) == GasesFramework.gasCollector && (tileEntity = (TileEntityGasCollector)this.field_145850_b.func_147438_o(x, y, z)).acceptsType(this.pendingGasType) && (tileEntity.pendingGasType == null || tileEntity.pendingGasType == this.pendingGasType)) {
            tileEntity.pendingGasAmount += this.pendingGasAmount;
            tileEntity.pendingGasType = this.pendingGasType;
            this.pendingGasAmount = 0;
            this.pendingGasType = null;
        }
        return result;
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("pendingGasType", this.pendingGasType != null ? this.pendingGasType.gasID : -1);
        tagCompound.func_74768_a("pendingGasAmount", this.pendingGasAmount);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.pendingGasType = GasType.getGasTypeByID(tagCompound.func_74762_e("pendingGasType"));
        this.pendingGasAmount = tagCompound.func_74762_e("pendingGasAmount");
    }
}

