/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.gameevent.TickEvent;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.api.gasworldgentype.GasWorldGenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;

public class WorldGeneratorGasesFramework
implements IWorldGenerator {
    private final HashMap<String, HashMap<String, TypeValues>> typesByDimension = new HashMap();
    private final IdentityHashMap<World, HashMap<ChunkCoordIntPair, ChunkBlobs>> chunkBlobsMapsByDimension = new IdentityHashMap();
    private final IdentityHashMap<World, HashMap<ChunkCoordIntPair, HashSet<String>>> chunkRetrogenDataByDimension = new IdentityHashMap();
    private final IdentityHashMap<World, HashMap<ChunkCoordIntPair, HashSet<String>>> chunksToRetrogenByWorld = new IdentityHashMap();
    private static GasWorldGenType currentType;
    private static World currentWorld;

    private HashSet<String> getChunkRetrogenData(World world, ChunkCoordIntPair positionKey) {
        HashMap<ChunkCoordIntPair, HashSet<String>> chunkRetrogenData = this.getChunkRetrogenDataMap(world);
        HashSet<String> retrogenData = chunkRetrogenData.get(positionKey);
        if (retrogenData == null) {
            retrogenData = new HashSet();
            chunkRetrogenData.put(positionKey, retrogenData);
        }
        return retrogenData;
    }

    private HashSet<String> tryGetChunkRetrogenData(World world, ChunkCoordIntPair positionKey) {
        HashMap<ChunkCoordIntPair, HashSet<String>> chunkRetrogenData = this.tryGetChunkRetrogenDataMap(world);
        if (chunkRetrogenData != null) {
            return chunkRetrogenData.get(positionKey);
        }
        return null;
    }

    private HashMap<ChunkCoordIntPair, HashSet<String>> getChunkRetrogenDataMap(World world) {
        HashMap<Object, HashSet<String>> chunkRetrogenData = this.chunkRetrogenDataByDimension.get(world);
        if (chunkRetrogenData == null) {
            chunkRetrogenData = new HashMap();
            this.chunkRetrogenDataByDimension.put(world, chunkRetrogenData);
        }
        return chunkRetrogenData;
    }

    private HashMap<ChunkCoordIntPair, HashSet<String>> tryGetChunkRetrogenDataMap(World world) {
        return this.chunkRetrogenDataByDimension.get(world);
    }

    private HashMap<ChunkCoordIntPair, HashSet<String>> getChunksToRetrogen(World world) {
        HashMap<Object, HashSet<String>> chunksToRetrogen = this.chunksToRetrogenByWorld.get(world);
        if (chunksToRetrogen == null) {
            chunksToRetrogen = new HashMap();
            this.chunksToRetrogenByWorld.put(world, chunksToRetrogen);
        }
        return chunksToRetrogen;
    }

    private HashMap<ChunkCoordIntPair, HashSet<String>> tryGetChunksToRetrogen(World world) {
        return this.chunksToRetrogenByWorld.get(world);
    }

    private void unmapChunkRetrogenData(World world, String dimensionKey, ChunkCoordIntPair positionKey) {
        HashMap<ChunkCoordIntPair, HashSet<String>> chunksToRetrogen;
        HashMap<ChunkCoordIntPair, HashSet<String>> chunkRetrogenData = this.tryGetChunkRetrogenDataMap(world);
        if (chunkRetrogenData != null) {
            chunkRetrogenData.remove(positionKey);
        }
        if ((chunksToRetrogen = this.tryGetChunksToRetrogen(world)) != null) {
            chunksToRetrogen.remove(positionKey);
        }
    }

    private void tryQueueRetrogen(World world, String dimensionKey, ChunkCoordIntPair positionKey) {
        HashMap<String, TypeValues> types = this.typesByDimension.get(dimensionKey);
        if (types != null && types.size() > 0) {
            HashSet<String> previouslyGenerated = this.getChunkRetrogenData(world, positionKey);
            HashSet<String> toGenerate = new HashSet<String>();
            for (TypeValues type : types.values()) {
                if (previouslyGenerated.contains(type.type.name)) continue;
                toGenerate.add(type.type.name);
            }
            if (toGenerate.size() > 0) {
                HashMap<ChunkCoordIntPair, HashSet<String>> chunksToRetrogen = this.getChunksToRetrogen(world);
                chunksToRetrogen.put(positionKey, toGenerate);
            }
        }
    }

    public void registerGasWorldGenType(GasWorldGenType type, String dimension) {
        String dimensionKey = dimension.toLowerCase();
        HashMap<String, TypeValues> typeValuesMap = this.typesByDimension.get(dimensionKey);
        if (typeValuesMap == null) {
            typeValuesMap = new HashMap();
            this.typesByDimension.put(dimension, typeValuesMap);
        }
        TypeValues typeValues = new TypeValues(type);
        if (typeValuesMap.containsKey(typeValues.type.name)) {
            throw new RuntimeException("A gas world gen type was attempted registered to a dimension it was already registered to");
        }
        typeValuesMap.put(typeValues.type.name, typeValues);
    }

    private static int randomRound(float f, Random random) {
        float r = (float)Math.floor(f);
        if (random.nextFloat() < f - r) {
            r += 1.0f;
        }
        return (int)r;
    }

    public synchronized void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        HashMap<String, TypeValues> typesMap = this.typesByDimension.get(world.field_73011_w.func_80007_l().toLowerCase());
        if (typesMap != null) {
            this.generate(chunkX, chunkZ, world, typesMap.values());
        }
    }

    private void generate(int chunkX, int chunkZ, World world, Collection<TypeValues> types) {
        currentWorld = world;
        String dimensionKey = world.field_73011_w.func_80007_l().toLowerCase();
        if (types != null && types.size() > 0) {
            int chunkMinX = chunkX << 4;
            int chunkMinZ = chunkZ << 4;
            int chunkMaxX = chunkMinX + 16;
            int chunkMaxZ = chunkMinZ + 16;
            HashMap<Object, ChunkBlobs> chunkBlobsMap = this.chunkBlobsMapsByDimension.get(dimensionKey);
            if (chunkBlobsMap == null) {
                chunkBlobsMap = new HashMap();
                this.chunkBlobsMapsByDimension.put(world, chunkBlobsMap);
            }
            for (int x = chunkX - 1; x < chunkX + 1; ++x) {
                for (int z = chunkZ - 1; z < chunkZ + 1; ++z) {
                    ChunkCoordIntPair positionKey = new ChunkCoordIntPair(x, z);
                    ChunkBlobs chunkBlobs = chunkBlobsMap.get(positionKey);
                    if (chunkBlobs == null) {
                        chunkBlobs = new ChunkBlobs(x, z, types);
                        chunkBlobsMap.put(positionKey, chunkBlobs);
                    }
                    chunkBlobs.generate(chunkMinX, chunkMinZ, chunkMaxX, chunkMaxZ, types);
                    if (!this.areChunksAroundChunkLoaded(world.func_72863_F(), x, z)) continue;
                    chunkBlobsMap.remove(positionKey);
                }
            }
            HashSet<String> retrogenData = this.getChunkRetrogenData(world, new ChunkCoordIntPair(chunkX, chunkZ));
            for (TypeValues type : types) {
                retrogenData.add(type.type.name);
            }
        }
    }

    private boolean areChunksAroundChunkLoaded(IChunkProvider chunkGenerator, int x, int z) {
        for (int x1 = x; x1 < x - 1; ++x1) {
            for (int z1 = z; z1 < z - 1; ++z1) {
                if (x1 == x || z1 == z || chunkGenerator.func_73149_a(x1, z1)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized void onChunkLoad(ChunkDataEvent.Load event) {
        if (!event.world.field_72995_K) {
            String dimensionKey = event.world.field_73011_w.func_80007_l().toLowerCase();
            Chunk chunk = event.getChunk();
            ChunkCoordIntPair positionKey = chunk.func_76632_l();
            NBTTagCompound data = event.getData();
            NBTTagCompound gasWorldGenData = data.func_74775_l("gasesFramework_worldGenData");
            NBTTagList previouslyGeneratedTypesList = gasWorldGenData.func_150295_c("generatedTypes", 8);
            HashSet<String> retrogenData = this.getChunkRetrogenData(event.world, positionKey);
            for (int i = 0; i < previouslyGeneratedTypesList.func_74745_c(); ++i) {
                retrogenData.add(previouslyGeneratedTypesList.func_150307_f(i));
            }
            if (GasesFramework.configurations.retrogenEnabled) {
                this.tryQueueRetrogen(event.world, dimensionKey, positionKey);
            }
        }
    }

    public synchronized void onChunkSave(ChunkDataEvent.Save event) {
        Collection<TypeValues> types;
        String dimensionKey;
        HashMap<String, TypeValues> typesMap;
        if (!event.world.field_72995_K && (typesMap = this.typesByDimension.get(dimensionKey = event.world.field_73011_w.func_80007_l().toLowerCase())) != null && (types = typesMap.values()) != null) {
            ChunkCoordIntPair positionKey;
            HashSet<String> retrogenData;
            Chunk chunk = event.getChunk();
            HashMap<ChunkCoordIntPair, HashSet<String>> chunkRetrogenData = this.tryGetChunkRetrogenDataMap(chunk.field_76637_e);
            if (chunkRetrogenData != null && (retrogenData = chunkRetrogenData.get(positionKey = chunk.func_76632_l())) != null) {
                NBTTagCompound data = event.getData();
                NBTTagCompound gasWorldGenData = data.func_74775_l("gasesFramework_worldGenData");
                NBTTagList previouslyGeneratedTypesList = gasWorldGenData.func_150295_c("generatedTypes", 8);
                HashSet<String> previouslyGeneratedTypes = new HashSet<String>();
                for (int i = 0; i < previouslyGeneratedTypesList.func_74745_c(); ++i) {
                    previouslyGeneratedTypes.add(previouslyGeneratedTypesList.func_150307_f(i));
                }
                for (String typeName : retrogenData) {
                    if (previouslyGeneratedTypes.contains(typeName)) continue;
                    previouslyGeneratedTypesList.func_74742_a((NBTBase)new NBTTagString(typeName));
                }
                gasWorldGenData.func_74782_a("generatedTypes", (NBTBase)previouslyGeneratedTypesList);
                data.func_74782_a("gasesFramework_worldGenData", (NBTBase)gasWorldGenData);
            }
        }
    }

    public synchronized void onChunkUnload(ChunkEvent.Unload event) {
        Chunk chunk = event.getChunk();
        String dimensionKey = event.world.field_73011_w.func_80007_l().toLowerCase();
        ChunkCoordIntPair positionKey = chunk.func_76632_l();
        this.unmapChunkRetrogenData(chunk.field_76637_e, dimensionKey, positionKey);
    }

    public synchronized void onServerTick(TickEvent.ServerTickEvent event) {
        for (Map.Entry<World, HashMap<ChunkCoordIntPair, HashSet<String>>> chunksToRetrogen : this.chunksToRetrogenByWorld.entrySet()) {
            World world = chunksToRetrogen.getKey();
            for (Map.Entry<ChunkCoordIntPair, HashSet<String>> chunkToRetrogen : chunksToRetrogen.getValue().entrySet()) {
                String dimensionKey = world.field_73011_w.func_80007_l().toLowerCase();
                HashMap<String, TypeValues> types = this.typesByDimension.get(dimensionKey);
                if (types == null) continue;
                ChunkCoordIntPair positionKey = chunkToRetrogen.getKey();
                if (!world.func_72863_F().func_73149_a(positionKey.field_77276_a, positionKey.field_77275_b)) continue;
                HashSet<String> alreadyGenerated = this.getChunkRetrogenData(world, positionKey);
                ArrayList<TypeValues> toGenerate = new ArrayList<TypeValues>();
                for (String typeName : chunkToRetrogen.getValue()) {
                    toGenerate.add(types.get(typeName));
                    alreadyGenerated.add(typeName);
                }
                this.generate(positionKey.field_77276_a, positionKey.field_77275_b, world, toGenerate);
                chunksToRetrogen.getValue().remove(positionKey);
                if (chunksToRetrogen.getValue().size() == 0) {
                    this.chunksToRetrogenByWorld.remove(world);
                }
                return;
            }
        }
    }

    private static class TypeValues {
        public final GasWorldGenType type;
        public final float averageBlobFrequency;
        public final float averagePocketRadius;
        public final float averageBlobRadius;
        public final float blobSpread;

        public TypeValues(GasWorldGenType type) {
            float r3 = (float)((double)type.averageVolume * 3.0 / (Math.PI * 4));
            this.type = type;
            this.averageBlobFrequency = 1.0f + (1.0f - type.evenness) * 9.0f;
            this.averagePocketRadius = (float)Math.cbrt(r3);
            this.averageBlobRadius = 1.5f * (float)Math.cbrt(type.averageVolume / this.averageBlobFrequency);
            this.blobSpread = 2.0f + this.averagePocketRadius * (1.0f - type.evenness);
        }
    }

    private static class ChunkBlobs {
        public final HashMap<String, Pocket[]> pocketsByType = new HashMap();

        public ChunkBlobs(int chunkX, int chunkZ, Collection<TypeValues> types) {
            Random random = new Random(currentWorld.func_72905_C() + (long)(new ChunkCoordIntPair(chunkX, chunkZ).hashCode() * currentWorld.field_73011_w.func_80007_l().hashCode()));
            for (TypeValues type : types) {
                int numPockets = WorldGeneratorGasesFramework.randomRound((random.nextFloat() + 0.5f) * type.type.generationFrequency * (float)(type.type.maxY - type.type.minY) / 16.0f, random);
                Pocket[] pockets = new Pocket[numPockets];
                for (int pocket = 0; pocket < numPockets; ++pocket) {
                    pockets[pocket] = new Pocket(random, chunkX << 4, chunkZ << 4, type);
                }
                this.pocketsByType.put(type.type.name, pockets);
            }
        }

        public void generate(int chunkMinX, int chunkMinZ, int chunkMaxX, int chunkMaxZ, Collection<TypeValues> types) {
            for (TypeValues type : types) {
                Pocket[] pockets;
                currentType = type.type;
                for (Pocket pocket : pockets = this.pocketsByType.get(currentType.name)) {
                    pocket.generate(chunkMinX, chunkMinZ, chunkMaxX, chunkMaxZ);
                }
            }
        }

        private static class Pocket {
            private static final float[][][] preCalculatedDistances = new float[15][15][15];
            public int minX;
            public int minY;
            public int minZ;
            public int maxX;
            public int maxY;
            public int maxZ;
            public final Blob[] blobs;

            private static float getApproximateDistance(float x, float y, float z) {
                return preCalculatedDistances[Math.abs(Math.round(x))][Math.abs(Math.round(y))][Math.abs(Math.round(z))];
            }

            public Pocket(Random random, int absoluteChunkX, int absoluteChunkZ, TypeValues type) {
                float pocketX = (float)absoluteChunkX + random.nextFloat() * 16.0f;
                float pocketY = random.nextFloat() * (float)(type.type.maxY - type.type.minY) + (float)type.type.minY;
                float pocketZ = (float)absoluteChunkZ + random.nextFloat() * 16.0f;
                int numBlobs = WorldGeneratorGasesFramework.randomRound(type.averageBlobFrequency, random);
                this.blobs = new Blob[numBlobs];
                for (int blob = 0; blob < numBlobs; ++blob) {
                    Blob b;
                    float blobZ;
                    float blobY;
                    float blobX;
                    while ((blobX = random.nextFloat() * 2.0f - 1.0f) * blobX + (blobY = random.nextFloat() * 2.0f - 1.0f) * blobY + (blobZ = random.nextFloat() * 2.0f - 1.0f) * blobZ > 1.0f) {
                    }
                    float blobRadius = (random.nextFloat() + 0.5f) * type.averageBlobRadius;
                    this.blobs[blob] = b = new Blob(blobX * type.blobSpread + pocketX, blobY * type.blobSpread + pocketY, blobZ * type.blobSpread + pocketZ, blobRadius);
                    if (blob != 0) {
                        this.minX = Math.min(this.minX, (int)Math.floor(b.x - b.w));
                        this.maxX = Math.min(this.maxX, (int)Math.ceil(b.x + b.w));
                        this.minY = Math.min(this.minY, (int)Math.floor(b.y - b.w));
                        this.maxY = Math.min(this.maxY, (int)Math.ceil(b.y + b.w));
                        this.minZ = Math.min(this.minZ, (int)Math.floor(b.z - b.w));
                        this.maxZ = Math.min(this.maxZ, (int)Math.ceil(b.z + b.w));
                        continue;
                    }
                    this.minX = (int)Math.floor(b.x - b.w);
                    this.maxX = (int)Math.ceil(b.x + b.w);
                    this.minY = (int)Math.floor(b.y - b.w);
                    this.maxY = (int)Math.ceil(b.y + b.w);
                    this.minZ = (int)Math.floor(b.z - b.w);
                    this.maxZ = (int)Math.ceil(b.z + b.w);
                }
            }

            public void generate(int chunkMinX, int chunkMinZ, int chunkMaxX, int chunkMaxZ) {
                int minX = Math.max(this.minX, chunkMinX);
                int maxX = Math.min(this.maxX, chunkMaxX);
                int minZ = Math.max(this.minZ, chunkMinZ);
                int maxZ = Math.min(this.maxZ, chunkMaxZ);
                for (int x = minX; x < maxX; ++x) {
                    float xf = x;
                    for (int y = this.minY; y < this.maxY; ++y) {
                        float yf = y;
                        for (int z = minZ; z < maxZ; ++z) {
                            int volume;
                            float zf = z;
                            float score = 0.0f;
                            for (Blob b : this.blobs) {
                                float r = (b.w - Pocket.getApproximateDistance(b.x - xf, b.y - yf, b.z - zf)) / b.w;
                                if (!(r > 0.0f)) continue;
                                score += r;
                            }
                            if (!(score >= 0.25f) || (volume = currentType.getPlacementVolume(currentWorld, x, y, z, score - 0.25f)) <= 0) continue;
                            currentWorld.func_147465_d(x, y, z, currentType.gasType.block, 16 - volume, 2);
                        }
                    }
                }
            }

            static {
                for (int x = 0; x < 15; ++x) {
                    for (int y = 0; y < 15; ++y) {
                        for (int z = 0; z < 15; ++z) {
                            Pocket.preCalculatedDistances[x][y][z] = (float)Math.sqrt(x * x + y * y + z * z);
                        }
                    }
                }
            }

            private static class Blob {
                public final float x;
                public final float y;
                public final float z;
                public final float w;

                public Blob(float x, float y, float z, float w) {
                    this.x = x;
                    this.y = y;
                    this.z = z;
                    this.w = w;
                }
            }
        }
    }
}

