/*
 * Decompiled with CFR 0.152.
 */
package neresources.compatibility.ic2;

import cpw.mods.fml.common.Optional;
import ic2.core.Ic2Items;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import neresources.api.distributions.DistributionBase;
import neresources.api.distributions.DistributionCustom;
import neresources.api.distributions.DistributionSquare;
import neresources.api.messages.RegisterOreMessage;
import neresources.api.utils.DistributionHelpers;
import neresources.compatibility.CompatBase;
import net.minecraft.item.ItemStack;

public class IC2Compat
extends CompatBase {
    @Override
    protected void init() {
        try {
            Class<?> clz = Class.forName("ic2.core.IC2");
            clz.getField("ironName").get(null);
            clz.getField("displayNoUseItems").get(null);
        }
        catch (Exception e) {
            this.registerIC2Ores();
        }
    }

    @Optional.Method(modid="IC2")
    private void registerIC2Ores() {
        int maxY;
        int veinSize;
        int minY;
        int numVeins;
        float density = ConfigUtil.getFloat((Config)MainConfig.get(), (String)"worldgen/oreDensityFactor");
        int baseScale = Math.round(64.0f * density);
        if (ConfigUtil.getBool((Config)MainConfig.get(), (String)"worldgen/copperOre") && Ic2Items.copperOre != null) {
            numVeins = 15 * baseScale / 64;
            minY = 10;
            int rand1 = 20;
            int rand2 = 40;
            veinSize = 10;
            float chance = (float)(numVeins * veinSize) / ((float)(rand1 + rand2 - 1) * 256.0f);
            this.registerOre(new RegisterOreMessage(Ic2Items.copperOre, (DistributionBase)new DistributionCustom(DistributionHelpers.getTriangularDistribution(minY - veinSize / 2, rand1 + veinSize / 2, rand2 + veinSize / 2, chance)), new ItemStack[0]));
        }
        if (ConfigUtil.getBool((Config)MainConfig.get(), (String)"worldgen/tinOre") && Ic2Items.tinOre != null) {
            numVeins = 25 * baseScale / 64;
            minY = 0;
            maxY = 39;
            veinSize = 6;
            float chance = (float)(numVeins * veinSize) / ((float)(maxY - minY + 1) * 256.0f);
            this.registerOre(new RegisterOreMessage(Ic2Items.tinOre, (DistributionBase)new DistributionSquare(Math.max(0, minY - veinSize / 2), minY, maxY, Math.min(maxY + veinSize / 2, 255), chance), new ItemStack[0]));
        }
        if (ConfigUtil.getBool((Config)MainConfig.get(), (String)"worldgen/uraniumOre") && Ic2Items.uraniumOre != null) {
            numVeins = 20 * baseScale / 64;
            minY = 0;
            maxY = 63;
            veinSize = 3;
            float chance = (float)(numVeins * veinSize) / ((float)(maxY - minY + 1) * 256.0f);
            this.registerOre(new RegisterOreMessage(Ic2Items.uraniumOre, (DistributionBase)new DistributionSquare(Math.max(0, minY - veinSize / 2), minY, maxY, Math.min(maxY + veinSize / 2, 255), chance), new ItemStack[0]));
        }
        if (ConfigUtil.getBool((Config)MainConfig.get(), (String)"worldgen/leadOre") && Ic2Items.leadOre != null) {
            numVeins = 8 * baseScale / 64;
            minY = 0;
            maxY = 63;
            veinSize = 4;
            float chance = (float)(numVeins * veinSize) / ((float)(maxY - minY + 1) * 256.0f);
            this.registerOre(new RegisterOreMessage(Ic2Items.leadOre, (DistributionBase)new DistributionSquare(Math.max(0, minY - veinSize / 2), minY, maxY, Math.min(maxY + veinSize / 2, 255), chance), new ItemStack[0]));
        }
    }
}

