/*
 * Decompiled with CFR 0.152.
 */
package neresources.compatibility.thaumcraft;

import cpw.mods.fml.common.Optional;
import neresources.api.distributions.DistributionBase;
import neresources.api.distributions.DistributionCustom;
import neresources.api.distributions.DistributionSquare;
import neresources.api.messages.ModifyOreMessage;
import neresources.api.messages.RegisterOreMessage;
import neresources.api.utils.DistributionHelpers;
import neresources.api.utils.DropItem;
import neresources.api.utils.LightLevel;
import neresources.api.utils.Modifier;
import neresources.api.utils.Priority;
import neresources.api.utils.conditionals.Conditional;
import neresources.compatibility.CompatBase;
import neresources.entries.MobEntry;
import neresources.registry.MessageRegistry;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.entities.monster.EntityCultistCleric;
import thaumcraft.common.entities.monster.EntityCultistKnight;
import thaumcraft.common.entities.monster.EntityMindSpider;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.entities.monster.EntityTaintChicken;
import thaumcraft.common.entities.monster.EntityTaintCow;
import thaumcraft.common.entities.monster.EntityTaintCreeper;
import thaumcraft.common.entities.monster.EntityTaintPig;
import thaumcraft.common.entities.monster.EntityTaintSheep;
import thaumcraft.common.entities.monster.EntityTaintSpider;
import thaumcraft.common.entities.monster.EntityTaintSporeSwarmer;
import thaumcraft.common.entities.monster.EntityTaintVillager;
import thaumcraft.common.entities.monster.EntityTaintacle;
import thaumcraft.common.entities.monster.EntityTaintacleSmall;
import thaumcraft.common.entities.monster.EntityWisp;

public class ThaumcraftCompat
extends CompatBase {
    @Override
    protected void init() {
        this.registerThaumcraftOres();
        this.registerThaumcraftMobs();
    }

    @Optional.Method(modid="Thaumcraft")
    private void registerThaumcraftOres() {
        ItemStack amber = new ItemStack(ConfigBlocks.blockCustomOre, 1, 7);
        ItemStack amberDrop = new ItemStack(ConfigItems.itemResource, 1, 6);
        MessageRegistry.addMessage(new ModifyOreMessage(amber, Priority.FIRST, amberDrop));
        for (int i = 0; i < 6; ++i) {
            ItemStack infusedStone = new ItemStack(ConfigBlocks.blockCustomOre, 1, i + 1);
            ItemStack infusedShard = new ItemStack(ConfigItems.itemShard, 2, i);
            MessageRegistry.addMessage(new ModifyOreMessage(infusedStone, Priority.FIRST, infusedShard));
        }
        if (Config.genCinnibar) {
            this.genCinnibar();
        }
        if (Config.genAmber) {
            this.genAmber();
        }
        if (Config.genInfusedStone) {
            this.genInfused();
        }
    }

    @Optional.Method(modid="Thaumcraft")
    private void registerThaumcraftMobs() {
        EntityLivingBase[] taintedEntities;
        Conditional randomAspect = new Conditional("ner.randomAspect.text", Modifier.pink);
        String[] tainted = new String[]{"Tainted areas"};
        DropItem flesh = new DropItem(Items.field_151078_bh, 0, 2, new Conditional[0]);
        DropItem brain = new DropItem(ConfigItems.itemZombieBrain, 0, 1, new Conditional[0]);
        if (Config.spawnAngryZombie) {
            this.registerMob(new MobEntry((EntityLivingBase)new EntityBrainyZombie(world), LightLevel.hostile, flesh, brain));
        }
        DropItem essence = new DropItem(new ItemStack(ConfigItems.itemWispEssence), 1, 1, randomAspect);
        if (Config.spawnWisp) {
            this.registerMob(new MobEntry((EntityLivingBase)new EntityWisp(world), LightLevel.hostile, essence));
        }
        DropItem knowledge = new DropItem(new ItemStack(ConfigItems.itemResource, 1, 9), 1, 1, 0.025f, Conditional.playerKill, Conditional.rareDrop);
        DropItem bean = new DropItem(new ItemStack(ConfigItems.itemManaBean), 0, 1, randomAspect);
        if (Config.spawnPech) {
            this.registerMob(new MobEntry((EntityLivingBase)new EntityPech(world), LightLevel.any, bean, knowledge));
        }
        DropItem taintSlime = new DropItem(new ItemStack(ConfigItems.itemResource, 1, 11), 0, 1, new Conditional[0]);
        DropItem taintTendril = new DropItem(new ItemStack(ConfigItems.itemResource, 1, 12), 0, 1, new Conditional[0]);
        if (Config.spawnTaintacle) {
            this.registerMob(new MobEntry((EntityLivingBase)new EntityTaintacle(world), LightLevel.any, tainted, taintSlime, taintTendril));
            this.registerMob(new MobEntry((EntityLivingBase)new EntityTaintacleSmall(world), LightLevel.any, tainted, new DropItem[0]));
        }
        if (Config.spawnTaintSpore) {
            this.registerMob(new MobEntry((EntityLivingBase)new EntityTaintSporeSwarmer(world), LightLevel.any, tainted, taintSlime, taintTendril));
        }
        taintSlime = new DropItem(new ItemStack(ConfigItems.itemResource, 1, 11), 0, 1, 0.166f, new Conditional[0]);
        taintTendril = new DropItem(new ItemStack(ConfigItems.itemResource, 1, 12), 0, 1, 0.166f, new Conditional[0]);
        for (EntityLivingBase entity : taintedEntities = new EntityLivingBase[]{new EntityTaintChicken(world), new EntityTaintCow(world), new EntityTaintCreeper(world), new EntityTaintPig(world), new EntityTaintSheep(world), new EntityTaintSheep(world), new EntityTaintSpider(world), new EntityTaintVillager(world)}) {
            this.registerMob(new MobEntry(entity, LightLevel.any, tainted, taintSlime, taintTendril));
        }
        DropItem string = new DropItem(Items.field_151007_F, 0, 2, new Conditional[0]);
        DropItem spider = new DropItem(Items.field_151070_bp, 1, 1, 0.33f, Conditional.playerKill);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityMindSpider(world), LightLevel.hostile, string, spider));
        knowledge = new DropItem(new ItemStack(ConfigItems.itemResource, 1, 9), 0, 1, 0.1f, new Conditional[0]);
        DropItem voidSeed = new DropItem(new ItemStack(ConfigItems.itemResource, 1, 17), 0, 1, 0.2f, new Conditional[0]);
        DropItem crimsonRites = new DropItem(new ItemStack(ConfigItems.itemEldritchObject, 1, 1), 1, 1, 0.025f, Conditional.playerKill, Conditional.rareDrop);
        DropItem cultHelmet = new DropItem(new ItemStack(ConfigItems.itemHelmetCultistPlate), 0, 1, 0.085f, Conditional.equipmentDrop);
        DropItem cultChest = new DropItem(new ItemStack(ConfigItems.itemChestCultistPlate), 0, 1, 0.085f, Conditional.equipmentDrop);
        DropItem cultLegs = new DropItem(new ItemStack(ConfigItems.itemLegsCultistPlate), 0, 1, 0.085f, Conditional.equipmentDrop);
        DropItem cultBoots = new DropItem(new ItemStack(ConfigItems.itemBootsCultist), 0, 1, 0.085f, Conditional.equipmentDrop);
        DropItem thaumSword = new DropItem(new ItemStack(ConfigItems.itemSwordThaumium), 0, 1, 0.085f, Conditional.equipmentDrop);
        DropItem cultRobeHelmet = new DropItem(new ItemStack(ConfigItems.itemHelmetCultistRobe), 0, 1, 0.085f, Conditional.equipmentDrop);
        DropItem voidSword = new DropItem(new ItemStack(ConfigItems.itemSwordVoid), 0, 1, 0.085f, Conditional.equipmentDrop);
        DropItem cultRobeChest = new DropItem(new ItemStack(ConfigItems.itemChestCultistRobe), 0, 1, 0.085f, Conditional.equipmentDrop);
        DropItem cultRobeLegs = new DropItem(new ItemStack(ConfigItems.itemLegsCultistRobe), 0, 1, 0.085f, Conditional.equipmentDrop);
        this.registerMob(new MobEntry((EntityLivingBase)new EntityCultistKnight(world), LightLevel.hostile, voidSeed, knowledge, crimsonRites, cultHelmet, cultChest, cultLegs, cultBoots, thaumSword, cultRobeHelmet, voidSword));
        this.registerMob(new MobEntry((EntityLivingBase)new EntityCultistCleric(world), LightLevel.hostile, voidSeed, knowledge, crimsonRites, cultRobeHelmet, cultRobeChest, cultRobeLegs, cultBoots));
    }

    @Optional.Method(modid="Thaumcraft")
    private void genInfused() {
        int minY = 5;
        int maxY = 59;
        int veinSize = 6;
        float numVeins = 8.0f;
        float chance = numVeins / (float)((maxY - minY + 1) * 256);
        for (int i = 0; i < 6; ++i) {
            ItemStack infusedStone = new ItemStack(ConfigBlocks.blockCustomOre, 1, i + 1);
            this.registerOre(new RegisterOreMessage(infusedStone, (DistributionBase)new DistributionSquare(Math.max(0, minY - veinSize / 2), minY, maxY, Math.min(maxY + veinSize / 2, 255), chance), new ItemStack[0]));
        }
    }

    @Optional.Method(modid="Thaumcraft")
    private void genAmber() {
        int minY = 0;
        int maxY = 64;
        float maxYRange = 25.0f;
        float numVeins = 20.0f;
        float chance = numVeins / (((float)maxY - maxYRange / 2.0f - (float)minY + 1.0f) * 256.0f);
        float[] distribution = DistributionHelpers.getSquareDistribution(minY, maxY - (int)maxYRange, chance);
        DistributionHelpers.addDistribution(distribution, DistributionHelpers.getRampDistribution(maxY, (int)((float)maxY - maxYRange), chance), maxY - (int)maxYRange);
        ItemStack amber = new ItemStack(ConfigBlocks.blockCustomOre, 1, 7);
        this.registerOre(new RegisterOreMessage(amber, (DistributionBase)new DistributionCustom(distribution), new ItemStack[0]));
    }

    @Optional.Method(modid="Thaumcraft")
    private void genCinnibar() {
        int minY = 0;
        int maxY = 12;
        float numVeins = 18.0f;
        float chance = numVeins / (float)(maxY * 256);
        ItemStack ore = new ItemStack(ConfigBlocks.blockCustomOre, 1, 0);
        this.registerOre(new RegisterOreMessage(ore, (DistributionBase)new DistributionSquare(minY, maxY, chance), new ItemStack[0]));
    }
}

