/*
 * Decompiled with CFR 0.152.
 */
package neresources.entries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import neresources.api.messages.RegisterMobMessage;
import neresources.api.utils.DropItem;
import neresources.api.utils.LightLevel;
import neresources.utils.ReflectionHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MobEntry {
    private EntityLivingBase entity;
    private List<DropItem> drops = new ArrayList<DropItem>();
    private LightLevel lightLevel;
    private List<String> biomes = new ArrayList<String>();

    public MobEntry(EntityLivingBase entity, LightLevel lightLevel, String[] biomes, DropItem ... drops) {
        this.entity = entity;
        this.lightLevel = lightLevel;
        this.biomes.addAll(Arrays.asList(biomes));
        this.drops.addAll(Arrays.asList(drops));
    }

    public MobEntry(EntityLivingBase entity, LightLevel lightLevel, DropItem ... drops) {
        this.entity = entity;
        this.lightLevel = lightLevel;
        this.biomes.add("Any");
        this.drops.addAll(Arrays.asList(drops));
    }

    public MobEntry(RegisterMobMessage message) {
        if (!ReflectionHelper.isInstanceOf(message.getMobClass(), EntityLivingBase.class)) {
            return;
        }
        this.entity = (EntityLivingBase)ReflectionHelper.initialize(message.getMobClass(), World.class, null);
        this.lightLevel = message.getLightLevel();
        for (DropItem drop : message.getDrops()) {
            this.drops.add(drop);
        }
        Collections.sort(this.drops);
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public String getMobName() {
        return this.entity.func_70005_c_();
    }

    public DropItem[] getDrops() {
        return this.drops.toArray(new DropItem[this.drops.size()]);
    }

    public String[] getBiomes() {
        return this.biomes.toArray(new String[this.biomes.size()]);
    }

    public boolean addDrop(DropItem item) {
        for (DropItem drop : this.drops) {
            if (!drop.item.func_77969_a(item.item)) continue;
            return false;
        }
        this.drops.add(item);
        Collections.sort(this.drops);
        return true;
    }

    public LightLevel getLightLevel() {
        return this.lightLevel;
    }

    public void removeDrop(ItemStack item) {
        int i;
        for (i = 0; i < this.drops.size() && !this.drops.get((int)i).item.func_77969_a(item); ++i) {
        }
        if (i < this.drops.size()) {
            this.drops.remove(i);
        }
    }
}

