/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.block;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.malisis.core.util.chunklistener.IBlockListener;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.tileentity.CarriageDoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CarriageDoor
extends MalisisBlock
implements ITileEntityProvider,
IChunkCollidable,
IBlockListener {
    protected IIcon frameIcon;
    public static int renderId;
    private AxisAlignedBB defaultBoundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.8125, (double)4.0, (double)5.0, (double)1.0);

    public CarriageDoor() {
        super(Material.field_151575_d);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149769_e);
        this.func_149663_c("carriage_door");
        this.func_149647_a(MalisisDoors.tab);
    }

    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("malisisdoors:carriage_door");
        this.frameIcon = register.func_94245_a("malisisdoors:carriage_frame");
    }

    public IIcon getFrameIcon() {
        return this.frameIcon;
    }

    public String func_149702_O() {
        return "malisisdoors:carriage_item";
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (side != 1) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        return world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isSideSolid((IBlockAccess)world, x, y, z, dir);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        ForgeDirection dir = EntityUtils.getEntityFacing((Entity)player);
        int metadata = Door.dirToInt(dir);
        world.func_72921_c(x, y, z, metadata, 2);
        ChunkCollision.get().replaceBlocks(world, new BlockState((IBlockAccess)world, x, y, z));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        CarriageDoorTileEntity te = (CarriageDoorTileEntity)((Object)TileEntityUtils.getTileEntity(CarriageDoorTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null) {
            return true;
        }
        te.openOrCloseDoor();
        return true;
    }

    public AxisAlignedBB[] getPlacedBoundingBox(IBlockAccess world, int x, int y, int z, int side, EntityPlayer player, ItemStack itemStack) {
        ForgeDirection dir = EntityUtils.getEntityFacing((Entity)player);
        return AABBUtils.rotate((AxisAlignedBB[])new AxisAlignedBB[]{this.defaultBoundingBox.func_72329_c()}, (ForgeDirection)dir);
    }

    public AxisAlignedBB[] getBoundingBox(IBlockAccess world, int x, int y, int z, BoundingBoxType type) {
        CarriageDoorTileEntity te = (CarriageDoorTileEntity)((Object)TileEntityUtils.getTileEntity(CarriageDoorTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null) {
            return AABBUtils.identities();
        }
        AxisAlignedBB[] aabbs = new AxisAlignedBB[]{this.defaultBoundingBox.func_72329_c()};
        if (type == BoundingBoxType.RENDER) {
            aabbs[0].field_72339_c = -0.5;
        } else if ((type == BoundingBoxType.COLLISION || type == BoundingBoxType.CHUNKCOLLISION || type == BoundingBoxType.RAYTRACE) && (te.isOpened() || te.isMoving())) {
            aabbs = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)-0.5, (double)0.5, (double)4.0, (double)1.0), AxisAlignedBB.func_72330_a((double)3.5, (double)0.0, (double)-0.5, (double)4.0, (double)4.0, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)4.0, (double)0.8125, (double)4.0, (double)5.0, (double)1.0)};
        }
        return AABBUtils.rotate((AxisAlignedBB[])aabbs, (ForgeDirection)Door.intToDir(te.getDirection()));
    }

    public int blockRange() {
        return 5;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new CarriageDoorTileEntity();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }

    public boolean onBlockSet(World world, BlockPos pos, BlockState state) {
        if (!state.getBlock().isReplaceable((IBlockAccess)world, state.getX(), state.getY(), state.getZ())) {
            return true;
        }
        for (AxisAlignedBB aabb : AABBUtils.getCollisionBoundingBoxes((World)world, (BlockState)new BlockState(pos, (Block)this), (boolean)true)) {
            if (!state.getPos().isInside(aabb)) continue;
            return false;
        }
        return true;
    }

    public boolean onBlockRemoved(World world, BlockPos pos, BlockPos blockPos) {
        return true;
    }
}

