/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.replacement.ReplacementTool;
import net.malisis.doors.door.renderer.DoorRenderer;
import net.malisis.doors.door.tileentity.FenceGateTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;

public class FenceGateRenderer
extends DoorRenderer {
    protected FenceGateTileEntity tileEntity;

    @Override
    protected void initialize() {
        float w = 0.125f;
        float w2 = 0.1875f;
        Shape hinge = new Cube().setSize(w, 0.6875f, w);
        hinge.translate(0.0f, 0.3125f, 0.5f - w / 2.0f);
        Shape gateH = new Cube().setSize(w, w2 * 3.0f, w);
        gateH.translate(0.5f - w, 0.375f, 0.5f - w / 2.0f);
        Shape gateBottom = new Cube().setSize(2.0f * w, w2, w);
        gateBottom.translate(w, 0.375f, 0.5f - w / 2.0f);
        Shape gateTop = new Shape(gateBottom);
        gateTop.translate(0.0f, 2.0f * w2, 0.0f);
        Shape right = Shape.fromShapes((Shape[])new Shape[]{hinge, gateH, gateBottom, gateTop});
        right.applyMatrix();
        right.interpolateUV();
        Shape left = new Shape(right);
        left.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        this.model = new MalisisModel();
        this.model.addShape("right", right);
        this.model.addShape("left", left);
        this.model.storeState();
        this.initParams();
    }

    @Override
    protected void setTileEntity() {
        super.setTileEntity();
        this.tileEntity = (FenceGateTileEntity)((DoorRenderer)this).tileEntity;
    }

    @Override
    protected void setup() {
        this.model.resetState();
        if (this.direction == 1 || this.direction == 3) {
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (this.tileEntity.isWall()) {
            this.model.translate(0.0f, -0.19f, 0.0f);
        }
        this.rp.icon.set((Object)this.tileEntity.getCamoIcon());
        this.rp.colorMultiplier.set((Object)this.tileEntity.getCamoColor());
        this.rp.brightness.set((Object)this.block.func_149677_c(this.world, this.x, this.y, this.z));
    }

    @Override
    protected void renderTileEntity() {
        this.enableBlending();
        this.ar.setStartTime(this.tileEntity.getTimer().getStart());
        this.setup();
        if (this.tileEntity.getMovement() != null) {
            Animation[] anims = this.tileEntity.getMovement().getAnimations(this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.model.render((MalisisRenderer)this, this.rp);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        renderer.func_147800_a(ReplacementTool.orignalBlock((Block)block), 0, 1.0f);
    }

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

