/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweaks.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import iguanaman.iguanatweaks.IguanaTweaks;
import iguanaman.iguanatweaks.config.IguanaConfig;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class IguanaPlayerHandler {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (IguanaConfig.spawnLocationRandomisationMax > 0) {
            NBTTagCompound tagsIguana;
            NBTTagCompound tags = event.player.getEntityData();
            if (!tags.func_74764_b("IguanaTweaks")) {
                tags.func_74782_a("IguanaTweaks", (NBTBase)new NBTTagCompound());
            }
            if (!(tagsIguana = tags.func_74775_l("IguanaTweaks")).func_74764_b("Spawned")) {
                tagsIguana.func_74757_a("Spawned", true);
                this.respawnPlayer((EntityPlayerMP)event.player, IguanaConfig.spawnLocationRandomisationMin, IguanaConfig.spawnLocationRandomisationMax);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        World world;
        ChunkCoordinates bedLoc;
        int respawnHealth = IguanaConfig.respawnHealth;
        if (IguanaConfig.respawnHealthDifficultyScaling) {
            if (event.player.field_70170_p.field_73013_u.func_151525_a() == 3) {
                respawnHealth = Math.max(Math.round((float)respawnHealth / 2.0f), 1);
            } else if (event.player.field_70170_p.field_73013_u.func_151525_a() <= 1) {
                respawnHealth = Math.min(respawnHealth * 2, 20);
            }
        }
        event.player.func_70606_j((float)respawnHealth);
        if (IguanaConfig.respawnLocationRandomisationMax > 0) {
            IguanaTweaks.log.info("respawn code running onPlayerRespawn");
            this.respawnPlayer((EntityPlayerMP)event.player, IguanaConfig.respawnLocationRandomisationMin, IguanaConfig.respawnLocationRandomisationMax);
            event.player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.randReSpawn", new Object[0]));
        }
        if (IguanaConfig.destroyBedOnRespawn && (bedLoc = event.player.getBedLocation(event.player.field_71093_bK)) != null && (world = event.player.field_70170_p).func_147439_a(bedLoc.field_71574_a, bedLoc.field_71572_b, bedLoc.field_71573_c) == Blocks.field_150324_C) {
            int x = bedLoc.field_71574_a;
            int z = bedLoc.field_71573_c;
            int meta = world.func_72805_g(x, bedLoc.field_71572_b, z);
            if (BlockBed.func_149975_b((int)meta)) {
                block0: for (int testX = x - 1; testX <= x + 1; ++testX) {
                    for (int testZ = z - 1; testZ <= z + 1; ++testZ) {
                        if (world.func_147439_a(testX, bedLoc.field_71572_b, testZ) != Blocks.field_150324_C || BlockBed.func_149975_b((int)(meta = world.func_72805_g(testX, bedLoc.field_71572_b, testZ)))) continue;
                        x = testX;
                        z = testZ;
                        continue block0;
                    }
                }
            }
            event.player.field_70170_p.func_147480_a(x, bedLoc.field_71572_b, z, false);
            event.player.setSpawnChunk(null, false, event.player.field_71093_bK);
            if (IguanaConfig.respawnLocationRandomisationMax == 0) {
                event.player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.bedGone", new Object[0]));
            }
        }
    }

    public static ChunkCoordinates randomiseCoordinates(World world, int x, int z, int rndFactorMin, int rndFactorMax) {
        for (int attempt = 1; attempt <= 10; ++attempt) {
            int newY;
            int modX = rndFactorMin;
            if (rndFactorMax - rndFactorMin > 0) {
                modX += world.field_73012_v.nextInt(rndFactorMax - rndFactorMin);
            }
            if (world.field_73012_v.nextInt(100) < 50) {
                modX *= -1;
            }
            int newX = x + modX;
            int modZ = rndFactorMin;
            if (rndFactorMax - rndFactorMin > 0) {
                modZ += world.field_73012_v.nextInt(rndFactorMax - rndFactorMin);
            }
            if (world.field_73012_v.nextInt(100) < 50) {
                modZ *= -1;
            }
            int newZ = z + modZ;
            BiomeGenBase biome = world.func_72959_q().func_76935_a(newX, newZ);
            BiomeDictionary.Type[] biomeTypes = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
            if (biomeTypes.length == 1 && biomeTypes[0] == BiomeDictionary.Type.WATER || (newY = world.func_72825_h(newX, newZ)) < 0) continue;
            IguanaTweaks.log.info("Good spawn found at " + newX + ", " + newY + ", " + newZ);
            return new ChunkCoordinates(newX, newY, newZ);
        }
        return null;
    }

    public void respawnPlayer(EntityPlayerMP player, int rndFactorMin, int rndFactorMax) {
        World world;
        ChunkCoordinates newCoords;
        int x = (int)player.field_70165_t;
        int z = (int)player.field_70161_v;
        if (x < 0) {
            --x;
        }
        if (z < 0) {
            --z;
        }
        if ((newCoords = IguanaPlayerHandler.randomiseCoordinates(world = player.field_70170_p, x, z, rndFactorMin, rndFactorMax)) != null) {
            player.func_70012_b((double)((float)newCoords.field_71574_a + 0.5f), (double)((float)newCoords.field_71572_b + 1.1f), (double)((float)newCoords.field_71573_c + 0.5f), 0.0f, 0.0f);
            WorldServer worldserver = player.func_71121_q();
            worldserver.field_73059_b.func_73158_c((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
            while (!worldserver.func_72945_a((Entity)player, player.field_70121_D).isEmpty()) {
                player.func_70107_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
            }
            player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        }
    }
}

