/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class ManualPageMultiblock
extends ManualPages {
    MultiblockHandler.IMultiblock multiblock;
    boolean canTick = true;
    int tick = 0;
    int showLayer = -1;
    int blockCount = 0;
    int[] countPerLevel;
    int structureHeight = 0;
    int structureLength = 0;
    int structureWidth = 0;

    public ManualPageMultiblock(ManualInstance manual, String text, MultiblockHandler.IMultiblock multiblock) {
        super(manual, text);
        this.multiblock = multiblock;
    }

    @Override
    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        int yOff = 0;
        if (this.multiblock.getStructureManual() != null) {
            ItemStack[][][] structure = this.multiblock.getStructureManual();
            this.structureHeight = structure.length;
            this.structureWidth = 0;
            this.structureLength = 0;
            this.countPerLevel = new int[this.structureHeight];
            this.blockCount = 0;
            for (int h = 0; h < structure.length; ++h) {
                if (structure[h].length - 1 > this.structureLength) {
                    this.structureLength = structure[h].length - 1;
                }
                int perLvl = 0;
                for (int l = 0; l < structure[h].length; ++l) {
                    if (structure[h][l].length - 1 > this.structureWidth) {
                        this.structureWidth = structure[h][l].length - 1;
                    }
                    for (ItemStack ss : structure[h][l]) {
                        if (ss == null) continue;
                        ++perLvl;
                    }
                }
                this.countPerLevel[h] = perLvl;
                this.blockCount += perLvl;
            }
            this.tick = (this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) * 40;
            yOff = (this.structureHeight - 1) * 12 + this.structureWidth * 5 + this.structureLength * 5 + 16;
            yOff = Math.max(48, yOff);
            pageButtons.add(new GuiButtonManualNavigation(gui, 100, x + 4, y + yOff / 2 - 5, 10, 10, 4));
            if (this.structureHeight > 1) {
                pageButtons.add(new GuiButtonManualNavigation(gui, 101, x + 4, y + yOff / 2 - 8 - 16, 10, 16, 3));
                pageButtons.add(new GuiButtonManualNavigation(gui, 102, x + 4, y + yOff / 2 + 8, 10, 16, 2));
            }
        }
        super.initPage(gui, x, y + yOff, pageButtons);
    }

    @Override
    public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
        if (this.multiblock.getStructureManual() != null) {
            if (this.canTick) {
                ++this.tick;
            }
            ItemStack[][][] structure = this.multiblock.getStructureManual();
            int prevLayers = 0;
            if (this.showLayer != -1) {
                for (int ll = 0; ll < this.showLayer; ++ll) {
                    prevLayers += this.countPerLevel[ll];
                }
            }
            int limiter = prevLayers + this.tick / 40 % ((this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) + 4);
            int xHalf = this.structureWidth * 5 - this.structureLength * 5;
            int yOffPartial = (this.structureHeight - 1) * 12 + this.structureWidth * 5 + this.structureLength * 5;
            int yOffTotal = Math.max(48, yOffPartial + 16);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            RenderItem.getInstance().field_77024_a = true;
            int i = 0;
            ItemStack highlighted = null;
            for (int h = 0; h < structure.length; ++h) {
                if (this.showLayer != -1 && h > this.showLayer) continue;
                ItemStack[][] level = structure[h];
                for (int l = level.length - 1; l >= 0; --l) {
                    ItemStack[] row = level[l];
                    for (int w = row.length - 1; w >= 0; --w) {
                        int xx = 60 + xHalf - 10 * w + 10 * l - 7;
                        int yy = yOffPartial - 5 * w - 5 * l - 12 * h;
                        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
                        if (row[w] == null || i > limiter) continue;
                        ++i;
                        RenderItem.getInstance().func_77015_a(this.manual.fontRenderer, ManualUtils.mc().field_71446_o, row[w], x + xx, y + yy);
                        if (mx < x + xx || mx >= x + xx + 16 || my < y + yy || my >= y + yy + 16) continue;
                        highlighted = row[w];
                    }
                }
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-i));
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2929);
            this.manual.fontRenderer.func_78264_a(false);
            if (this.multiblock.getTotalMaterials() != null) {
                this.manual.fontRenderer.func_85187_a("?", x + 116, y + yOffTotal / 2 - 4, this.manual.getTextColour(), false);
            }
            if (highlighted != null) {
                gui.func_146285_a(highlighted, mx, my);
            } else if (this.multiblock.getTotalMaterials() != null && mx >= x + 116 && mx < x + 122 && my >= y + yOffTotal / 2 - 4 && my < y + yOffTotal / 2 + 4) {
                ArrayList<String> components = new ArrayList<String>();
                components.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.info.reqMaterial"));
                int maxOff = 1;
                for (ItemStack ss : this.multiblock.getTotalMaterials()) {
                    if (("" + ss.field_77994_a).length() <= maxOff) continue;
                    maxOff = ("" + ss.field_77994_a).length();
                }
                for (ItemStack ss : this.multiblock.getTotalMaterials()) {
                    if (ss == null) continue;
                    int indent = 0;
                    if (maxOff > ("" + ss.field_77994_a).length()) {
                        indent = maxOff - ("" + ss.field_77994_a).length();
                    }
                    String sIndent = "";
                    if (indent > 0) {
                        for (int ii = 0; ii < indent; ++ii) {
                            sIndent = sIndent + "0";
                        }
                    }
                    components.add("" + EnumChatFormatting.GRAY + sIndent + ss.field_77994_a + "x " + EnumChatFormatting.RESET + ss.func_77953_t().field_77937_e + ss.func_82833_r());
                }
                gui.drawHoveringText(components, mx, my, this.manual.fontRenderer);
            }
            RenderHelper.func_74518_a();
            this.manual.fontRenderer.func_78264_a(true);
            if (this.localizedText != null && !this.localizedText.isEmpty()) {
                this.manual.fontRenderer.func_78279_b(this.localizedText, x, y + yOffTotal, 120, this.manual.getTextColour());
            }
        }
    }

    @Override
    public void buttonPressed(GuiManual gui, GuiButton button) {
        if (button.field_146127_k == 100) {
            boolean bl = this.canTick = !this.canTick;
        }
        if (button.field_146127_k == 101) {
            this.showLayer = Math.min(this.showLayer + 1, this.structureHeight - 1);
            this.tick = this.countPerLevel[this.showLayer] * 40;
        }
        if (button.field_146127_k == 102) {
            this.showLayer = Math.max(this.showLayer - 1, -1);
            this.tick = (this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) * 40;
        }
        super.buttonPressed(gui, button);
    }
}

