/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ExcavatorHandler {
    public static LinkedHashMap<MineralMix, Integer> mineralList = new LinkedHashMap();
    public static HashMap<DimensionChunkCoords, Integer> mineralDepletion = new HashMap();
    public static int totalWeight = 0;
    public static int mineralVeinCapacity = 0;

    public static MineralMix addMineral(String name, int mineralChance, float failChance, String[] ores, float[] chances) {
        assert (ores.length == chances.length);
        MineralMix mix = new MineralMix(name, failChance, ores, chances);
        mineralList.put(mix, mineralChance);
        return mix;
    }

    public static void recalculateChances() {
        totalWeight = 0;
        for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
            totalWeight += e.getValue().intValue();
            e.getKey().recalculateChances();
        }
    }

    public static MineralMix getRandomMineral(World world, int chunkX, int chunkZ) {
        long seed;
        if (world.field_72995_K) {
            return null;
        }
        if (mineralVeinCapacity >= 0) {
            int dep;
            if (!mineralDepletion.containsKey((Object)new DimensionChunkCoords(world.field_73011_w.field_76574_g, chunkX, chunkZ))) {
                mineralDepletion.put(new DimensionChunkCoords(world.field_73011_w.field_76574_g, chunkX, chunkZ), 0);
            }
            if ((dep = mineralDepletion.get((Object)new DimensionChunkCoords(world.field_73011_w.field_76574_g, chunkX, chunkZ)).intValue()) > mineralVeinCapacity) {
                return null;
            }
        }
        boolean empty = ((seed = world.func_72905_C()) + (long)(chunkX * chunkX + chunkZ * chunkZ) ^ seed) % 8L != 0L;
        int query = (int)(seed + (long)(chunkX * chunkX * 71862 + chunkZ * chunkZ * 31261) ^ seed);
        if (empty) {
            return null;
        }
        int weight = Math.abs(query % totalWeight);
        for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
            if ((weight -= e.getValue().intValue()) >= 0) continue;
            return e.getKey();
        }
        return null;
    }

    public static void depleteMinerals(World world, int chunkX, int chunkZ) {
        if (!mineralDepletion.containsKey((Object)new DimensionChunkCoords(world.field_73011_w.field_76574_g, chunkX, chunkZ))) {
            mineralDepletion.put(new DimensionChunkCoords(world.field_73011_w.field_76574_g, chunkX, chunkZ), 0);
        }
        int dep = mineralDepletion.get((Object)new DimensionChunkCoords(world.field_73011_w.field_76574_g, chunkX, chunkZ));
        mineralDepletion.put(new DimensionChunkCoords(world.field_73011_w.field_76574_g, chunkX, chunkZ), dep + 1);
    }

    public static class MineralMix {
        public String name;
        public float failChance;
        public String[] ores;
        public float[] chances;
        public String[] recalculatedOres;
        public float[] recalculatedChances;
        public HashMap<String, String> replacementOres;

        public MineralMix(String name, float failChance, String[] ores, float[] chances) {
            this.name = name;
            this.failChance = failChance;
            this.ores = ores;
            this.chances = chances;
            this.recalculateChances();
        }

        public MineralMix addReplacement(String original, String replacement) {
            if (this.replacementOres == null) {
                this.replacementOres = new HashMap();
            }
            this.replacementOres.put(original, replacement);
            return this;
        }

        public void recalculateChances() {
            float chanceSum = 0.0f;
            ArrayList<String> existing = new ArrayList<String>();
            for (int i = 0; i < this.ores.length; ++i) {
                String ore = this.ores[i];
                if (this.replacementOres != null && OreDictionary.getOres((String)ore).size() <= 0 && this.replacementOres.containsKey(ore)) {
                    ore = this.replacementOres.get(ore);
                }
                if (ore == null || ore.isEmpty() || OreDictionary.getOres((String)ore).size() <= 0) continue;
                existing.add(ore);
                chanceSum += this.chances[i];
            }
            this.recalculatedOres = existing.toArray(new String[existing.size()]);
            this.recalculatedChances = new float[existing.size()];
            int j = 0;
            for (int i = 0; i < this.ores.length; ++i) {
                String ore = this.ores[i];
                if (this.replacementOres != null && OreDictionary.getOres((String)ore).size() <= 0 && this.replacementOres.containsKey(ore)) {
                    this.ores[i] = ore = this.replacementOres.get(ore);
                }
                if (ore == null || ore.isEmpty() || OreDictionary.getOres((String)ore).size() <= 0) continue;
                this.recalculatedChances[j++] = this.chances[i] / chanceSum;
            }
        }

        public String getRandomOre(Random rand) {
            float r = rand.nextFloat();
            for (int i = 0; i < this.chances.length; ++i) {
                if (!((r -= this.chances[i]) < 0.0f)) continue;
                return this.ores[i];
            }
            return "";
        }
    }
}

