/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.GregTechHelper;
import blusunrize.immersiveengineering.common.util.compat.IC2Helper;
import blusunrize.immersiveengineering.common.util.compat.ModCompatability;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySink;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2")
public class TileEntityConnectorLV
extends TileEntityImmersiveConnectable
implements IEnergyHandler,
IEnergySink {
    boolean inICNet = false;
    public int facing = 0;

    public void func_145845_h() {
        if (Lib.IC2 && !this.inICNet && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            IC2Helper.loadIC2Tile(this);
            this.inICNet = true;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.unload();
    }

    void unload() {
        if (Lib.IC2 && this.inICNet) {
            IC2Helper.unloadIC2Tile(this);
            this.inICNet = false;
        }
    }

    public void onChunkUnload() {
        this.unload();
    }

    public boolean canUpdate() {
        return Lib.IC2;
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
        return tile != null && (tile instanceof IEnergyReceiver || Lib.IC2 && IC2Helper.isEnergySink(tile) || Lib.GREG && GregTechHelper.gregtech_isEnergyConnected(tile));
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
        TileEntity capacitor = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
        if (capacitor instanceof IEnergyReceiver && ((IEnergyReceiver)capacitor).canConnectEnergy(fd.getOpposite())) {
            return ((IEnergyReceiver)capacitor).receiveEnergy(fd.getOpposite(), amount, simulate);
        }
        if (Lib.IC2 && IC2Helper.isAcceptingEnergySink(capacitor, this, fd.getOpposite())) {
            double left = IC2Helper.injectEnergy(capacitor, fd.getOpposite(), ModCompatability.convertRFtoEU(amount, this.getIC2Tier()), this.canTakeHV() ? 65536.0 : (this.canTakeMV() ? 16384.0 : 1024.0), simulate);
            return amount - ModCompatability.convertEUtoRF(left);
        }
        if (Lib.GREG && GregTechHelper.gregtech_isEnergyConnected(capacitor)) {
            if (simulate) {
                long accepted = GregTechHelper.gregtech_outputGTPower(capacitor, (byte)fd.getOpposite().ordinal(), (long)ModCompatability.convertRFtoEU(amount, this.getIC2Tier()), 1L);
                GregTechHelper.gregtech_outputGTPower(capacitor, (byte)fd.getOpposite().ordinal(), -accepted, 1L);
                return (int)accepted;
            }
            return (int)GregTechHelper.gregtech_outputGTPower(capacitor, (byte)fd.getOpposite().ordinal(), (long)ModCompatability.convertRFtoEU(amount, this.getIC2Tier()), 1L);
        }
        return 0;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
    }

    @Override
    public Vec3 getRaytraceOffset() {
        return Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5);
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return Vec3.func_72443_a((double)(0.5 - conRadius * (double)fd.offsetX), (double)(0.5 - conRadius * (double)fd.offsetY), (double)(0.5 - conRadius * (double)fd.offsetZ));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (Config.getBoolean("increasedRenderboxes")) {
            int inc = this.getRenderRadiusIncrease();
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - inc), (double)(this.field_145848_d - inc), (double)(this.field_145849_e - inc), (double)(this.field_145851_c + inc + 1), (double)(this.field_145848_d + inc + 1), (double)(this.field_145849_e + inc + 1));
        }
        return super.getRenderBoundingBox();
    }

    int getRenderRadiusIncrease() {
        return WireType.COPPER.getMaxLength();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from.ordinal() == this.facing;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.transferEnergy(maxReceive, simulate, 0);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int transferEnergy(int energy, boolean simulate, int energyType) {
        int received = 0;
        if (!this.field_145850_b.field_72995_K) {
            List<ImmersiveNetHandler.AbstractConnection> outputs = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC(this), this.field_145850_b);
            int powerLeft = Math.min(Math.min(this.getMaxOutput(), this.getMaxInput()), energy);
            if (outputs.size() < 1) {
                return 0;
            }
            int output = powerLeft / outputs.size();
            for (ImmersiveNetHandler.AbstractConnection con : outputs) {
                int tempR;
                if (con == null || con.cableType == null || Utils.toIIC(con.end, this.field_145850_b) == null) continue;
                int r = tempR = Utils.toIIC(con.end, this.field_145850_b).outputEnergy(Math.min(output, con.cableType.getTransferRate()), true, energyType);
                tempR -= (int)Math.max(0.0, Math.floor((float)tempR * con.getAverageLossRate()));
                Utils.toIIC(con.end, this.field_145850_b).outputEnergy(tempR, simulate, energyType);
                received += r;
                if ((powerLeft -= r) > 0) continue;
                break;
            }
        }
        return received;
    }

    public int getMaxInput() {
        return WireType.COPPER.getTransferRate();
    }

    public int getMaxOutput() {
        return WireType.COPPER.getTransferRate();
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return Lib.IC2 && this.canConnectEnergy(direction);
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return this.getMaxInput() / 4;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return this.getIC2Tier();
    }

    int getIC2Tier() {
        return this.canTakeHV() ? 3 : (this.canTakeMV() ? 2 : 1);
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        int r = this.transferEnergy(ModCompatability.convertEUtoRF(amount), false, 1);
        double left = amount - (double)((float)r / 4.0f);
        return left;
    }
}

