/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySampleDrill
extends TileEntityIEBase
implements IEnergyReceiver {
    public EnergyStorage energyStorage = new EnergyStorage(8000);
    public int pos = 0;
    public int process = 0;

    public static boolean _Immovable() {
        return true;
    }

    public void func_145845_h() {
        if (this.pos != 0 || this.field_145850_b.field_72995_K || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            return;
        }
        if (this.process < Config.getInt("coredrill_time") && this.energyStorage.extractEnergy(Config.getInt("coredrill_consumption"), false) == Config.getInt("coredrill_consumption")) {
            ++this.process;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public float getSampleProgress() {
        return (float)this.process / (float)Config.getInt("coredrill_time");
    }

    public boolean isSamplingFinished() {
        return this.process >= Config.getInt("coredrill_time");
    }

    public String getVein() {
        ExcavatorHandler.MineralMix mineral = ExcavatorHandler.getRandomMineral(this.field_145850_b, this.field_145851_c >> 4, this.field_145849_e >> 4);
        return mineral == null ? null : mineral.name;
    }

    public float getVeinIntegrity() {
        if (ExcavatorHandler.mineralVeinCapacity < 0) {
            return 1.0f;
        }
        if (ExcavatorHandler.getRandomMineral(this.field_145850_b, this.field_145851_c >> 4, this.field_145849_e >> 4) == null) {
            return 0.0f;
        }
        int dep = ExcavatorHandler.mineralDepletion.get((Object)new DimensionChunkCoords(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c >> 4, this.field_145849_e >> 4));
        return (float)(Config.getInt("excavator_depletion") - dep) / (float)Config.getInt("excavator_depletion");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("pos", this.pos);
        nbt.func_74768_a("process", this.process);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.pos = nbt.func_74762_e("pos");
        this.process = nbt.func_74762_e("process");
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.pos == 0) {
            return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.pos == 0;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntity te;
        if (this.pos != 0 && (te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - this.pos, this.field_145849_e)) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).receiveEnergy(from, maxReceive, simulate);
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntity te;
        if (this.pos != 0 && (te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - this.pos, this.field_145849_e)) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).getEnergyStored(from);
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntity te;
        if (this.pos != 0 && (te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - this.pos, this.field_145849_e)) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).getMaxEnergyStored(from);
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

