/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySkylineHook
extends Entity {
    ImmersiveNetHandler.Connection connection;
    ChunkCoordinates target;
    Vec3[] subPoints;
    int targetPoint = 0;

    public EntitySkylineHook(World world) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
        this.field_70145_X = true;
    }

    public EntitySkylineHook(World world, double x, double y, double z, ImmersiveNetHandler.Connection connection, ChunkCoordinates target, Vec3[] subPoints) {
        super(world);
        this.field_70145_X = true;
        this.func_70105_a(0.125f, 0.125f);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        this.connection = connection;
        this.target = target;
        this.subPoints = subPoints;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
        this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.field_70121_D.func_72320_b() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa == 1 && !this.field_70170_p.field_72995_K) {
            IELogger.debug("init tick at " + System.currentTimeMillis());
        }
        super.func_70071_h_();
        EntityPlayer player = null;
        if (this.field_70153_n instanceof EntityPlayer) {
            player = (EntityPlayer)this.field_70153_n;
        }
        if (this.subPoints != null && this.targetPoint < this.subPoints.length - 1) {
            double dist = this.subPoints[this.targetPoint].func_72438_d(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v));
            IELogger.debug("dist: " + dist);
            if (dist <= 0.05) {
                this.field_70165_t = this.subPoints[this.targetPoint].field_72450_a;
                this.field_70163_u = this.subPoints[this.targetPoint].field_72448_b;
                this.field_70161_v = this.subPoints[this.targetPoint].field_72449_c;
                ++this.targetPoint;
                IELogger.debug("next vertex: " + this.targetPoint);
                float speed = 2.0f;
                if (player != null && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemSkyhook) {
                    speed = ((ItemSkyhook)player.func_71045_bC().func_77973_b()).getSkylineSpeed(player.func_71045_bC());
                }
                Vec3 moveVec = SkylineHelper.getSubMovementVector(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), this.subPoints[this.targetPoint], speed);
                this.field_70159_w = moveVec.field_72450_a;
                this.field_70181_x = moveVec.field_72448_b;
                this.field_70179_y = moveVec.field_72449_c;
                return;
            }
        }
        if (this.target != null && this.targetPoint == this.subPoints.length - 1) {
            TileEntity end = this.field_70170_p.func_147438_o(this.target.field_71574_a, this.target.field_71572_b, this.target.field_71573_c);
            IImmersiveConnectable iicEnd = Utils.toIIC(end, this.field_70170_p);
            if (iicEnd == null) {
                this.func_70106_y();
                return;
            }
            Vec3 vEnd = Vec3.func_72443_a((double)this.target.field_71574_a, (double)this.target.field_71572_b, (double)this.target.field_71573_c);
            vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(this.connection));
            double gDist = vEnd.func_72438_d(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v));
            IELogger.debug("distance to goal: " + gDist);
            if (gDist <= 0.3) {
                this.reachedTarget(end);
                return;
            }
            if (gDist > 5.0) {
                this.func_70106_y();
                return;
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
        this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void reachedTarget(TileEntity end) {
        this.func_70106_y();
        IELogger.debug("last tick at " + System.currentTimeMillis());
        if (!(this.field_70153_n instanceof EntityPlayer)) {
            return;
        }
        ItemStack hook = ((EntityPlayer)this.field_70153_n).func_71045_bC();
        if (hook == null || !(hook.func_77973_b() instanceof ItemSkyhook)) {
            return;
        }
        ImmersiveNetHandler.Connection line = SkylineHelper.getTargetConnection(this.field_70170_p, this.target.field_71574_a, this.target.field_71572_b, this.target.field_71573_c, (EntityLivingBase)this.field_70153_n, this.connection);
        if (line != null) {
            ((EntityPlayer)this.field_70153_n).func_71008_a(hook, hook.func_77973_b().func_77626_a(hook));
            SkylineHelper.spawnHook((EntityPlayer)this.field_70153_n, end, line);
        } else {
            ((EntityPlayer)this.field_70153_n).field_70159_w = this.field_70159_w;
            ((EntityPlayer)this.field_70153_n).field_70181_x = this.field_70181_x;
            ((EntityPlayer)this.field_70153_n).field_70179_y = this.field_70179_y;
            IELogger.debug("player motion: " + ((EntityPlayer)this.field_70153_n).field_70159_w + "," + ((EntityPlayer)this.field_70153_n).field_70181_x + "," + ((EntityPlayer)this.field_70153_n).field_70179_y);
        }
    }

    public Vec3 func_70040_Z() {
        float f1 = MathHelper.func_76134_b((float)(-this.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-this.field_70125_A * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-this.field_70125_A * ((float)Math.PI / 180)));
        return Vec3.func_72443_a((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_82150_aj() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public double func_70042_X() {
        return -2.0;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        this.func_70106_y();
        return true;
    }
}

