/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.tool.IBullet;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.ContainerModWorkbench;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;

public abstract class IESlot
extends Slot {
    final Container container;

    public IESlot(Container container, IInventory inv, int id, int x, int y) {
        super(inv, id, x, y);
        this.container = container;
    }

    public boolean func_75214_a(ItemStack itemStack) {
        return true;
    }

    public static class ArcElectrode
    extends IESlot {
        public ArcElectrode(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && ((Object)((Object)IEContent.itemGraphiteElectrode)).equals(itemStack.func_77973_b());
        }
    }

    public static class ArcAdditive
    extends IESlot {
        public ArcAdditive(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && ArcFurnaceRecipe.isValidAdditive(itemStack);
        }
    }

    public static class ArcInput
    extends IESlot {
        public ArcInput(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && ArcFurnaceRecipe.isValidInput(itemStack);
        }
    }

    public static class BlueprintOutput
    extends IESlot {
        public BlueprintCraftingRecipe recipe;
        ItemStack upgradeableTool;

        public BlueprintOutput(Container container, IInventory inv, int id, int x, int y, ItemStack upgradeableTool, BlueprintCraftingRecipe recipe) {
            super(container, inv, id, x, y);
            this.upgradeableTool = upgradeableTool;
            this.recipe = recipe;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return this.func_75216_d();
        }

        public void func_82870_a(EntityPlayer player, ItemStack stack) {
            this.field_75224_c.func_70296_d();
            if (this.upgradeableTool != null && this.upgradeableTool.func_77973_b() instanceof ItemEngineersBlueprint) {
                ((ItemEngineersBlueprint)this.upgradeableTool.func_77973_b()).reduceInputs(this.recipe, this.upgradeableTool, stack);
            }
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
            }
            super.func_82870_a(player, stack);
        }
    }

    public static class BlueprintInput
    extends IESlot {
        ItemStack upgradeableTool;

        public BlueprintInput(Container container, IInventory inv, int id, int x, int y, ItemStack upgradeableTool) {
            super(container, inv, id, x, y);
            this.upgradeableTool = upgradeableTool;
        }

        public void func_75218_e() {
            this.field_75224_c.func_70296_d();
            if (this.upgradeableTool != null && this.upgradeableTool.func_77973_b() instanceof ItemEngineersBlueprint) {
                ((ItemEngineersBlueprint)this.upgradeableTool.func_77973_b()).updateOutputs(this.upgradeableTool);
            }
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
            }
            super.func_75218_e();
        }

        public int func_75219_a() {
            return 64;
        }
    }

    public static class Ghost
    extends IESlot {
        public Ghost(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public void func_75215_d(ItemStack itemStack) {
            super.func_75215_d(itemStack);
        }

        public boolean func_82869_a(EntityPlayer player) {
            return false;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public static class UpgradeableItem
    extends IESlot {
        int size;

        public UpgradeableItem(Container container, IInventory inv, int id, int x, int y, int size) {
            super(container, inv, id, x, y);
            this.size = size;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof ItemUpgradeableTool && ((ItemUpgradeableTool)itemStack.func_77973_b()).canModify(itemStack);
        }

        public int func_75219_a() {
            return this.size;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
            }
        }

        public boolean func_82869_a(EntityPlayer player) {
            return this.func_75211_c() == null || !(this.func_75211_c().func_77973_b() instanceof ItemUpgradeableTool) || ((ItemUpgradeableTool)this.func_75211_c().func_77973_b()).canTakeFromWorkbench(this.func_75211_c());
        }
    }

    public static class Upgrades
    extends IESlot {
        ItemStack upgradeableTool;
        IUpgrade.UpgradeType type;
        boolean preventDoubles;

        public Upgrades(Container container, IInventory inv, int id, int x, int y, IUpgrade.UpgradeType type, ItemStack upgradeableTool, boolean preventDoubles) {
            super(container, inv, id, x, y);
            this.type = type;
            this.upgradeableTool = upgradeableTool;
            this.preventDoubles = preventDoubles;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (this.preventDoubles) {
                for (Slot slot : this.container.field_75151_b) {
                    if (!(slot instanceof Upgrades) || !((Upgrades)slot).preventDoubles || !OreDictionary.itemMatches((ItemStack)slot.func_75211_c(), (ItemStack)itemStack, (boolean)true)) continue;
                    return false;
                }
            }
            return itemStack != null && itemStack.func_77973_b() instanceof IUpgrade && ((IUpgrade)itemStack.func_77973_b()).getUpgradeTypes(itemStack).contains((Object)this.type) && ((IUpgrade)itemStack.func_77973_b()).canApplyUpgrades(this.upgradeableTool, itemStack);
        }

        public int func_75219_a() {
            return 64;
        }
    }

    public static class DrillHead
    extends IESlot {
        public DrillHead(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof IDrillHead;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public static class Bullet
    extends IESlot {
        int limit;

        public Bullet(Container container, IInventory inv, int id, int x, int y, int limit) {
            super(container, inv, id, x, y);
            this.limit = limit;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof IBullet;
        }

        public int func_75219_a() {
            return this.limit;
        }
    }

    public static class BlastFuel
    extends IESlot {
        public BlastFuel(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return BlastFurnaceRecipe.isValidBlastFuel(itemStack);
        }
    }

    public static class FluidContainer
    extends IESlot {
        boolean empty;

        public FluidContainer(Container container, IInventory inv, int id, int x, int y, boolean empty) {
            super(container, inv, id, x, y);
            this.empty = empty;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (this.empty) {
                return FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack);
            }
            return FluidContainerRegistry.isFilledContainer((ItemStack)itemStack);
        }
    }

    public static class Output
    extends IESlot {
        public Output(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }
    }
}

