/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.minetweaker;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.util.compat.minetweaker.MTHelper;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.CokeOven")
public class CokeOven {
    @ZenMethod
    public static void addRecipe(IItemStack output, int fuelOutput, IIngredient input, int time) {
        Object oInput = MTHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        CokeOvenRecipe r = new CokeOvenRecipe(MTHelper.toStack(output), oInput, time, fuelOutput);
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<CokeOvenRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = CokeOvenRecipe.removeRecipes(this.output);
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (CokeOvenRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    CokeOvenRecipe.recipeList.add(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Coke Oven Recipe for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Coke Oven Recipe for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final CokeOvenRecipe recipe;

        public Add(CokeOvenRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            CokeOvenRecipe.recipeList.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            CokeOvenRecipe.recipeList.remove(this.recipe);
        }

        public String describe() {
            return "Adding Coke Oven Recipe for " + this.recipe.output.func_82833_r();
        }

        public String describeUndo() {
            return "Removing Coke Oven Recipe for " + this.recipe.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

