/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import com.google.common.collect.ArrayListMultimap;
import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.flowers.Flower;
import forestry.apiculture.flowers.VanillaDefaultGrowthRule;
import forestry.apiculture.flowers.VanillaDirtGrassGrowthRule;
import forestry.apiculture.flowers.VanillaFertilizeGrowthRule;
import forestry.apiculture.flowers.VanillaFlowerPotGrowthRule;
import forestry.apiculture.flowers.VanillaMyceliumGrowthRule;
import forestry.apiculture.flowers.VanillaSnowGrowthRule;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class FlowerRegistry
implements IFlowerRegistry {
    private final ArrayListMultimap<String, IFlower> registeredFlowers = ArrayListMultimap.create();
    private final ArrayListMultimap<String, IFlowerGrowthRule> growthRules = ArrayListMultimap.create();
    private final Map<String, TreeMap<Double, IFlower>> chances = new HashMap<String, TreeMap<Double, IFlower>>();
    private boolean hasDeprecatedFlowersImported = false;

    public FlowerRegistry() {
        this.registerVanillaFlowers();
        this.registerVanillaGrowthRules();
    }

    @Override
    public void registerAcceptableFlower(Block block, String ... flowerTypes) {
        this.registerFlower(block, Short.MAX_VALUE, 0.0, flowerTypes);
    }

    @Override
    public void registerAcceptableFlower(Block block, int meta, String ... flowerTypes) {
        this.registerFlower(block, meta, 0.0, flowerTypes);
    }

    @Override
    public void registerPlantableFlower(Block block, int meta, double weight, String ... flowerTypes) {
        this.registerFlower(block, meta, weight, flowerTypes);
    }

    private void registerFlower(Block block, int meta, double weight, String ... flowerTypes) {
        if (block == null) {
            return;
        }
        if (weight <= 0.0) {
            weight = 0.0;
        }
        if (weight >= 1.0) {
            weight = 1.0;
        }
        Flower newFlower = new Flower(block, meta, weight);
        for (String flowerType : flowerTypes) {
            List flowers = this.registeredFlowers.get((Object)flowerType);
            Integer index = flowers.indexOf(newFlower);
            if (index == -1) {
                flowers.add(newFlower);
            } else if (((IFlower)flowers.get(index)).getMeta() != newFlower.getMeta()) {
                flowers.add(newFlower);
            } else if (((IFlower)flowers.get(index)).getWeight() < newFlower.getWeight() && ((IFlower)flowers.get(index)).getMeta() == newFlower.getMeta()) {
                ((IFlower)flowers.get(index)).setWeight(newFlower.getWeight());
            }
            if (this.chances.containsKey(flowerType)) {
                this.chances.remove(flowerType);
            }
            Collections.sort(this.registeredFlowers.get((Object)flowerType));
        }
    }

    @Override
    public boolean isAcceptedFlower(String flowerType, World world, IIndividual individual, int x, int y, int z) {
        int meta;
        this.internalInitialize();
        if (!this.registeredFlowers.containsKey((Object)flowerType)) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z) || block.equals(Blocks.field_150357_h) || block.equals(Blocks.field_150346_d) || block.equals(Blocks.field_150349_c)) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFlowerPot) {
            TileEntityFlowerPot tileFlowerPot = (TileEntityFlowerPot)tile;
            Item item = tileFlowerPot.func_145965_a();
            block = Block.func_149634_a((Item)item);
            meta = tileFlowerPot.func_145966_b();
        } else {
            meta = world.func_72805_g(x, y, z);
        }
        Flower flower = new Flower(block, meta, 0.0);
        List acceptedFlowers = this.registeredFlowers.get((Object)flowerType);
        return acceptedFlowers.contains(flower);
    }

    @Override
    public boolean growFlower(String flowerType, World world, IIndividual individual, int x, int y, int z) {
        this.internalInitialize();
        if (!this.growthRules.containsKey((Object)flowerType)) {
            return false;
        }
        for (IFlowerGrowthRule rule : this.growthRules.get((Object)flowerType)) {
            if (!rule.growFlower(this, flowerType, world, individual, x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IFlower> getAcceptableFlowers(String flowerType) {
        this.internalInitialize();
        return this.registeredFlowers.get((Object)flowerType);
    }

    @Override
    public void registerGrowthRule(IFlowerGrowthRule rule, String ... flowerTypes) {
        if (rule == null) {
            return;
        }
        for (String flowerType : flowerTypes) {
            this.growthRules.get((Object)flowerType).add(rule);
        }
    }

    @Override
    public IFlower getRandomPlantableFlower(String flowerType, Random rand) {
        TreeMap<Double, IFlower> chancesMap = this.getChancesMap(flowerType);
        double maxKey = chancesMap.lastKey() + 1.0;
        return chancesMap.get(chancesMap.lowerKey(rand.nextDouble() * maxKey));
    }

    private TreeMap<Double, IFlower> getChancesMap(String flowerType) {
        if (!this.chances.containsKey(flowerType)) {
            TreeMap<Double, IFlower> flowerChances = new TreeMap<Double, IFlower>();
            double count = 0.0;
            for (IFlower flower : this.registeredFlowers.get((Object)flowerType)) {
                if (!flower.isPlantable()) continue;
                flowerChances.put(count, flower);
                count += flower.getWeight();
            }
            this.chances.put(flowerType, flowerChances);
        }
        return this.chances.get(flowerType);
    }

    private void internalInitialize() {
        if (!this.hasDeprecatedFlowersImported) {
            for (ItemStack plainFlower : FlowerManager.plainFlowers) {
                Block flowerBlock = Block.func_149634_a((Item)plainFlower.func_77973_b());
                int meta = plainFlower.func_77960_j();
                this.registerPlantableFlower(flowerBlock, meta, 1.0, "flowersVanilla", "flowersSnow");
            }
            this.hasDeprecatedFlowersImported = true;
        }
    }

    private void registerVanillaFlowers() {
        this.registerAcceptableFlower((Block)Blocks.field_150328_O, "flowersVanilla", "flowersSnow");
        this.registerAcceptableFlower((Block)Blocks.field_150327_N, "flowersVanilla", "flowersSnow");
        this.registerAcceptableFlower((Block)Blocks.field_150338_P, "flowersMushrooms");
        this.registerAcceptableFlower((Block)Blocks.field_150337_Q, "flowersMushrooms");
        this.registerAcceptableFlower(Blocks.field_150434_aF, "flowersCacti");
        this.registerAcceptableFlower(Blocks.field_150380_bt, "flowersEnd");
        this.registerAcceptableFlower(Blocks.field_150395_bd, "flowersJungle");
        this.registerAcceptableFlower((Block)Blocks.field_150329_H, "flowersJungle");
        this.registerAcceptableFlower(Blocks.field_150464_aj, "flowersWheat");
        this.registerAcceptableFlower(Blocks.field_150393_bb, "flowersGourd");
        this.registerAcceptableFlower(Blocks.field_150394_bc, "flowersGourd");
        this.registerAcceptableFlower(Blocks.field_150388_bm, "flowersNether");
        this.registerAcceptableFlower((Block)Blocks.field_150398_cm, 0, "flowersVanilla", "flowersSnow");
        this.registerAcceptableFlower((Block)Blocks.field_150398_cm, 1, "flowersVanilla", "flowersSnow");
        this.registerAcceptableFlower((Block)Blocks.field_150398_cm, 4, "flowersVanilla", "flowersSnow");
        this.registerAcceptableFlower((Block)Blocks.field_150398_cm, 5, "flowersVanilla", "flowersSnow");
        for (int meta = 0; meta <= 8; ++meta) {
            this.registerPlantableFlower((Block)Blocks.field_150328_O, meta, 1.0, "flowersVanilla", "flowersSnow");
        }
        this.registerPlantableFlower((Block)Blocks.field_150327_N, 0, 1.0, "flowersVanilla", "flowersSnow");
        this.registerPlantableFlower((Block)Blocks.field_150338_P, 0, 1.0, "flowersMushrooms");
        this.registerPlantableFlower((Block)Blocks.field_150337_Q, 0, 1.0, "flowersMushrooms");
        this.registerPlantableFlower(Blocks.field_150434_aF, 0, 1.0, "flowersCacti");
    }

    private void registerVanillaGrowthRules() {
        this.registerGrowthRule(new VanillaDirtGrassGrowthRule(), "flowersVanilla", "flowersSnow");
        this.registerGrowthRule(new VanillaSnowGrowthRule(), "flowersSnow");
        this.registerGrowthRule(new VanillaFlowerPotGrowthRule(), "flowersVanilla", "flowersSnow", "flowersMushrooms", "flowersCacti", "flowersJungle");
        this.registerGrowthRule(new VanillaMyceliumGrowthRule(), "flowersMushrooms");
        this.registerGrowthRule(new VanillaDefaultGrowthRule(), "flowersEnd");
        this.registerGrowthRule(new VanillaFertilizeGrowthRule(Blocks.field_150394_bc, Blocks.field_150393_bb), "flowersGourd");
        this.registerGrowthRule(new VanillaFertilizeGrowthRule(Blocks.field_150464_aj), "flowersWheat");
    }
}

