/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IToolScoop;
import forestry.api.core.Tabs;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.items.ItemLeavesBlock;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginArboriculture;
import forestry.plugins.PluginLepidopterology;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ForestryBlockLeaves
extends BlockNewLeaf
implements ITileEntityProvider,
IGrowable {
    protected ThreadLocal<ArrayList<ItemStack>> drops = new ThreadLocal();
    @SideOnly(value=Side.CLIENT)
    private static IIcon defaultIcon;

    public ForestryBlockLeaves() {
        this.func_149647_a(Tabs.tabArboriculture);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileLeaves();
    }

    public static TileLeaves getLeafTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileLeaves) {
            return (TileLeaves)tile;
        }
        return null;
    }

    private static NBTTagCompound getTagCompoundForLeaves(IBlockAccess world, int x, int y, int z) {
        TileLeaves leaves = ForestryBlockLeaves.getLeafTile(world, x, y, z);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (leaves == null) {
            return nbttagcompound;
        }
        leaves.func_145841_b(nbttagcompound);
        return nbttagcompound;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (ITree tree : PluginArboriculture.treeInterface.getIndividualTemplates()) {
            TileLeaves leaves = new TileLeaves();
            leaves.setDecorative();
            leaves.setTree(tree);
            NBTTagCompound leavesNBT = new NBTTagCompound();
            leaves.func_145841_b(leavesNBT);
            ItemStack itemStack = new ItemStack(item, 1, 0);
            itemStack.func_77982_d(leavesNBT);
            list.add(itemStack);
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        ItemStack held;
        TileLeaves leafTile = ForestryBlockLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (leafTile == null || leafTile.isDecorative()) {
            return;
        }
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        float saplingModifier = 1.0f;
        if (Proxies.common.isSimulating(world) && player != null && (held = player.field_71071_by.func_70448_g()) != null && held.func_77973_b() instanceof IToolGrafter) {
            saplingModifier = ((IToolGrafter)held.func_77973_b()).getSaplingModifier(held, world, player, x, y, z);
            held.func_77972_a(1, (EntityLivingBase)player);
            if (held.field_77994_a <= 0) {
                player.func_71028_bD();
            }
        }
        this.drops.set(this.getLeafDrop(world, x, y, z, saplingModifier, fortune));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = this.drops.get();
        this.drops.remove();
        if (ret == null) {
            ret = this.getLeafDrop(world, x, y, z, 1.0f, fortune);
        }
        return ret;
    }

    private ArrayList<ItemStack> getLeafDrop(World world, int x, int y, int z, float saplingModifier, int fortune) {
        ITree[] saplings;
        ArrayList<ItemStack> prod = new ArrayList<ItemStack>();
        TileLeaves tile = ForestryBlockLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tile == null || tile.getTree() == null || tile.isDecorative()) {
            return prod;
        }
        for (ITree sapling : saplings = tile.getTree().getSaplings(world, x, y, z, saplingModifier)) {
            if (sapling == null) continue;
            prod.add(PluginArboriculture.treeInterface.getMemberStack(sapling, EnumGermlingType.SAPLING.ordinal()));
        }
        if (tile.hasFruit()) {
            Collections.addAll(prod, tile.getTree().produceStacks(world, x, y, z, tile.getRipeningTime()));
        }
        return prod;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = super.getPickBlock(target, world, x, y, z);
        NBTTagCompound leavesNBT = ForestryBlockLeaves.getTagCompoundForLeaves((IBlockAccess)world, x, y, z);
        itemStack.func_77982_d(leavesNBT);
        return itemStack;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList ret = super.onSheared(item, world, x, y, z, fortune);
        NBTTagCompound leavesNBT = ForestryBlockLeaves.getTagCompoundForLeaves(world, x, y, z);
        for (ItemStack stack : ret) {
            if (!(stack.func_77973_b() instanceof ItemLeavesBlock)) continue;
            NBTTagCompound leavesNBTCopy = (NBTTagCompound)leavesNBT.func_74737_b();
            stack.func_77982_d(leavesNBTCopy);
        }
        return ret;
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        TileLeaves tile = ForestryBlockLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tile == null || tile.isDecorative()) {
            return;
        }
        super.beginLeavesDecay(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TileLeaves tileLeaves = ForestryBlockLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tileLeaves == null || tileLeaves.isDecorative()) {
            return;
        }
        super.func_149674_a(world, x, y, z, random);
        if (tileLeaves.func_145837_r()) {
            return;
        }
        if ((double)world.field_73012_v.nextFloat() > 0.1) {
            return;
        }
        tileLeaves.onBlockTick();
    }

    public boolean func_149662_c() {
        return !Proxies.render.fancyGraphicsEnabled();
    }

    public int func_149645_b() {
        return PluginArboriculture.modelIdLeaves;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileLeaves leaves = ForestryBlockLeaves.getLeafTile(world, x, y, z);
        if (leaves == null) {
            return super.func_149720_d(world, x, y, z);
        }
        int colour = leaves.getFoliageColour((EntityPlayer)Proxies.common.getClientInstance().field_71439_g);
        if (colour == PluginArboriculture.proxy.getFoliageColorBasic()) {
            colour = super.func_149720_d(world, x, y, z);
        }
        return colour;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        defaultIcon = TextureManager.getInstance().registerTex(register, "leaves/deciduous.fancy");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return defaultIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileLeaves leaves = ForestryBlockLeaves.getLeafTile(world, x, y, z);
        if (leaves != null) {
            return leaves.getIcon(Proxies.render.fancyGraphicsEnabled());
        }
        return defaultIcon;
    }

    public String[] func_150125_e() {
        return new String[0];
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 60;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (face == ForgeDirection.DOWN) {
            return 20;
        }
        if (face != ForgeDirection.UP) {
            return 10;
        }
        return 5;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        IButterfly caterpillar;
        ItemStack heldItem = player.func_70694_bm();
        TileEntity tile = world.func_147438_o(x, y, z);
        IButterfly iButterfly = caterpillar = tile instanceof TileLeaves ? ((TileLeaves)tile).getCaterpillar() : null;
        if (heldItem != null && heldItem.func_77973_b() instanceof IToolScoop && caterpillar != null) {
            ItemStack butterfly = PluginLepidopterology.butterflyInterface.getMemberStack(caterpillar, EnumFlutterType.CATERPILLAR.ordinal());
            StackUtils.dropItemStackAsEntity(butterfly, world, x, y, z);
            ((TileLeaves)tile).setCaterpillar(null);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, par6, par7, par8, par9);
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        TileLeaves leafTile = ForestryBlockLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (leafTile != null) {
            return leafTile.hasFruit() && leafTile.getRipeness() < 1.0f;
        }
        return false;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        TileLeaves leafTile = ForestryBlockLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (leafTile != null) {
            leafTile.addRipeness(1.0f);
        }
    }
}

