/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenCrescentia
extends WorldGenTree {
    public WorldGenCrescentia(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 0.5f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 1.9f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 1.9f, 1, this.leaf);
        if (this.rand.nextBoolean()) {
            this.generateAdjustedCylinder(leafSpawn--, 1.9f, 1, this.leaf);
        }
        this.generateAdjustedCylinder(leafSpawn--, 0.5f, 1, this.leaf);
    }

    @Override
    public void generateTreeTrunk(int height, int girth) {
        int offset = (girth - 1) / 2;
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                if (x == 0 || x == girth - 1) {
                    if (z == 0 || z == girth - 1) {
                        if (x != 0 || z == 0) {
                            // empty if block
                        }
                        if (x != girth - 1 || z == 0) {
                            // empty if block
                        }
                        if (x != 0 || z == girth - 1) {
                            // empty if block
                        }
                        if (x != girth - 1 || z != 0) continue;
                        continue;
                    }
                    if (x == 0 || x != girth - 1) continue;
                    continue;
                }
                if (z == 0 || z == girth - 1) {
                    if (z == 0 || z != girth - 1) continue;
                    continue;
                }
                for (int i = 0; i < height; ++i) {
                    this.addWood(x - offset, i, z - offset, WorldGenBase.EnumReplaceMode.ALL);
                }
            }
        }
        for (int y = this.minPodHeight; y < height; ++y) {
            for (int x = 0; x < girth; ++x) {
                for (int z = 0; z < girth; ++z) {
                    if (x > 0 && x < girth && z > 0 && z < girth) continue;
                    this.tree.trySpawnFruitBlock(this.world, this.startX + x + 1, this.startY + y, this.startZ + z);
                    this.tree.trySpawnFruitBlock(this.world, this.startX + x - 1, this.startY + y, this.startZ + z);
                    this.tree.trySpawnFruitBlock(this.world, this.startX + x, this.startY + y, this.startZ + z + 1);
                    this.tree.trySpawnFruitBlock(this.world, this.startX + x, this.startY + y, this.startZ + z - 1);
                }
            }
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 3);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

