/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.triggers;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public abstract class Trigger
implements ITriggerExternal {
    private final String uid;
    private final String unlocalized;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;

    public Trigger(String uid) {
        this(uid, uid);
    }

    public Trigger(String uid, String localization) {
        this.uid = "forestry:" + uid;
        this.unlocalized = "trigger." + localization;
        StatementManager.registerStatement((IStatement)this);
    }

    public String getUniqueTag() {
        return this.uid;
    }

    public String getDescription() {
        return StringUtil.localize(this.unlocalized);
    }

    public IStatementParameter createParameter(int index) {
        return null;
    }

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icon = TextureManager.getInstance().registerTex(register, "triggers/" + this.unlocalized.replace("trigger.", ""));
    }

    public IStatement rotateLeft() {
        return this;
    }
}

