/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public enum EnumFarmBlock {
    BRICK_STONE(new ItemStack(Blocks.field_150417_aV, 1, 0)),
    BRICK_MOSSY(new ItemStack(Blocks.field_150417_aV, 1, 1)),
    BRICK_CRACKED(new ItemStack(Blocks.field_150417_aV, 1, 2)),
    BRICK(new ItemStack(Blocks.field_150336_V)),
    SANDSTONE_SMOOTH(new ItemStack(Blocks.field_150322_A, 1, 2)),
    SANDSTONE_CHISELED(new ItemStack(Blocks.field_150322_A, 1, 1)),
    BRICK_NETHER(new ItemStack(Blocks.field_150385_bj)),
    BRICK_CHISELED(new ItemStack(Blocks.field_150417_aV, 1, 3)),
    QUARTZ(new ItemStack(Blocks.field_150371_ca, 1, 0)),
    QUARTZ_CHISELED(new ItemStack(Blocks.field_150371_ca, 1, 1)),
    QUARTZ_LINES(new ItemStack(Blocks.field_150371_ca, 1, 2));

    @SideOnly(value=Side.CLIENT)
    private static List<IIcon> icons;
    private final ItemStack base;

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        TextureManager textureManager = TextureManager.getInstance();
        icons = Arrays.asList(textureManager.registerTex(register, "farm/plain"), textureManager.registerTex(register, "farm/reverse"), textureManager.registerTex(register, "farm/top"), textureManager.registerTex(register, "farm/band"), textureManager.registerTex(register, "farm/gears"), textureManager.registerTex(register, "farm/hatch"), textureManager.registerTex(register, "farm/valve"), textureManager.registerTex(register, "farm/control"));
    }

    private EnumFarmBlock(ItemStack base) {
        this.base = base;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int type) {
        return icons.get(type);
    }

    public void saveToCompound(NBTTagCompound compound) {
        compound.func_74768_a("FarmBlock", this.ordinal());
    }

    public String getName() {
        return this.base.func_77973_b().func_77653_i(this.base);
    }

    public ItemStack getBase() {
        return this.base;
    }

    public static EnumFarmBlock getFromCompound(NBTTagCompound compound) {
        int farmBlockOrdinal;
        if (compound != null && (farmBlockOrdinal = compound.func_74762_e("FarmBlock")) < EnumFarmBlock.values().length) {
            return EnumFarmBlock.values()[farmBlockOrdinal];
        }
        return BRICK_STONE;
    }
}

