/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import forestry.core.EnumErrorCode;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.ISocketable;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.proxy.Proxies;
import forestry.core.utils.DelayTimer;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.StackUtils;
import forestry.core.vect.Vect;
import forestry.core.vect.VectUtil;
import forestry.farming.FarmHelper;
import forestry.farming.FarmTarget;
import forestry.farming.gadgets.StructureLogicFarm;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.plugins.PluginFarming;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileFarmPlain
extends TileFarm
implements IFarmHousing,
ISocketable,
IClimatised,
IHintSource {
    public static final ForgeDirection[] CARDINAL_DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    public static final int SLOT_RESOURCES_1 = 0;
    public static final int SLOT_RESOURCES_COUNT = 6;
    public static final int SLOT_GERMLINGS_1 = 6;
    public static final int SLOT_GERMLINGS_COUNT = 6;
    public static final int SLOT_PRODUCTION_1 = 12;
    public static final int SLOT_PRODUCTION_COUNT = 8;
    public static final int SLOT_FERTILIZER = 20;
    public static final int SLOT_FERTILIZER_COUNT = 1;
    public static final int SLOT_CAN = 21;
    public static final int SLOT_CAN_COUNT = 1;
    public static final int SLOT_COUNT = 22;
    private static final int DELAY_HYDRATION = 100;
    private static final float RAINFALL_MODIFIER_CAP = 15.0f;
    private static final int BUFFER_FERTILIZER = 200;
    private IFarmLogic[] farmLogics = new IFarmLogic[4];
    private TreeMap<ForgeDirection, List<FarmTarget>> targets;
    private int allowedExtent = 0;
    private final DelayTimer checkTimer = new DelayTimer();
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private TankManager tankManager;
    private IFarmLogic harvestProvider;
    private final Stack<ICrop> pendingCrops = new Stack();
    private final Stack<ItemStack> pendingProduce = new Stack();
    private int storedFertilizer;
    private int fertilizerValue = 2000;
    private Stage stage = Stage.CULTIVATE;
    private BiomeGenBase biome;
    private int hydrationDelay = 0;
    private int ticksSinceRainfall = 0;
    private final Set<IFarmListener> eventHandlers = new LinkedHashSet<IFarmListener>();
    private int[] coords;
    private int[] offset;
    private int[] area;

    public static ForgeDirection getLayoutDirection(ForgeDirection farmSide) {
        switch (farmSide) {
            case NORTH: {
                return ForgeDirection.WEST;
            }
            case WEST: {
                return ForgeDirection.SOUTH;
            }
            case SOUTH: {
                return ForgeDirection.EAST;
            }
            case EAST: {
                return ForgeDirection.NORTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public TileFarmPlain() {
        this.fertilizerValue = GameMode.getGameMode().getIntegerSetting("farms.fertilizer.value");
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.setBiomeInformation();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.storedFertilizer = nbttagcompound.func_74762_e("StoredFertilizer");
        this.hydrationDelay = nbttagcompound.func_74762_e("HydrationDelay");
        this.ticksSinceRainfall = nbttagcompound.func_74762_e("TicksSinceRainfall");
        this.sockets.readFromNBT(nbttagcompound);
        this.refreshFarmLogics();
        if (this.tankManager != null) {
            this.tankManager.readTanksFromNBT(nbttagcompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.sockets.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("StoredFertilizer", this.storedFertilizer);
        nbttagcompound.func_74768_a("HydrationDelay", this.hydrationDelay);
        nbttagcompound.func_74768_a("TicksSinceRainfall", this.ticksSinceRainfall);
        if (this.tankManager != null) {
            this.tankManager.writeTanksToNBT(nbttagcompound);
        }
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (!this.isMaster()) {
            return;
        }
        if (this.field_145850_b.func_72896_J()) {
            if (this.hydrationDelay > 0) {
                --this.hydrationDelay;
            } else {
                this.ticksSinceRainfall = 0;
            }
        } else {
            this.hydrationDelay = 100;
            if (this.ticksSinceRainfall < Integer.MAX_VALUE) {
                ++this.ticksSinceRainfall;
            }
        }
        if (!this.updateOnInterval(20)) {
            return;
        }
        if (this.getInternalInventory().func_70301_a(21) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this.getInternalInventory(), 21);
        }
    }

    private void setBiomeInformation() {
        this.biome = this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e);
    }

    private static TreeMap<ForgeDirection, List<FarmTarget>> createTargets(World world, Vect targetStart, int allowedExtent, int farmSizeNorthSouth, int farmSizeEastWest) {
        TreeMap<ForgeDirection, List<FarmTarget>> targets = new TreeMap<ForgeDirection, List<FarmTarget>>();
        for (ForgeDirection farmSide : CARDINAL_DIRECTIONS) {
            int farmSize = farmSide == ForgeDirection.NORTH || farmSide == ForgeDirection.SOUTH ? farmSizeNorthSouth : farmSizeEastWest;
            int targetMaxLimit = allowedExtent + farmSize;
            ForgeDirection layoutDirection = TileFarmPlain.getLayoutDirection(farmSide);
            Vect targetLocation = FarmHelper.getFarmMultiblockCorner(world, targetStart, farmSide, layoutDirection.getOpposite());
            Vect firstLocation = targetLocation.add(farmSide);
            Vect firstGroundPosition = TileFarmPlain.getGroundPosition(world, firstLocation);
            if (firstGroundPosition == null) break;
            int groundHeight = firstGroundPosition.getY();
            ArrayList<FarmTarget> farmSideTargets = new ArrayList<FarmTarget>();
            for (int i = 0; i < allowedExtent; ++i) {
                targetLocation = targetLocation.add(farmSide);
                Vect groundLocation = new Vect(targetLocation.getX(), groundHeight, targetLocation.getZ());
                int targetLimit = targetMaxLimit;
                if (!Config.squareFarms) {
                    targetLimit = targetMaxLimit - i - 1;
                }
                Block platform = VectUtil.getBlock(world, groundLocation);
                Vect soilPosition = new Vect(groundLocation.x, groundLocation.y + 1, groundLocation.z);
                if (!StructureLogicFarm.bricks.contains((Object)platform)) break;
                FarmTarget target = new FarmTarget(targetLocation, layoutDirection, targetLimit);
                farmSideTargets.add(target);
            }
            targets.put(farmSide, farmSideTargets);
        }
        return targets;
    }

    private void setExtents() {
        for (List<FarmTarget> targetsList : this.targets.values()) {
            if (targetsList.isEmpty()) continue;
            Vect groundPosition = TileFarmPlain.getGroundPosition(this.field_145850_b, targetsList.get(0).getStart());
            for (FarmTarget target : targetsList) {
                target.setExtentAndYOffset(this.field_145850_b, groundPosition);
            }
        }
    }

    private static Vect getGroundPosition(World world, Vect targetPosition) {
        for (int yOffset = 2; yOffset > -4; --yOffset) {
            Vect position = targetPosition.add(0, yOffset, 0);
            Block ground = VectUtil.getBlock(world, position);
            if (!StructureLogicFarm.bricks.contains((Object)ground)) continue;
            return position;
        }
        return null;
    }

    protected void createInventory() {
        this.setInternalInventory(new FarmPlainInventoryAdapter(this));
        FilteredTank liquidTank = new FilteredTank(10000, FluidRegistry.WATER);
        this.tankManager = new TankManager(liquidTank);
    }

    @Override
    public boolean doWork() {
        if (this.targets == null || this.checkTimer.delayPassed(this.field_145850_b, 400L)) {
            Vect targetStart = new Vect(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int sizeNorthSouth = FarmHelper.getFarmSizeNorthSouth(this.field_145850_b, targetStart);
            int sizeEastWest = FarmHelper.getFarmSizeEastWest(this.field_145850_b, targetStart);
            this.allowedExtent = Math.max(sizeNorthSouth, sizeEastWest) * 3;
            this.targets = TileFarmPlain.createTargets(this.field_145850_b, targetStart, this.allowedExtent, sizeNorthSouth, sizeEastWest);
            this.setExtents();
        }
        if (this.tryAddPending()) {
            return true;
        }
        if (this.setErrorCondition(!this.pendingProduce.isEmpty(), EnumErrorCode.NOSPACE)) {
            return false;
        }
        if (this.storedFertilizer <= 200) {
            this.replenishFertilizer();
            if (this.setErrorCondition(this.storedFertilizer <= 0, EnumErrorCode.NOFERTILIZER)) {
                return false;
            }
        }
        if (!this.pendingCrops.isEmpty()) {
            if (this.cullCrop(this.pendingCrops.peek(), this.harvestProvider)) {
                this.pendingCrops.pop();
                return true;
            }
            return false;
        }
        FarmWorkStatus farmWorkStatus = new FarmWorkStatus();
        for (Map.Entry<ForgeDirection, List<FarmTarget>> entry : this.targets.entrySet()) {
            ForgeDirection farmSide = entry.getKey();
            IFarmLogic logic = this.getFarmLogic(farmSide);
            if (logic == null || this.isCycleCanceledByListeners(logic, farmSide)) continue;
            if (this.collectWindfall(logic)) {
                farmWorkStatus.didWork = true;
            } else {
                List<FarmTarget> farmTargets = entry.getValue();
                if (this.stage == Stage.HARVEST) {
                    farmWorkStatus.didWork = this.harvestTargets(farmTargets, logic);
                } else {
                    farmWorkStatus = this.cultivateTargets(farmWorkStatus, farmTargets, logic);
                }
            }
            if (!farmWorkStatus.didWork) continue;
            break;
        }
        if (!farmWorkStatus.didWork && this.stage == Stage.CULTIVATE) {
            this.setErrorCondition(!farmWorkStatus.hasFarmland, EnumErrorCode.NOFARMLAND);
            this.setErrorCondition(!farmWorkStatus.hasFertilizer, EnumErrorCode.NOFERTILIZER);
            this.setErrorCondition(!farmWorkStatus.hasLiquid, EnumErrorCode.NOLIQUID);
        }
        this.stage = this.stage.next();
        return farmWorkStatus.didWork;
    }

    private IFarmLogic getFarmLogic(ForgeDirection direction) {
        int logicOrdinal = direction.ordinal() - 2;
        if (this.farmLogics.length <= logicOrdinal) {
            return null;
        }
        return this.farmLogics[logicOrdinal];
    }

    private boolean isCycleCanceledByListeners(IFarmLogic logic, ForgeDirection direction) {
        for (IFarmListener listener : this.eventHandlers) {
            if (!listener.cancelTask(logic, direction)) continue;
            return true;
        }
        return false;
    }

    private FarmWorkStatus cultivateTargets(FarmWorkStatus farmWorkStatus, List<FarmTarget> farmTargets, IFarmLogic logic) {
        for (FarmTarget target : farmTargets) {
            if (target.getExtent() <= 0) break;
            farmWorkStatus.hasFarmland = true;
            if (!this.hasFertilizer(logic.getFertilizerConsumption())) continue;
            farmWorkStatus.hasFertilizer = true;
            int liquidAmount = logic.getWaterConsumption(this.getHydrationModifier());
            FluidStack liquid = Fluids.WATER.getFluid(liquidAmount);
            if (liquid.amount > 0 && !this.hasLiquid(liquid)) continue;
            farmWorkStatus.hasLiquid = true;
            if (!this.cultivateTarget(target, logic)) continue;
            this.removeFertilizer(logic.getFertilizerConsumption());
            this.removeLiquid(liquid);
            farmWorkStatus.didWork = true;
        }
        return farmWorkStatus;
    }

    private boolean cultivateTarget(FarmTarget target, IFarmLogic logic) {
        Vect targetPosition = target.getStart().add(0, target.getYOffset(), 0);
        if (logic.cultivate(targetPosition.x, targetPosition.y, targetPosition.z, target.getDirection(), target.getExtent())) {
            for (IFarmListener listener : this.eventHandlers) {
                listener.hasCultivated(logic, targetPosition.x, targetPosition.y, targetPosition.z, target.getDirection(), target.getExtent());
            }
            return true;
        }
        return false;
    }

    private boolean harvestTargets(List<FarmTarget> farmTargets, IFarmLogic logic) {
        for (FarmTarget target : farmTargets) {
            if (!this.harvestTarget(target, logic)) continue;
            return true;
        }
        return false;
    }

    private boolean harvestTarget(FarmTarget target, IFarmLogic logic) {
        Collection<ICrop> next = logic.harvest(target.getStart().x, target.getStart().y + target.getYOffset(), target.getStart().z, target.getDirection(), target.getExtent());
        if (next == null || next.size() <= 0) {
            return false;
        }
        for (IFarmListener listener : this.eventHandlers) {
            listener.hasScheduledHarvest(next, logic, target.getStart().x, target.getStart().y + target.getYOffset(), target.getStart().z, target.getDirection(), target.getExtent());
        }
        this.pendingCrops.addAll(next);
        this.harvestProvider = logic;
        return true;
    }

    private boolean collectWindfall(IFarmLogic logic) {
        Collection<ItemStack> collected = logic.collect();
        if (collected == null || collected.size() <= 0) {
            return false;
        }
        for (IFarmListener listener : this.eventHandlers) {
            listener.hasCollected(collected, logic);
        }
        for (ItemStack produce : collected) {
            this.addProduceToInventory(produce);
            this.pendingProduce.push(produce);
        }
        return true;
    }

    private void addProduceToInventory(ItemStack produce) {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (IFarmLogic logic : this.getFarmLogics()) {
            if (logic.isAcceptedGermling(produce)) {
                produce.field_77994_a -= InvTools.addStack((IInventory)inventory, produce, 6, 6, true);
            }
            if (produce.field_77994_a <= 0) {
                return;
            }
            if (logic.isAcceptedResource(produce)) {
                produce.field_77994_a -= InvTools.addStack((IInventory)inventory, produce, 0, 6, true);
            }
            if (produce.field_77994_a > 0) continue;
            return;
        }
        produce.field_77994_a -= InvTools.addStack((IInventory)inventory, produce, 12, 8, true);
    }

    private boolean cullCrop(ICrop crop, IFarmLogic provider) {
        for (IFarmListener listener : this.eventHandlers) {
            if (!listener.beforeCropHarvest(crop)) continue;
            return true;
        }
        Boolean hasFertilizer = this.hasFertilizer(provider.getFertilizerConsumption());
        if (this.setErrorCondition(hasFertilizer == false, EnumErrorCode.NOFERTILIZER)) {
            return false;
        }
        FluidStack requiredLiquid = Fluids.WATER.getFluid(provider.getWaterConsumption(this.getHydrationModifier()));
        boolean hasLiquid = requiredLiquid.amount == 0 || this.hasLiquid(requiredLiquid);
        if (this.setErrorCondition(!hasLiquid, EnumErrorCode.NOLIQUID)) {
            return false;
        }
        Collection<ItemStack> harvested = crop.harvest();
        if (harvested == null) {
            Proxies.log.fine("Failed to harvest crop: " + crop.toString());
            return true;
        }
        this.removeFertilizer(provider.getFertilizerConsumption());
        this.removeLiquid(requiredLiquid);
        for (IFarmListener listener : this.eventHandlers) {
            listener.afterCropHarvest(harvested, crop);
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        for (ItemStack harvest : harvested) {
            for (IFarmLogic logic : this.farmLogics) {
                if (!logic.isAcceptedGermling(harvest)) continue;
                harvest.field_77994_a -= InvTools.addStack((IInventory)inventory, harvest, 6, 6, true);
                break;
            }
            if (harvest.field_77994_a <= 0) continue;
            harvest.field_77994_a -= InvTools.addStack((IInventory)inventory, harvest, 12, 8, true);
            if (harvest.field_77994_a <= 0) continue;
            this.pendingProduce.push(harvest);
        }
        return true;
    }

    private boolean tryAddPending() {
        if (this.pendingProduce.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProduce.peek();
        boolean added = InvTools.tryAddStack((IInventory)this.getInternalInventory(), next, 12, 8, true, true);
        if (added) {
            this.pendingProduce.pop();
        }
        this.setErrorCondition(!added, EnumErrorCode.NOSPACE);
        return added;
    }

    private void replenishFertilizer() {
        if (this.fertilizerValue < 0) {
            this.storedFertilizer += 2000;
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack fertilizer = inventory.func_70301_a(20);
        if (fertilizer == null || fertilizer.field_77994_a <= 0) {
            return;
        }
        if (!this.acceptsAsFertilizer(fertilizer)) {
            return;
        }
        inventory.func_70298_a(20, 1);
        this.storedFertilizer += this.fertilizerValue;
    }

    private boolean hasFertilizer(int amount) {
        if (this.fertilizerValue < 0) {
            return true;
        }
        return this.storedFertilizer >= amount;
    }

    private void removeFertilizer(int amount) {
        if (this.fertilizerValue < 0) {
            return;
        }
        this.storedFertilizer -= amount;
        if (this.storedFertilizer < 0) {
            this.storedFertilizer = 0;
        }
    }

    public int getStoredFertilizerScaled(int scale) {
        if (this.storedFertilizer == 0) {
            return 0;
        }
        return this.storedFertilizer * scale / (this.fertilizerValue + 200);
    }

    @Override
    public void makeMaster() {
        super.makeMaster();
        this.refreshFarmLogics();
        this.createInventory();
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void setFarmLogic(ForgeDirection direction, IFarmLogic logic) {
        this.farmLogics[direction.ordinal() - 2] = logic;
    }

    @Override
    public void resetFarmLogic(ForgeDirection direction) {
        this.setFarmLogic(direction, new FarmLogicArboreal(this));
    }

    public IFarmLogic[] getFarmLogics() {
        return this.farmLogics;
    }

    private void refreshFarmLogics() {
        ICircuitBoard chipset;
        this.farmLogics = new IFarmLogic[]{new FarmLogicArboreal(this), new FarmLogicArboreal(this), new FarmLogicArboreal(this), new FarmLogicArboreal(this)};
        ItemStack chip = this.sockets.func_70301_a(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.func_70301_a(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.func_70301_a(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.func_70299_a(slot, stack);
        this.refreshFarmLogics();
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public boolean hasResources(ItemStack[] resources) {
        return InvTools.contains((IInventory)this.getInternalInventory(), resources, 0, 6);
    }

    public boolean hasResourcesAmount(int amount) {
        return InvTools.containsAmount((IInventory)this.getInternalInventory(), amount, 0, 6);
    }

    public boolean hasGermlingsPercent(float percent) {
        return InvTools.containsPercent((IInventory)this.getInternalInventory(), percent, 6, 6);
    }

    public boolean hasFertilizerPercent(float percent) {
        return InvTools.containsPercent((IInventory)this.getInternalInventory(), percent, 20, 1);
    }

    @Override
    public void removeResources(ItemStack[] resources) {
        EntityPlayer player = Proxies.common.getPlayer(this.field_145850_b, this.getOwner());
        InvTools.removeSets((IInventory)this.getInternalInventory(), 1, resources, 0, 6, player, false, true, true);
    }

    @Override
    public boolean hasLiquid(FluidStack liquid) {
        return this.tankManager.get(0).getFluidAmount() >= liquid.amount;
    }

    @Override
    public void removeLiquid(FluidStack liquid) {
        this.tankManager.drain(liquid, true);
    }

    public boolean hasGermlings(ItemStack[] germlings) {
        return InvTools.contains((IInventory)this.getInternalInventory(), germlings, 6, 6);
    }

    @Override
    public boolean plantGermling(IFarmable germling, World world, int x, int y, int z) {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 6; i < 12; ++i) {
            EntityPlayer player;
            if (inventory.func_70301_a(i) == null || !germling.isGermling(inventory.func_70301_a(i)) || !germling.plantSaplingAt(player = Proxies.common.getPlayer(world, this.getOwner()), inventory.func_70301_a(i), world, x, y, z)) continue;
            inventory.func_70298_a(i, 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFunction() {
        return false;
    }

    @Override
    public void registerListener(IFarmListener listener) {
        this.eventHandlers.add(listener);
    }

    @Override
    public void removeListener(IFarmListener listener) {
        this.eventHandlers.remove(listener);
    }

    @Override
    public boolean acceptsAsGermling(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (this.farmLogics == null) {
            return false;
        }
        for (IFarmLogic logic : this.farmLogics) {
            if (!logic.isAcceptedGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAsResource(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (this.farmLogics == null) {
            return false;
        }
        for (IFarmLogic logic : this.farmLogics) {
            if (!logic.isAcceptedResource(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAsFertilizer(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return StackUtils.isIdenticalItem(PluginFarming.farmFertilizer, itemstack);
    }

    @Override
    public int[] getCoords() {
        if (this.coords == null) {
            this.coords = new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
        }
        return this.coords;
    }

    @Override
    public int[] getOffset() {
        if (this.offset == null) {
            this.offset = new int[]{-this.getArea()[0] / 2, -2, -this.getArea()[2] / 2};
        }
        return this.offset;
    }

    @Override
    public int[] getArea() {
        if (this.area == null) {
            this.area = new int[]{7 + this.allowedExtent * 2, 13, 7 + this.allowedExtent * 2};
        }
        return this.area;
    }

    public void getGUINetworkData(int i, int j) {
        if (this.tankManager != null) {
            i -= this.tankManager.maxMessageId() + 1;
        }
        switch (i) {
            case 0: {
                this.storedFertilizer = j;
                break;
            }
            case 5: {
                this.ticksSinceRainfall = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.storedFertilizer);
        iCrafting.func_71112_a(container, i + 5, this.ticksSinceRainfall);
    }

    public float getHydrationModifier() {
        return this.getHydrationTempModifier() * this.getHydrationHumidModifier() * this.getHydrationRainfallModifier();
    }

    public float getHydrationTempModifier() {
        float temperature = this.getExactTemperature();
        return temperature > 0.8f ? temperature : 0.8f;
    }

    public float getHydrationHumidModifier() {
        float mod = 1.0f / this.getExactHumidity();
        return mod < 2.0f ? mod : 2.0f;
    }

    public float getHydrationRainfallModifier() {
        float mod = (float)this.ticksSinceRainfall / 24000.0f;
        return mod > 0.5f ? (mod < 15.0f ? mod : 15.0f) : 0.5f;
    }

    public double getDrought() {
        return (double)Math.round((double)this.ticksSinceRainfall / 24000.0 * 10.0) / 10.0;
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public EnumTemperature getTemperature() {
        if (BiomeHelper.isBiomeHellish(this.biome)) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return this.biome.func_150564_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public float getExactHumidity() {
        return this.biome.field_76751_G;
    }

    @Override
    public boolean hasHints() {
        return Config.hints.get("farm").length > 0;
    }

    @Override
    public String[] getHints() {
        return Config.hints.get("farm");
    }

    private static class FarmPlainInventoryAdapter
    extends TileInventoryAdapter<TileFarmPlain> {
        public FarmPlainInventoryAdapter(TileFarmPlain tile) {
            super(tile, 22, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (GuiUtil.isIndexInRange(slotIndex, 20, 1)) {
                return ((TileFarmPlain)this.tile).acceptsAsFertilizer(itemStack);
            }
            if (GuiUtil.isIndexInRange(slotIndex, 6, 6)) {
                return ((TileFarmPlain)this.tile).acceptsAsGermling(itemStack);
            }
            if (GuiUtil.isIndexInRange(slotIndex, 0, 6)) {
                return ((TileFarmPlain)this.tile).acceptsAsResource(itemStack);
            }
            if (GuiUtil.isIndexInRange(slotIndex, 21, 1)) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((TileFarmPlain)this.tile).tankManager.accepts(fluid);
            }
            return false;
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack stack, int side) {
            return GuiUtil.isIndexInRange(slotIndex, 12, 8);
        }
    }

    private static class FarmWorkStatus {
        public boolean didWork = false;
        public boolean hasFarmland = false;
        public boolean hasFertilizer = false;
        public boolean hasLiquid = false;

        private FarmWorkStatus() {
        }
    }

    private static enum Stage {
        CULTIVATE,
        HARVEST;


        public Stage next() {
            Stage[] values = Stage.values();
            int ordinal = (this.ordinal() + 1) % values.length;
            return values[ordinal];
        }
    }
}

