/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.api.farming.IFarmLogic;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Ledger;
import forestry.core.gui.WidgetManager;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.SocketWidget;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gui.ContainerFarm;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GuiFarm
extends GuiForestry<ContainerFarm, TileFarmPlain> {
    public GuiFarm(EntityPlayer player, TileFarmPlain tile) {
        super("textures/gui/mfarm.png", new ContainerFarm(player.field_71071_by, tile), tile);
        this.widgetManager.add(new TankWidget(this.widgetManager, 15, 19, 0).setOverlayOrigin(216, 18));
        this.widgetManager.add(new SocketWidget(this.widgetManager, 69, 40, tile, 0));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 69, 22, 0));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 69, 58, 1));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 51, 40, 2));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 87, 40, 3));
        this.field_146999_f = 216;
        this.field_147000_g = 220;
    }

    @Override
    protected void initLedgers() {
        super.initLedgers();
        this.ledgerManager.insert(new FarmLedger());
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String title = StringUtil.localize("gui.farm.title");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        super.func_146976_a(var1, mouseX, mouseY);
        int fertilizerRemain = ((TileFarmPlain)this.inventory).getStoredFertilizerScaled(16);
        if (fertilizerRemain > 0) {
            this.func_73729_b(this.field_147003_i + 81, this.field_147009_r + 94 + 17 - fertilizerRemain, this.field_146999_f, 17 - fertilizerRemain, 4, fertilizerRemain);
        }
    }

    private class FarmLogicSlot
    extends Widget {
        private final int slot;
        protected final ToolTip toolTip;

        public FarmLogicSlot(WidgetManager manager, int xPos, int yPos, int slot) {
            super(manager, xPos, yPos);
            this.toolTip = new ToolTip(250){

                @Override
                public void refresh() {
                    FarmLogicSlot.this.toolTip.clear();
                    if (FarmLogicSlot.this.getLogic() == null) {
                        return;
                    }
                    FarmLogicSlot.this.toolTip.add(FarmLogicSlot.this.getLogic().getName());
                    FarmLogicSlot.this.toolTip.add("Fertilizer: " + FarmLogicSlot.this.getLogic().getFertilizerConsumption());
                    FarmLogicSlot.this.toolTip.add("Water: " + FarmLogicSlot.this.getLogic().getWaterConsumption(((TileFarmPlain)GuiFarm.this.inventory).getHydrationModifier()));
                }
            };
            this.slot = slot;
        }

        private IFarmLogic getLogic() {
            return ((TileFarmPlain)GuiFarm.this.inventory).getFarmLogics()[this.slot];
        }

        private IIcon getIconIndex() {
            if (this.getLogic() == null) {
                return null;
            }
            return this.getLogic().getIcon();
        }

        @Override
        public void draw(int startX, int startY) {
            if (this.getLogic() == null) {
                return;
            }
            if (this.getIconIndex() != null) {
                GL11.glDisable((int)2896);
                Proxies.common.bindTexture(this.getLogic().getSpriteSheet());
                this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, this.getIconIndex(), 16, 16);
                GL11.glEnable((int)2896);
            }
        }

        @Override
        public ToolTip getToolTip() {
            return this.toolTip;
        }
    }

    protected class FarmLedger
    extends Ledger {
        public FarmLedger() {
            super(GuiFarm.this.ledgerManager, "farm");
            this.maxHeight = 118;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon(Items.field_151131_as.func_77617_a(0), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            this.drawHeader(StringUtil.localize("gui.hydration"), x + 22, y + 8);
            this.drawSubheader(StringUtil.localize("gui.hydr.heat") + ':', x + 22, y + 20);
            this.drawText(StringUtil.floatAsPercent(((TileFarmPlain)GuiFarm.this.inventory).getHydrationTempModifier()), x + 22, y + 32);
            this.drawSubheader(StringUtil.localize("gui.hydr.humid") + ':', x + 22, y + 44);
            this.drawText(StringUtil.floatAsPercent(((TileFarmPlain)GuiFarm.this.inventory).getHydrationHumidModifier()), x + 22, y + 56);
            this.drawSubheader(StringUtil.localize("gui.hydr.rainfall") + ':', x + 22, y + 68);
            this.drawText(StringUtil.floatAsPercent(((TileFarmPlain)GuiFarm.this.inventory).getHydrationRainfallModifier()) + " (" + ((TileFarmPlain)GuiFarm.this.inventory).getDrought() + " d)", x + 22, y + 80);
            this.drawSubheader(StringUtil.localize("gui.hydr.overall") + ':', x + 22, y + 92);
            this.drawText(StringUtil.floatAsPercent(((TileFarmPlain)GuiFarm.this.inventory).getHydrationModifier()), x + 22, y + 104);
        }

        @Override
        public String getTooltip() {
            return StringUtil.floatAsPercent(((TileFarmPlain)GuiFarm.this.inventory).getHydrationModifier()) + ' ' + StringUtil.localize("gui.hydration");
        }
    }
}

