/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.commands;

import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.SubCommand;
import forestry.core.utils.StringUtil;
import forestry.mail.MailAddress;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class CommandMail
extends SubCommand {
    public CommandMail() {
        super("mail");
        this.addChildCommand(new CommandMailTrades());
        this.addChildCommand(new CommandMailVirtualize());
        this.addAlias("ml");
    }

    public static class CommandMailVirtualize
    extends SubCommand {
        public CommandMailVirtualize() {
            super("virtualize");
            this.addAlias("virt");
            this.setPermLevel(SubCommand.PermLevel.ADMIN);
        }

        @Override
        public void processSubCommand(ICommandSender sender, String[] args) {
            MailAddress address;
            World world;
            ITradeStation trade;
            if (args.length != 1) {
                CommandHelpers.throwWrongUsage(sender, this);
            }
            if ((trade = PostManager.postRegistry.getTradeStation(world = CommandHelpers.getWorld(sender, this), address = new MailAddress(args[0]))) == null) {
                ChatStyle red = new ChatStyle();
                red.func_150238_a(EnumChatFormatting.RED);
                CommandHelpers.sendLocalizedChatMessage(sender, red, "for.chat.command.forestry.mail.virtualize.no_tradestation", args[0]);
                return;
            }
            trade.setVirtual(!trade.isVirtual());
            ChatStyle green = new ChatStyle();
            green.func_150238_a(EnumChatFormatting.GREEN);
            CommandHelpers.sendLocalizedChatMessage(sender, green, "for.chat.command.forestry.mail.virtualize.set", trade.getAddress().getName(), trade.isVirtual());
        }
    }

    public static class CommandMailTrades
    extends SubCommand {
        public CommandMailTrades() {
            super("trades");
            this.addAlias("tr");
        }

        @Override
        public void processSubCommand(ICommandSender sender, String[] args) {
            if (!(sender instanceof EntityPlayer)) {
                return;
            }
            for (ITradeStation trade : PostManager.postRegistry.getPostOffice(((EntityPlayer)sender).field_70170_p).getActiveTradeStations(((EntityPlayer)sender).field_70170_p).values()) {
                CommandHelpers.sendChatMessage(sender, this.makeTradeListEntry(trade.getTradeInfo()));
            }
        }

        private String makeTradeListEntry(TradeStationInfo info) {
            EnumChatFormatting formatting = info.state.isOk() ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
            String tradegood = "[ ? ]";
            if (info.tradegood != null) {
                tradegood = info.tradegood.field_77994_a + "x" + info.tradegood.func_82833_r();
            }
            String demand = "[ ? ]";
            if (info.required.length > 0) {
                demand = "";
                for (ItemStack dmd : info.required) {
                    demand = StringUtil.append(", ", demand, dmd.field_77994_a + "x" + dmd.func_82833_r());
                }
            }
            return String.format("%s%-12s | %-20s | %s", formatting, info.address.getName(), tradegood, demand);
        }
    }
}

