/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.FlowerManager;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.core.GameMode;
import forestry.core.fluids.Fluids;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RecipeUtil;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.farming.logic.FarmableStacked;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="PlantMegaPack", name="PlantMegaPack", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.plantmegapack.description")
public class PluginPlantMegaPack
extends ForestryPlugin {
    private static final String PlantMP = "plantmegapack";

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded(PlantMP);
    }

    @Override
    public String getFailMessage() {
        return "Plant Mega Pack not found";
    }

    @Override
    protected void registerRecipes() {
        ImmutableList reedLikePlant = ImmutableList.of((Object)"bambooAsper", (Object)"bambooFargesiaRobusta", (Object)"bambooGiantTimber", (Object)"bambooGolden", (Object)"bambooMoso", (Object)"bambooShortTassled", (Object)"bambooTimorBlack", (Object)"bambooTropicalBlue", (Object)"bambooWetForest");
        ImmutableList landCropPlant = ImmutableList.of((Object)"Beet", (Object)"BellPepperYellow", (Object)"Celery", (Object)"Corn", (Object)"Cucumber", (Object)"Lettuce", (Object)"Onion", (Object)"Spinach", (Object)"Tomato");
        ImmutableMap desertPlant = ImmutableMap.builder().put((Object)"desertApachePlume", (Object)4).put((Object)"desertBrittlebush", (Object)4).put((Object)"desertBroadLeafGilia", (Object)4).put((Object)"desertBroomSnakeweed", (Object)4).put((Object)"desertKangarooPaw", (Object)4).put((Object)"desertOcotillo", (Object)4).put((Object)"desertPeninsulaOnion", (Object)4).put((Object)"desertSeepwood", (Object)4).put((Object)"desertWhiteSage", (Object)4).build();
        ImmutableMap nonGrowingFlowers = ImmutableMap.builder().put((Object)"flowerAchillea", (Object)9).put((Object)"flowerAlpineThistle", (Object)1).put((Object)"flowerAzalea", (Object)13).put((Object)"flowerBegonia", (Object)9).put((Object)"flowerBell", (Object)10).put((Object)"flowerBirdofParadise", (Object)1).put((Object)"flowerBlueStar", (Object)1).put((Object)"flowerBurningLove", (Object)1).put((Object)"flowerCandelabraAloe", (Object)1).put((Object)"flowerCarnation", (Object)7).put((Object)"flowerCelosia", (Object)7).put((Object)"flowerDahlia", (Object)8).put((Object)"flowerDaisy", (Object)8).put((Object)"flowerDelphinium", (Object)4).put((Object)"flowerDottedBlazingstar", (Object)1).put((Object)"flowerElephantEars", (Object)1).put((Object)"flowerFoamFlower", (Object)1).put((Object)"flowerFuchsia", (Object)1).put((Object)"flowerGeranium", (Object)5).put((Object)"flowerGladiolus", (Object)9).put((Object)"flowerHawkweed", (Object)4).put((Object)"flowerHydrangea", (Object)6).put((Object)"flowerJacobsLadder", (Object)1).put((Object)"flowerLily", (Object)5).put((Object)"flowerLionsTail", (Object)1).put((Object)"flowerLupine", (Object)10).put((Object)"flowerMarigold", (Object)2).put((Object)"flowerMediterraneanSeaHolly", (Object)1).put((Object)"flowerNemesia", (Object)12).put((Object)"flowerNewGuineaImpatiens", (Object)1).put((Object)"flowerParrotsBeak", (Object)1).put((Object)"flowerPeruvianLily", (Object)1).put((Object)"flowerPurpleConeflower", (Object)1).put((Object)"flowerRose", (Object)13).put((Object)"flowerRoseCampion", (Object)1).put((Object)"flowerStreamsideBluebells", (Object)1).put((Object)"flowerTorchLily", (Object)1).put((Object)"flowerTulip", (Object)7).put((Object)"flowerViolet", (Object)1).put((Object)"flowerWildCarrot", (Object)1).put((Object)"flowerWildDaffodil", (Object)1).put((Object)"flowerWoodlandPinkroot", (Object)1).put((Object)"flowerYellowToadflax", (Object)1).build();
        ImmutableMap cactusPlant = ImmutableMap.builder().put((Object)"cactusArmatocereusMatucanensis", (Object)6).put((Object)"cactusBaseballBat", (Object)6).put((Object)"cactusEchinocereusMetornii", (Object)2).put((Object)"cactusGoldenCereus", (Object)3).put((Object)"cactusGoldenSaguaro", (Object)6).put((Object)"cactusMatucanaAureiflora", (Object)1).put((Object)"cactusPricklyPear", (Object)5).put((Object)"cactusSnowPole", (Object)6).put((Object)"cactusToothpick", (Object)6).build();
        ImmutableMap forestPlant = ImmutableMap.builder().put((Object)"forestArcticGentian", (Object)1).put((Object)"forestAustralianBugle", (Object)2).put((Object)"forestBroadleafMeadowsweet", (Object)2).put((Object)"forestDeadnettle", (Object)2).put((Object)"forestDeceivingTrillium", (Object)2).put((Object)"forestFairySlipper", (Object)2).put((Object)"forestHorseweed", (Object)2).put((Object)"forestKneelingAngelica", (Object)2).put((Object)"forestNorthernPitcherPlant", (Object)2).put((Object)"forestPinesap", (Object)2).put((Object)"forestRedHelleborine", (Object)2).put((Object)"forestSalal", (Object)2).put((Object)"forestVanillaLeaf", (Object)1).put((Object)"forestWesternWallflower", (Object)2).put((Object)"forestWildColumbine", (Object)2).put((Object)"forestWildMint", (Object)2).put((Object)"forestWolfsFootClubmoss", (Object)1).build();
        ImmutableMap plainsPlant = ImmutableMap.builder().put((Object)"plainsPrairieBrome", (Object)6).put((Object)"plainsPrairieSage", (Object)4).put((Object)"plainsReedCanaryGrass", (Object)6).put((Object)"plainsShortrayFleabane", (Object)4).put((Object)"plainsSmallPasqueFlower", (Object)4).put((Object)"plainsSmoothAster", (Object)4).put((Object)"plainsThreeFloweredAvens", (Object)4).build();
        ImmutableList waterPlant = ImmutableList.of((Object)"waterKelpGiantGRN", (Object)"waterKelpGiantYEL");
        int seedamount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
        int juiceAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple");
        for (String reedLike : reedLikePlant) {
            Block reedBlock = GameRegistry.findBlock((String)PlantMP, (String)reedLike);
            ItemStack reedStack = GameRegistry.findItemStack((String)PlantMP, (String)reedLike, (int)1);
            if (reedBlock == null || reedStack == null) continue;
            RecipeUtil.injectLeveledRecipe(reedStack, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
            Farmables.farmables.get("farmPoales").add(new FarmableStacked(reedBlock, 14, 4));
        }
        for (String landCrop : landCropPlant) {
            Block landCropBlock = GameRegistry.findBlock((String)PlantMP, (String)("crop" + landCrop));
            ItemStack seedStack = GameRegistry.findItemStack((String)PlantMP, (String)("seed" + landCrop), (int)1);
            ItemStack foodStack = GameRegistry.findItemStack((String)PlantMP, (String)("food" + landCrop), (int)1);
            if (landCropBlock == null) continue;
            if (foodStack != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{foodStack}, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (seedStack != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{seedStack}, Fluids.SEEDOIL.getFluid(seedamount));
            }
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(seedStack, landCropBlock, 4));
        }
        for (Map.Entry flower : nonGrowingFlowers.entrySet()) {
            Block flowerPlantBlock = GameRegistry.findBlock((String)PlantMP, (String)((String)flower.getKey()));
            if (flowerPlantBlock == null) continue;
            for (int i = 0; i < (Integer)flower.getValue(); ++i) {
                FlowerManager.flowerRegistry.registerPlantableFlower(flowerPlantBlock, i, 0.75, "flowersVanilla");
            }
        }
        PluginPlantMegaPack.addMetaFlower((ImmutableMap<String, Integer>)cactusPlant, "flowersCacti", false);
        PluginPlantMegaPack.addMetaFlower((ImmutableMap<String, Integer>)desertPlant, "flowersCacti", false);
        PluginPlantMegaPack.addMetaFlower((ImmutableMap<String, Integer>)forestPlant, "flowersVanilla", true);
        PluginPlantMegaPack.addMetaFlower((ImmutableMap<String, Integer>)plainsPlant, "flowersVanilla", true);
        for (String wPlant : waterPlant) {
            ItemStack waterPlantStack = GameRegistry.findItemStack((String)PlantMP, (String)wPlant, (int)1);
            if (waterPlantStack == null) continue;
            RecipeUtil.injectLeveledRecipe(waterPlantStack, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
    }

    private static void addMetaFlower(ImmutableMap<String, Integer> flowerMap, String flowertype, boolean plantable) {
        for (Map.Entry flower : flowerMap.entrySet()) {
            Block flowerBlock = GameRegistry.findBlock((String)PlantMP, (String)((String)flower.getKey()));
            ItemStack flowerStack = GameRegistry.findItemStack((String)PlantMP, (String)((String)flower.getKey()), (int)1);
            FlowerManager.flowerRegistry.registerAcceptableFlower(flowerBlock, flowertype);
            if (plantable && flowerBlock != null) {
                FlowerManager.flowerRegistry.registerPlantableFlower(flowerBlock, 0, 0.75, flowertype);
            }
            if (flowerStack == null || flowerBlock == null) continue;
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(flowerStack, flowerBlock, (Integer)flower.getValue()));
        }
    }
}

