/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core;

import java.util.EnumSet;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;

public class RenderHelper {
    public static boolean renderRotated2D(IIcon icon, float iconScale, RenderBlocks renderer, double posX, double posY, double posZ, double xWidth, double yHeight, double angle) {
        angle = angle * Math.PI / 180.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        double minU = icon.func_94209_e();
        double maxU = icon.func_94209_e() + (icon.func_94212_f() - icon.func_94209_e()) / iconScale;
        double minV = icon.func_94206_g();
        double maxV = icon.func_94206_g() + (icon.func_94210_h() - icon.func_94206_g()) / iconScale;
        double yMin = posY;
        double intermedVarX = xWidth / 2.0;
        double point1X = posX + 0.5 - intermedVarX * Math.sin(angle);
        double point1Z = posZ + 0.5 + intermedVarX * Math.cos(angle);
        intermedVarX = -xWidth / 2.0;
        double point2X = posX + 0.5 - intermedVarX * Math.sin(angle);
        double point2Z = posZ + 0.5 + intermedVarX * Math.cos(angle);
        tessellator.func_78374_a(point1X, yMin + yHeight, point1Z, minU, minV);
        tessellator.func_78374_a(point1X, yMin + 0.0, point1Z, minU, maxV);
        tessellator.func_78374_a(point2X, yMin + 0.0, point2Z, maxU, maxV);
        tessellator.func_78374_a(point2X, yMin + yHeight, point2Z, maxU, minV);
        tessellator.func_78374_a(point2X, yMin + yHeight, point2Z, minU, minV);
        tessellator.func_78374_a(point2X, yMin + 0.0, point2Z, minU, maxV);
        tessellator.func_78374_a(point1X, yMin + 0.0, point1Z, maxU, maxV);
        tessellator.func_78374_a(point1X, yMin + yHeight, point1Z, maxU, minV);
        return true;
    }

    public static boolean renderRotatedRectangle(IIcon icon, float iconScale, RenderBlocks renderer, double posX, double posY, double posZ, double xWidth, double yHeight, double zWidth, double angle) {
        RenderHelper.renderRotatedRectangle(icon, iconScale, renderer, posX, posY, posZ, xWidth, yHeight, zWidth, angle, EnumSet.allOf(Surface.class));
        return true;
    }

    public static boolean renderRotatedRectangle(IIcon icon, float iconScale, RenderBlocks renderer, double posX, double posY, double posZ, double xWidth, double yHeight, double zWidth, double angle, EnumSet<Surface> sidesToDraw) {
        angle = angle * Math.PI / 180.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        double deltaU = icon.func_94212_f() - icon.func_94209_e();
        double deltaV = icon.func_94210_h() - icon.func_94206_g();
        double minU = (double)icon.func_94209_e() + deltaU / 2.0 * (double)(1.0f - 1.0f / iconScale);
        double maxU = (double)icon.func_94212_f() - deltaU / 2.0 * (double)(1.0f - 1.0f / iconScale);
        double minV = (double)icon.func_94206_g() + deltaV / 2.0 * (double)(1.0f - 1.0f / iconScale);
        double maxV = (double)icon.func_94210_h() - deltaV / 2.0 * (double)(1.0f - 1.0f / iconScale);
        double yMin = posY;
        double intermedVarZ = -zWidth / 2.0;
        double intermedVarX = xWidth / 2.0;
        double point1X = posX + 0.5 + intermedVarZ * Math.cos(angle) - intermedVarX * Math.sin(angle);
        double point1Z = posZ + 0.5 + intermedVarZ * Math.sin(angle) + intermedVarX * Math.cos(angle);
        intermedVarZ = -zWidth / 2.0;
        intermedVarX = -xWidth / 2.0;
        double point2X = posX + 0.5 + intermedVarZ * Math.cos(angle) - intermedVarX * Math.sin(angle);
        double point2Z = posZ + 0.5 + intermedVarZ * Math.sin(angle) + intermedVarX * Math.cos(angle);
        intermedVarZ = zWidth / 2.0;
        intermedVarX = -xWidth / 2.0;
        double point3X = posX + 0.5 + intermedVarZ * Math.cos(angle) - intermedVarX * Math.sin(angle);
        double point3Z = posZ + 0.5 + intermedVarZ * Math.sin(angle) + intermedVarX * Math.cos(angle);
        intermedVarZ = zWidth / 2.0;
        intermedVarX = xWidth / 2.0;
        double point4X = posX + 0.5 + intermedVarZ * Math.cos(angle) - intermedVarX * Math.sin(angle);
        double point4Z = posZ + 0.5 + intermedVarZ * Math.sin(angle) + intermedVarX * Math.cos(angle);
        for (Surface surface : sidesToDraw) {
            switch (surface) {
                case RIGHT: {
                    tessellator.func_78374_a(point1X, yMin, point1Z, minU, minV);
                    tessellator.func_78374_a(point1X, yMin + yHeight, point1Z, minU, maxV);
                    tessellator.func_78374_a(point2X, yMin + yHeight, point2Z, maxU, maxV);
                    tessellator.func_78374_a(point2X, yMin, point2Z, maxU, minV);
                    tessellator.func_78374_a(point2X, yMin, point2Z, maxU, minV);
                    tessellator.func_78374_a(point2X, yMin + yHeight, point2Z, maxU, maxV);
                    tessellator.func_78374_a(point1X, yMin + yHeight, point1Z, minU, maxV);
                    tessellator.func_78374_a(point1X, yMin, point1Z, minU, minV);
                    break;
                }
                case LEFT: {
                    tessellator.func_78374_a(point4X, yMin, point4Z, minU, minV);
                    tessellator.func_78374_a(point4X, yMin + yHeight, point4Z, minU, maxV);
                    tessellator.func_78374_a(point3X, yMin + yHeight, point3Z, maxU, maxV);
                    tessellator.func_78374_a(point3X, yMin, point3Z, maxU, minV);
                    tessellator.func_78374_a(point3X, yMin, point3Z, maxU, minV);
                    tessellator.func_78374_a(point3X, yMin + yHeight, point3Z, maxU, maxV);
                    tessellator.func_78374_a(point4X, yMin + yHeight, point4Z, minU, maxV);
                    tessellator.func_78374_a(point4X, yMin, point4Z, minU, minV);
                    break;
                }
                case BACK: {
                    tessellator.func_78374_a(point1X, yMin, point1Z, minU, minV);
                    tessellator.func_78374_a(point1X, yMin + yHeight, point1Z, minU, maxV);
                    tessellator.func_78374_a(point4X, yMin + yHeight, point4Z, maxU, maxV);
                    tessellator.func_78374_a(point4X, yMin, point4Z, maxU, minV);
                    tessellator.func_78374_a(point4X, yMin, point4Z, maxU, minV);
                    tessellator.func_78374_a(point4X, yMin + yHeight, point4Z, maxU, maxV);
                    tessellator.func_78374_a(point1X, yMin + yHeight, point1Z, minU, maxV);
                    tessellator.func_78374_a(point1X, yMin, point1Z, minU, minV);
                    break;
                }
                case FRONT: {
                    tessellator.func_78374_a(point3X, yMin, point3Z, minU, minV);
                    tessellator.func_78374_a(point3X, yMin + yHeight, point3Z, minU, maxV);
                    tessellator.func_78374_a(point2X, yMin + yHeight, point2Z, maxU, maxV);
                    tessellator.func_78374_a(point2X, yMin, point2Z, maxU, minV);
                    tessellator.func_78374_a(point2X, yMin, point2Z, maxU, minV);
                    tessellator.func_78374_a(point2X, yMin + yHeight, point2Z, maxU, maxV);
                    tessellator.func_78374_a(point3X, yMin + yHeight, point3Z, minU, maxV);
                    tessellator.func_78374_a(point3X, yMin, point3Z, minU, minV);
                    break;
                }
                case TOP: {
                    tessellator.func_78374_a(point1X, yMin + yHeight, point1Z, minU, minV);
                    tessellator.func_78374_a(point2X, yMin + yHeight, point2Z, minU, maxV);
                    tessellator.func_78374_a(point3X, yMin + yHeight, point3Z, maxU, maxV);
                    tessellator.func_78374_a(point4X, yMin + yHeight, point4Z, maxU, minV);
                    tessellator.func_78374_a(point4X, yMin + yHeight, point4Z, maxU, minV);
                    tessellator.func_78374_a(point3X, yMin + yHeight, point3Z, maxU, maxV);
                    tessellator.func_78374_a(point2X, yMin + yHeight, point2Z, minU, maxV);
                    tessellator.func_78374_a(point1X, yMin + yHeight, point1Z, minU, minV);
                    break;
                }
                case BOTTOM: {
                    tessellator.func_78374_a(point1X, yMin, point1Z, minU, minV);
                    tessellator.func_78374_a(point2X, yMin, point2Z, minU, maxV);
                    tessellator.func_78374_a(point3X, yMin, point3Z, maxU, maxV);
                    tessellator.func_78374_a(point4X, yMin, point4Z, maxU, minV);
                    tessellator.func_78374_a(point4X, yMin, point4Z, maxU, minV);
                    tessellator.func_78374_a(point3X, yMin, point3Z, maxU, maxV);
                    tessellator.func_78374_a(point2X, yMin, point2Z, minU, maxV);
                    tessellator.func_78374_a(point1X, yMin, point1Z, minU, minV);
                }
            }
        }
        return true;
    }

    public static enum Surface {
        TOP(0),
        BOTTOM(1),
        RIGHT(2),
        LEFT(3),
        FRONT(4),
        BACK(5);

        public final int index;

        private Surface(int index) {
            this.index = index;
        }
    }
}

