/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core.entitydeclaration;

import com.google.common.base.Optional;
import com.stek101.projectzulu.common.ProjectZulu_Core;
import com.stek101.projectzulu.common.api.CustomEntityList;
import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityDeclaration;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraftforge.common.config.Configuration;

public abstract class CreatureDeclaration
implements EntityDeclaration {
    public final String mobName;
    public final int entityID;
    protected Class mobClass;
    protected EnumCreatureType enumCreatureType;
    protected boolean shouldExist = true;
    protected boolean reportSpawningInLog = false;
    protected int maxSpawnInChunk = 4;
    protected int trackingRange;
    protected int updateFrequency;
    protected boolean sendsVelocityUpdates;
    protected boolean shouldDespawn;
    protected int minDropNum = 0;
    protected int maxDropNum = 0;

    protected CreatureDeclaration(String mobName, int entityID, Class mobClass, EnumCreatureType creatureType) {
        this.mobName = mobName;
        this.entityID = entityID;
        this.mobClass = mobClass;
        this.enumCreatureType = creatureType;
        this.shouldDespawn = this.enumCreatureType != EnumCreatureType.creature;
    }

    @Override
    public String getIdentifier() {
        return this.mobName;
    }

    protected void setDropAmount(int minDropNum, int maxDropNum) {
        this.minDropNum = minDropNum;
        this.maxDropNum = maxDropNum;
    }

    protected void setRegistrationProperties(int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        this.trackingRange = trackingRange;
        this.updateFrequency = updateFrequency;
        this.sendsVelocityUpdates = sendsVelocityUpdates;
    }

    @Override
    public boolean shouldExist() {
        return this.shouldExist;
    }

    @Override
    public void loadCreaturesFromConfig(Configuration config) {
        this.shouldExist = config.get("MOB CONTROLS." + this.mobName, this.mobName.toLowerCase() + " shouldExist", this.shouldExist).getBoolean(this.shouldExist);
        this.reportSpawningInLog = config.get("MOB CONTROLS." + this.mobName, this.mobName.toLowerCase() + " reportSpawningInLog", this.reportSpawningInLog).getBoolean(this.reportSpawningInLog);
        this.updateFrequency = config.get("MOB CONTROLS." + this.mobName, this.mobName.toLowerCase() + " UpdateFrequency", this.updateFrequency).getInt(this.updateFrequency);
    }

    @Override
    public void loadBiomesFromConfig(Configuration config) {
    }

    @Override
    public void registerEntity() {
        EntityRegistry.registerModEntity((Class)this.mobClass, (String)this.mobName, (int)this.entityID, (Object)ProjectZulu_Core.modInstance, (int)this.trackingRange, (int)this.updateFrequency, (boolean)true);
    }

    @Override
    public void loadCustomMobData(File configDirectory) {
        Configuration config = new Configuration(new File(configDirectory, "/Project Zulu/ProjectZuluMobBiomeConfig.cfg"));
        config.load();
        CustomMobData customMobData = new CustomMobData(this.mobName);
        this.outputDataToList(config, customMobData);
        CustomEntityList customEntity = CustomEntityList.getByName(this.mobName);
        if (customEntity != null) {
            customEntity.modData = Optional.of((Object)customMobData);
        } else {
            ProjectZuluLog.severe("Entity %s does not have an Entry in the CustomEntityList", this.mobName);
        }
        config.save();
    }

    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        customMobData.reportSpawningInLog = this.reportSpawningInLog;
        customMobData.creatureType = ConfigHelper.configGetCreatureType(config, "MOB CONTROLS." + this.mobName, "Creature Type", this.enumCreatureType);
        customMobData.shouldDespawn = config.get("MOB CONTROLS." + this.mobName, this.mobName + " Should Despawn", this.shouldDespawn).getBoolean(true);
        ConfigHelper.userItemConfigRangeToMobData(config, "MOB CONTROLS." + this.mobName, customMobData);
        customMobData.maxSpawnInChunk = this.maxSpawnInChunk;
        customMobData.minDropNum = config.get("MOB CONTROLS." + this.mobName, "Items to Drop Min", this.minDropNum).getInt(this.minDropNum);
        customMobData.maxDropNum = config.get("MOB CONTROLS." + this.mobName, "Items to Drop Max", this.maxDropNum).getInt(this.maxDropNum);
    }

    @Override
    public void registerEgg() {
    }

    @Override
    public void addSpawn() {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract RenderWrapper getEntityrender(Class<? extends EntityLivingBase> var1);

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModelAndRender() {
        RenderWrapper wrapper = this.getEntityrender(this.mobClass);
        if (wrapper == null || wrapper.getRender() == null) {
            throw new IllegalStateException("Entity Renderer for " + this.mobClass.getSimpleName() + " cannot be null");
        }
        RenderingRegistry.registerEntityRenderingHandler((Class)this.mobClass, (Render)wrapper.getRender());
    }
}

