/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core.itemblockdeclaration;

import com.stek101.projectzulu.common.core.itemblockdeclaration.ItemBlockDeclaration;
import cpw.mods.fml.relauncher.Side;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class ItemSetDeclaration
implements ItemBlockDeclaration {
    private int registerPass;
    public final String[] name;
    private boolean[] isEnabled;
    private boolean[] isCreated;

    public ItemSetDeclaration(String[] name) {
        this(name, 0);
    }

    public ItemSetDeclaration(String[] name, int registerPass) {
        this.registerPass = registerPass;
        this.name = name;
        this.isEnabled = new boolean[name.length];
        this.isCreated = new boolean[name.length];
        for (int i = 0; i < name.length; ++i) {
            this.isEnabled[i] = true;
            this.isCreated[i] = false;
        }
    }

    @Override
    public ItemBlockDeclaration.Type getType() {
        return ItemBlockDeclaration.Type.Item;
    }

    @Override
    public int getRegisterPass() {
        return this.registerPass;
    }

    @Override
    public final void createWithConfig(Configuration config, boolean readOnly) {
        if (!readOnly) {
            for (int i = 0; i < this.name.length; ++i) {
                Property property = config.get("item", this.name[i] + " isEnabled", this.isEnabled[i]);
                this.isEnabled[i] = property.getBoolean(this.isEnabled[i]);
                if (!this.isEnabled[i]) continue;
                this.preCreateLoadConfig(config);
                this.isCreated[i] = this.createItem(i);
                this.postCreateLoadConfig(config);
            }
        }
    }

    protected void preCreateLoadConfig(Configuration config) {
    }

    protected void postCreateLoadConfig(Configuration config) {
    }

    protected abstract boolean createItem(int var1);

    @Override
    public final void register(Side side) {
        for (int i = 0; i < this.name.length; ++i) {
            if (!this.isCreated[i]) continue;
            this.registerItem(i);
            if (side.isServer()) continue;
            this.clientRegisterBlock(i);
        }
    }

    protected abstract void registerItem(int var1);

    protected void clientRegisterBlock(int partIndex) {
    }
}

