/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core.terrain;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.terrain.FeatureConfiguration;
import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import java.io.File;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public abstract class BaseFeature
implements TerrainFeature {
    private boolean shouldSpawn = true;
    protected int minChunkDistance;
    protected int chunksPerSpawn;
    protected boolean printToLog;
    private TerrainFeature.Size size;
    private String featureName;

    public BaseFeature(String featureName, TerrainFeature.Size size) {
        this.featureName = featureName.toLowerCase();
        this.size = size;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public boolean isEnabled() {
        return this.shouldSpawn;
    }

    @Override
    public TerrainFeature.Size getFeatureSize() {
        return this.size;
    }

    @Override
    public final void initialize(File modConfigDirectory) {
        FeatureConfiguration configuration = new FeatureConfiguration(modConfigDirectory);
        configuration.load();
        this.loadSettings(configuration);
        configuration.save();
    }

    protected abstract void loadDefaultSettings();

    protected void loadSettings(FeatureConfiguration config) {
        this.loadDefaultSettings();
        this.shouldSpawn = config.getFeatureProperty((TerrainFeature)this, "General", "Should Generate", this.shouldSpawn).getBoolean(this.shouldSpawn);
        this.minChunkDistance = config.getFeatureProperty((TerrainFeature)this, "General", "minChunkDistance", this.minChunkDistance).getInt(this.minChunkDistance);
        this.minChunkDistance = this.minChunkDistance < 1 ? 1 : this.minChunkDistance;
        this.chunksPerSpawn = config.getFeatureProperty((TerrainFeature)this, "General", "chunksPerSpawn", this.chunksPerSpawn).getInt(this.chunksPerSpawn);
        this.chunksPerSpawn = this.chunksPerSpawn < 1 ? 1 : this.chunksPerSpawn;
        this.printToLog = config.getFeatureProperty((TerrainFeature)this, "General", "printToLog", this.printToLog).getBoolean(this.printToLog);
    }

    @Override
    public boolean canGenerateHere(World world, int chunkX, int chunkZ, ChunkCoordinates genBlockCoords, Random random) {
        return this.shouldSpawn && (chunkX % this.minChunkDistance == 0 || chunkZ % this.minChunkDistance == 0) && random.nextInt(this.chunksPerSpawn) == 0;
    }

    @Override
    public boolean isStructureHere(World world, int chunkX, int chunkZ, ChunkCoordinates genBlockCoords, Random random) {
        throw new UnsupportedOperationException("Reverse lookup feature has not been implemented yet.");
    }

    protected void logGeneration(ChunkCoordinates genBlockCoords) {
        if (this.printToLog) {
            ProjectZuluLog.info("Generating %s at %s, %s, %s", this.getFeatureName(), genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c);
        }
    }
}

