/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core.terrain;

import com.stek101.projectzulu.common.core.terrain.BaseFeature;
import com.stek101.projectzulu.common.core.terrain.FeatureConfiguration;
import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class BiomeFeature
extends BaseFeature {
    protected ArrayList<String> biomesToSpawn = new ArrayList();

    public BiomeFeature(String featureName, TerrainFeature.Size size) {
        super(featureName, size);
    }

    @Override
    public boolean canGenerateHere(World world, int chunkX, int chunkZ, ChunkCoordinates genBlockCoords, Random random) {
        if (super.canGenerateHere(world, chunkX, chunkZ, genBlockCoords, random)) {
            return this.biomesToSpawn.contains(this.getBiomePackageName(world.func_72807_a(genBlockCoords.field_71574_a, genBlockCoords.field_71573_c)));
        }
        return false;
    }

    protected abstract Collection<String> getDefaultBiomeList();

    @Override
    protected void loadSettings(FeatureConfiguration config) {
        super.loadSettings(config);
        Collection<String> defaultBiomesToSpawn = this.getDefaultBiomeList();
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            if (BiomeGenBase.func_150565_n()[i] == null || !config.getFeatureProperty((TerrainFeature)this, "GeneratingBiomes", this.getBiomePackageName(BiomeGenBase.func_150565_n()[i]), defaultBiomesToSpawn.contains(BiomeGenBase.func_150565_n()[i].field_76791_y)).getBoolean(false)) continue;
            this.biomesToSpawn.add(this.getBiomePackageName(BiomeGenBase.func_150565_n()[i]));
        }
    }

    private String getBiomePackageName(BiomeGenBase biome) {
        return biome.getClass().getName() + "." + biome.field_76791_y;
    }
}

