/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon;

import com.google.common.base.CharMatcher;
import com.stek101.projectzulu.common.dungeon.DataFields;
import com.stek101.projectzulu.common.dungeon.GuiLimitedMobSpawner;
import com.stek101.projectzulu.common.dungeon.TileEntityLimitedMobSpawner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;

public class SpawnerFields
implements DataFields {
    private boolean isEnabled = true;
    private GuiTextField minSpawnDelay;
    private GuiTextField maxSpawnDelay;
    private GuiTextField maxToSpawn;
    private GuiTextField requiredPlayerRange;
    private GuiTextField maxNearbyEntities;
    private GuiTextField spawnRangeVertical;
    private GuiTextField spawnRangeHorizontal;
    private GuiTextField spawnOffsetX;
    private GuiTextField spawnOffsetY;
    private GuiTextField spawnOffsetZ;
    private GuiButton toggleDebug;
    private GuiButton resetDebug;
    private GuiLimitedMobSpawner parent;
    public static final ResourceLocation CREATURE_GUI = new ResourceLocation("projectzuludungeon", "textures/creaturelistgui.png");

    SpawnerFields(GuiLimitedMobSpawner parent) {
        this.parent = parent;
    }

    @Override
    public DataFields createFields(Minecraft mc, int screenWidth, int screenHeight, Point backgroundSize) {
        this.minSpawnDelay = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(177, 24), new Point(20, 14), this.minSpawnDelay != null ? this.minSpawnDelay.func_146179_b() : "");
        this.maxSpawnDelay = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(201, 24), new Point(20, 14), this.maxSpawnDelay != null ? this.maxSpawnDelay.func_146179_b() : "");
        this.requiredPlayerRange = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(201, 41), new Point(39, 14), this.requiredPlayerRange != null ? this.requiredPlayerRange.func_146179_b() : "");
        this.maxToSpawn = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(201, 58), new Point(20, 14), this.maxToSpawn != null ? this.maxToSpawn.func_146179_b() : "");
        this.maxNearbyEntities = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(201, 75), new Point(39, 14), this.maxNearbyEntities != null ? this.maxNearbyEntities.func_146179_b() : "");
        this.spawnRangeVertical = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(201, 92), new Point(20, 14), this.spawnRangeVertical != null ? this.spawnRangeVertical.func_146179_b() : "");
        this.spawnRangeHorizontal = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(177, 92), new Point(20, 14), this.spawnRangeHorizontal != null ? this.spawnRangeHorizontal.func_146179_b() : "");
        this.spawnOffsetX = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(177, 109), new Point(20, 14), this.spawnOffsetX != null ? this.spawnOffsetX.func_146179_b() : "");
        this.spawnOffsetZ = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(201, 109), new Point(20, 14), this.spawnOffsetZ != null ? this.spawnOffsetZ.func_146179_b() : "");
        this.spawnOffsetY = this.setupTextField(mc.field_71466_p, new Point(screenWidth, screenHeight), backgroundSize, new Point(201, 126), new Point(20, 14), this.spawnOffsetY != null ? this.spawnOffsetY.func_146179_b() : "");
        this.toggleDebug = new GuiButton(1, (screenWidth - backgroundSize.getX()) / 2 + 5, (screenHeight - backgroundSize.getY()) / 2 + 175, 70, 20, "Toggle Debug");
        this.resetDebug = new GuiButton(1, (screenWidth - backgroundSize.getX()) / 2 + 151, (screenHeight - backgroundSize.getY()) / 2 + 175, 70, 20, "Reset Debug");
        return this;
    }

    private GuiTextField setupTextField(FontRenderer fontRenderer, Point screenSize, Point backgroundSize, Point position, Point boxSize, String text) {
        GuiTextField newTextField = new GuiTextField(fontRenderer, (screenSize.getX() - backgroundSize.getX()) / 2 + position.getX(), (screenSize.getY() - backgroundSize.getY()) / 2 + position.getY(), boxSize.getX(), boxSize.getY());
        newTextField.func_146180_a(text);
        newTextField.func_146193_g(-1);
        newTextField.func_146204_h(-1);
        newTextField.func_146185_a(false);
        newTextField.func_146203_f(3);
        return newTextField;
    }

    @Override
    public void loadFromTileEntity(TileEntityLimitedMobSpawner limitedMobSpawner, int elementID) {
        this.minSpawnDelay.func_146180_a(Integer.toString(limitedMobSpawner.getMinSpawnDelay() / 20));
        this.maxSpawnDelay.func_146180_a(Integer.toString(limitedMobSpawner.getMaxSpawnDelay() / 20));
        this.maxToSpawn.func_146180_a(Integer.toString(limitedMobSpawner.getMaxSpawnableEntities()));
        this.requiredPlayerRange.func_146180_a(Integer.toString(limitedMobSpawner.getRequriedPLayerRange()));
        this.maxNearbyEntities.func_146180_a(Integer.toString(limitedMobSpawner.getMaxNearbyEntities()));
        this.spawnRangeHorizontal.func_146180_a(Integer.toString(limitedMobSpawner.getSpawnRangeHorizontal()));
        this.spawnRangeVertical.func_146180_a(Integer.toString(limitedMobSpawner.getSpawnRangeVertial()));
        this.spawnOffsetX.func_146180_a(Integer.toString(limitedMobSpawner.spawnRangeOffsetX));
        this.spawnOffsetY.func_146180_a(Integer.toString(limitedMobSpawner.spawnRangeOffsetY));
        this.spawnOffsetZ.func_146180_a(Integer.toString(limitedMobSpawner.spawnRangeOffsetZ));
    }

    @Override
    public void saveToTileEntity(TileEntityLimitedMobSpawner limitedMobSpawner) {
        limitedMobSpawner.setMinMaxSpawnDelay(Integer.parseInt(this.minSpawnDelay.func_146179_b()) * 20, Integer.parseInt(this.maxSpawnDelay.func_146179_b()) * 20);
        limitedMobSpawner.setMaxSpawnableEntities(Integer.parseInt(this.maxToSpawn.func_146179_b()));
        limitedMobSpawner.setRequiredPlayerRange(Integer.parseInt(this.requiredPlayerRange.func_146179_b()));
        limitedMobSpawner.setMaxNearbyEntities(Integer.parseInt(this.maxNearbyEntities.func_146179_b()));
        limitedMobSpawner.setSpawnRangeHorizontal(Integer.parseInt(this.spawnRangeHorizontal.func_146179_b()));
        limitedMobSpawner.setSpawnRangeVertical(Integer.parseInt(this.spawnRangeVertical.func_146179_b()));
        limitedMobSpawner.spawnRangeOffsetX = Integer.parseInt(this.spawnOffsetX.func_146179_b());
        limitedMobSpawner.spawnRangeOffsetY = Integer.parseInt(this.spawnOffsetY.func_146179_b());
        limitedMobSpawner.spawnRangeOffsetZ = Integer.parseInt(this.spawnOffsetZ.func_146179_b());
    }

    @Override
    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean keyboardInput(char keyChar, int keyID) {
        if (this.isEnabled) {
            return this.correctIfInvalid(this.minSpawnDelay, keyChar, keyID) || this.correctIfInvalid(this.maxSpawnDelay, keyChar, keyID) || this.correctIfInvalid(this.maxToSpawn, keyChar, keyID) || this.correctIfInvalid(this.maxNearbyEntities, keyChar, keyID) || this.correctIfInvalid(this.requiredPlayerRange, keyChar, keyID) || this.correctIfInvalid(this.spawnRangeVertical, keyChar, keyID) || this.correctIfInvalid(this.spawnRangeHorizontal, keyChar, keyID) || this.correctIfInvalid(this.spawnOffsetX, "-0123456789", keyChar, keyID) || this.correctIfInvalid(this.spawnOffsetZ, "-0123456789", keyChar, keyID) || this.correctIfInvalid(this.spawnOffsetY, "-0123456789", keyChar, keyID);
        }
        return false;
    }

    private boolean correctIfInvalid(GuiTextField guiTextField, char keyChar, int keyID) {
        return this.correctIfInvalid(guiTextField, "0123456789", keyChar, keyID);
    }

    private boolean correctIfInvalid(GuiTextField guiTextField, String retainable, char keyChar, int keyID) {
        if (guiTextField.func_146201_a(keyChar, keyID)) {
            String numericString;
            String originalString = guiTextField.func_146179_b();
            if (!originalString.equals(numericString = CharMatcher.anyOf((CharSequence)retainable).retainFrom((CharSequence)guiTextField.func_146179_b()).replaceAll("^0*", ""))) {
                guiTextField.func_146180_a(numericString);
            }
            if (guiTextField.func_146179_b().length() == 0) {
                guiTextField.func_146180_a("0");
            }
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(GuiLimitedMobSpawner spawnerGUI, Minecraft mc, int par1, int par2, int par3) {
        if (this.isEnabled) {
            this.minSpawnDelay.func_146192_a(par1, par2, par3);
            this.maxSpawnDelay.func_146192_a(par1, par2, par3);
            this.maxToSpawn.func_146192_a(par1, par2, par3);
            this.maxNearbyEntities.func_146192_a(par1, par2, par3);
            this.requiredPlayerRange.func_146192_a(par1, par2, par3);
            this.spawnRangeVertical.func_146192_a(par1, par2, par3);
            this.spawnRangeHorizontal.func_146192_a(par1, par2, par3);
            this.spawnOffsetX.func_146192_a(par1, par2, par3);
            this.spawnOffsetZ.func_146192_a(par1, par2, par3);
            this.spawnOffsetY.func_146192_a(par1, par2, par3);
            if (par3 == 0 && this.toggleDebug.func_146116_c(mc, par1, par2)) {
                if (this.parent.limitedMobSpawner.isDebugEnabled()) {
                    this.parent.limitedMobSpawner.setDebugMode(new NBTTagCompound());
                    this.parent.limitedMobSpawner.syncToServer();
                } else {
                    NBTTagCompound tagToSave = new NBTTagCompound();
                    this.parent.limitedMobSpawner.func_145841_b(tagToSave);
                    this.parent.limitedMobSpawner.setDebugMode(tagToSave);
                    this.parent.limitedMobSpawner.syncToServer();
                }
                mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            if (par3 == 0 && this.resetDebug.func_146116_c(mc, par1, par2)) {
                if (this.parent.limitedMobSpawner.isDebugEnabled()) {
                    this.parent.limitedMobSpawner.loadDebugNBT();
                    this.parent.limitedMobSpawner.setDebugMode(new NBTTagCompound());
                    this.parent.limitedMobSpawner.syncToServer();
                    this.parent.loadGuiFromTileEntity();
                }
                mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
        }
    }

    @Override
    public void mouseHover(int par1, int par2, int par3) {
        if (this.isEnabled) {
            // empty if block
        }
    }

    @Override
    public void render(Minecraft mc, int par1, int par2, float par3, Point screenSize, Point backgroundSize) {
        if (this.isEnabled) {
            if (this.parent.limitedMobSpawner.isDebugEnabled()) {
                this.toggleDebug.field_146124_l = false;
                this.toggleDebug.func_146112_a(mc, par1, par2);
                this.toggleDebug.field_146124_l = true;
            } else {
                this.toggleDebug.func_146112_a(mc, par1, par2);
            }
            this.resetDebug.func_146112_a(mc, par1, par2);
            mc.field_71466_p.func_78276_b("Spawn Delay [Min / Max]", (screenSize.getX() - backgroundSize.getX()) / 2 + 46, (screenSize.getY() - backgroundSize.getY()) / 2 + 26, 0x404040);
            mc.field_71466_p.func_78276_b("Player Activation Range", (screenSize.getX() - backgroundSize.getX()) / 2 + 46, (screenSize.getY() - backgroundSize.getY()) / 2 + 26 + 17, 0x404040);
            mc.field_71466_p.func_78276_b("Maximum To Spawn", (screenSize.getX() - backgroundSize.getX()) / 2 + 46, (screenSize.getY() - backgroundSize.getY()) / 2 + 26 + 34, 0x404040);
            mc.field_71466_p.func_78276_b("Maximum Nearby", (screenSize.getX() - backgroundSize.getX()) / 2 + 46, (screenSize.getY() - backgroundSize.getY()) / 2 + 26 + 51, 0x404040);
            mc.field_71466_p.func_78276_b("Spawn Range [Hor/Ver]", (screenSize.getX() - backgroundSize.getX()) / 2 + 46, (screenSize.getY() - backgroundSize.getY()) / 2 + 26 + 68, 0x404040);
            mc.field_71466_p.func_78276_b("Spawn Offset [X / Z]", (screenSize.getX() - backgroundSize.getX()) / 2 + 46, (screenSize.getY() - backgroundSize.getY()) / 2 + 26 + 85, 0x404040);
            mc.field_71466_p.func_78276_b("[Y]", (screenSize.getX() - backgroundSize.getX()) / 2 + 46 + mc.field_71466_p.func_78256_a("Spawn Offset X / "), (screenSize.getY() - backgroundSize.getY()) / 2 + 26 + 102, 0x404040);
            mc.field_71446_o.func_110577_a(CREATURE_GUI);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Point smallBoxImageLocation = new Point(154, 0);
            Point smallBoxSize = new Point(22, 14);
            Point verySmallBoxSize = new Point(15, 14);
            this.drawBackgroundBox(new Point(175, 21), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.drawBackgroundBox(new Point(199, 21), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.drawBackgroundBox(new Point(199, 38), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.drawBackgroundBox(new Point(199, 55), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.drawBackgroundBox(new Point(199, 72), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.drawBackgroundBox(new Point(175, 89), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.drawBackgroundBox(new Point(199, 89), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.drawBackgroundBox(new Point(199, 123), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.drawBackgroundBox(new Point(175, 106), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.drawBackgroundBox(new Point(199, 106), screenSize, backgroundSize, smallBoxImageLocation, smallBoxSize);
            this.minSpawnDelay.func_146194_f();
            this.maxSpawnDelay.func_146194_f();
            this.maxToSpawn.func_146194_f();
            this.maxNearbyEntities.func_146194_f();
            this.requiredPlayerRange.func_146194_f();
            this.spawnRangeVertical.func_146194_f();
            this.spawnRangeHorizontal.func_146194_f();
            this.spawnOffsetX.func_146194_f();
            this.spawnOffsetZ.func_146194_f();
            this.spawnOffsetY.func_146194_f();
        }
    }

    private void drawBackgroundBox(Point position, Point screenSize, Point backgroundSize, Point imageLocation, Point imageSize) {
        int xCoord = (screenSize.getX() - backgroundSize.getX()) / 2 + position.getX();
        int yCoord = (screenSize.getY() - backgroundSize.getY()) / 2 + position.getY();
        this.drawTexturedModalRect(xCoord, yCoord, imageLocation.getX(), imageLocation.getY(), imageSize.getX(), imageSize.getY());
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(par1 + 0), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a((double)(par1 + par5), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_78381_a();
    }
}

