/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.ParsingHelper;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettingsBase;
import java.util.HashMap;
import java.util.logging.Level;

public class OptionalParser {
    public static Integer parseSingleInteger(String[] values, Integer defaultInt, String parameter) {
        if (values.length == 2) {
            return ParsingHelper.parseFilteredInteger(values[1], defaultInt, parameter);
        }
        ProjectZuluLog.severe("Error Parsing %s Parameter. Invalid Argument Length.", parameter);
        return null;
    }

    public static int[] parseDoubleInteger(String[] values, int[] defaultInts, String parameter) {
        if (values.length == 3) {
            int[] integers = new int[]{ParsingHelper.parseFilteredInteger(values[1], defaultInts[0], "1st " + parameter), ParsingHelper.parseFilteredInteger(values[2], defaultInts[1], "2nd " + parameter)};
            return integers;
        }
        ProjectZuluLog.severe("Error Parsing %s Parameter. Invalid Argument Length.", parameter);
        return null;
    }

    public static int[] parseLight(String[] values) {
        if (values.length == 3) {
            int[] lights = new int[]{ParsingHelper.parseFilteredInteger(values[1], 16, "Min " + Key.light.key), ParsingHelper.parseFilteredInteger(values[2], 16, "Max " + Key.light.key)};
            return lights;
        }
        ProjectZuluLog.severe("Error Parsing deSpawn Light Parameter. Invalid Argument Length.", new Object[0]);
        return null;
    }

    public static ListMultimap<String, Integer> parseBlock(String[] values) {
        ArrayListMultimap blockMeta = ArrayListMultimap.create();
        for (int j = 1; j < values.length; ++j) {
            int minMeta = 0;
            int maxMeta = 0;
            String[] idMetaParts = values[j].split("-");
            String blockID = idMetaParts[0];
            for (int k = 0; k < idMetaParts.length; ++k) {
                if (k == 0) continue;
                if (k == 1) {
                    String[] rangeParts = idMetaParts[k].split(">");
                    for (int l = 0; l < rangeParts.length; ++l) {
                        if (l == 0) {
                            minMeta = ParsingHelper.parseFilteredInteger(rangeParts[l], minMeta, "parseMinMetaID");
                            continue;
                        }
                        if (l == 1) {
                            maxMeta = ParsingHelper.parseFilteredInteger(rangeParts[l], maxMeta, "parseMaxMetaID");
                            continue;
                        }
                        ProjectZuluLog.warning("Block entry %s contains too many > elements.", values[j]);
                    }
                    continue;
                }
                ProjectZuluLog.warning("Block entry %s contains too many - elements.", values[j]);
            }
            maxMeta = minMeta > maxMeta ? minMeta : maxMeta;
            for (int meta = minMeta; meta <= maxMeta; ++meta) {
                ProjectZuluLog.debug(Level.INFO, "Would be adding (%s,%s)", blockID, meta);
                blockMeta.put((Object)blockID, (Object)meta);
            }
        }
        return !blockMeta.isEmpty() ? blockMeta : null;
    }

    public static void parseBlockRange(String[] values, HashMap<String, Object> valueCache) {
        if (values.length == 4) {
            valueCache.put(Key.blockRangeX.key, ParsingHelper.parseFilteredInteger(values[1], OptionalSettingsBase.defaultBlockRange, "blockRangeX"));
            valueCache.put(Key.blockRangeY.key, ParsingHelper.parseFilteredInteger(values[2], OptionalSettingsBase.defaultBlockRange, "blockRangeY"));
            valueCache.put(Key.blockRangeZ.key, ParsingHelper.parseFilteredInteger(values[3], OptionalSettingsBase.defaultBlockRange, "blockRangeZ"));
        } else if (values.length == 2) {
            valueCache.put(Key.blockRangeX.key, ParsingHelper.parseFilteredInteger(values[1], OptionalSettingsBase.defaultBlockRange, "blockRangeX"));
            valueCache.put(Key.blockRangeY.key, ParsingHelper.parseFilteredInteger(values[1], OptionalSettingsBase.defaultBlockRange, "blockRangeY"));
            valueCache.put(Key.blockRangeZ.key, ParsingHelper.parseFilteredInteger(values[1], OptionalSettingsBase.defaultBlockRange, "blockRangeZ"));
        } else {
            ProjectZuluLog.severe("Error Parsing deSpawn block search range Parameter. Invalid Argument Length.", new Object[0]);
        }
    }

    public static void parseSpawnRate(String[] values, HashMap<String, Object> valueCache) {
        if (values.length == 2) {
            valueCache.put(Key.spawnRate.key, ParsingHelper.parseFilteredInteger(values[1], OptionalSettingsBase.defaultSpawnRate, Key.spawnRate.key));
        } else {
            ProjectZuluLog.severe("Error Parsing deSpawn spawn rate Parameter. Invalid Argument Length.", new Object[0]);
        }
    }

    public static void parseSpawnRange(String[] values, HashMap<String, Object> valueCache) {
        if (values.length == 2) {
            valueCache.put(Key.spawnRange.key, ParsingHelper.parseFilteredInteger(values[1], 32, Key.spawnRange.key));
        } else {
            ProjectZuluLog.severe("Error Parsing spawnRange parameter. Invalid Argument Length.", new Object[0]);
        }
    }

    @Deprecated
    public static Boolean parseSky(String[] values) {
        if (values.length == 1) {
            if (Key.sky.key.equalsIgnoreCase(values[0])) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        ProjectZuluLog.severe("Error Parsing Needs Sky parameter. Invalid Argument Length.", new Object[0]);
        return null;
    }

    public static void parseEntityCap(String[] values, HashMap<String, Object> valueCache) {
        if (values.length == 2) {
            valueCache.put(Key.entityCap.key, ParsingHelper.parseFilteredInteger(values[1], 0, Key.entityCap.key));
        } else {
            ProjectZuluLog.severe("Error Parsing Needs EntityCap parameter. Invalid Argument Length.", new Object[0]);
        }
    }

    public static void parseDespawnAge(String[] values, HashMap<String, Object> valueCache) {
        if (values.length == 2) {
            valueCache.put(Key.despawnAge.key, ParsingHelper.parseFilteredInteger(values[1], 600, Key.despawnAge.key));
        } else {
            ProjectZuluLog.severe("Error Parsing Needs EntityCap parameter. Invalid Argument Length.", new Object[0]);
        }
    }

    public static Integer parseMinSpawnHeight(String[] values) {
        if (values.length == 2) {
            return ParsingHelper.parseFilteredInteger(values[1], 256, Key.minSpawnHeight.key);
        }
        ProjectZuluLog.severe("Error Parsing Min Spawn Height parameter. Invalid Argument Length.", new Object[0]);
        return null;
    }

    public static Integer parseMaxSpawnHeight(String[] values) {
        if (values.length == 2) {
            return ParsingHelper.parseFilteredInteger(values[1], -1, Key.maxSpawnHeight.key);
        }
        ProjectZuluLog.severe("Error Parsing Max Spawn Height parameter. Invalid Argument Length.", new Object[0]);
        return null;
    }
}

